<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::addIncludePath(T3_PATH . '/html/com_content');
JHtml::addIncludePath(dirname(dirname(__FILE__)));
if(version_compare(JVERSION, '3.0', 'lt')){
	JHtml::_('behavior.tooltip');
}
JHtml::_('behavior.framework');

// Create some shortcuts.
$params = & $this->item->params;
$n = count($this->items);
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

// check for at least one editable article
$isEditable = false;
if (!empty($this->items)) {
	foreach ($this->items as $article) {
		if ($article->params->get('access-edit')) {
			$isEditable = true;
			break;
		}
	}
}
?>

<?php if (empty($this->items)) : ?>

	<?php if ($this->params->get('show_no_articles', 1)) : ?>
		<p><?php echo JText::_('COM_CONTENT_NO_ARTICLES'); ?></p>
	<?php endif; ?>

<?php else : ?>

<form action="<?php echo htmlspecialchars(JUri::getInstance()->toString()); ?>" method="post" name="adminForm"
	  id="adminForm" class="form-inline">
	<?php if ($this->params->get('show_headings') || $this->params->get('filter_field') != 'hide' || $this->params->get('show_pagination_limit')) : ?>
		<fieldset class="filters alert alert-info">
			<?php if ($this->params->get('filter_field') != 'hide') : ?>

				<label class="filter-search-lbl"
					   for="filter-search"><?php echo JText::_('COM_CONTENT_' . $this->params->get('filter_field') . '_FILTER_LABEL') . '&#160;'; ?></label>
				<input type="text" name="filter-search" id="filter-search"
					   value="<?php echo $this->escape($this->state->get('list.filter')); ?>" class="input cold-sm-2"
					   onchange="document.adminForm.submit();"
					   title="<?php echo JText::_('COM_CONTENT_FILTER_SEARCH_DESC'); ?>"
					   placeholder="<?php echo JText::_('COM_CONTENT_' . $this->params->get('filter_field') . '_FILTER_LABEL'); ?>"/>

			<?php endif; ?>

			<?php if ($this->params->get('show_pagination_limit')) : ?>
				<label>
					<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>
				</label>
				<?php echo $this->pagination->getLimitBox(); ?>

			<?php endif; ?>

			<!-- @TODO add hidden inputs -->
			<input type="hidden" name="filter_order" value=""/>
			<input type="hidden" name="filter_order_Dir" value=""/>
			<input type="hidden" name="limitstart" value=""/>
			<input type="hidden" name="task" value=""/>
		</fieldset>
	<?php endif; ?>

	<table class="category table table-striped table-bordered table-hover">
		<?php if ($this->params->get('show_headings')) : ?>
			<thead>
			<tr>
				<th class="list-title" id="categorylist_header_title">
					<?php echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
				</th>
				<?php if ($date = $this->params->get('list_show_date')) : ?>
					<th class="list-date" id="categorylist_header_date">
						<?php if ($date == "created") : ?>
							<?php echo JHtml::_('grid.sort', 'COM_CONTENT_' . $date . '_DATE', 'a.created', $listDirn, $listOrder); ?>
						<?php elseif ($date == "modified") : ?>
							<?php echo JHtml::_('grid.sort', 'COM_CONTENT_' . $date . '_DATE', 'a.modified', $listDirn, $listOrder); ?>
						<?php
						elseif ($date == "published") : ?>
							<?php echo JHtml::_('grid.sort', 'COM_CONTENT_' . $date . '_DATE', 'a.publish_up', $listDirn, $listOrder); ?>
						<?php endif; ?>
					</th>
				<?php endif; ?>
				<?php if ($this->params->get('list_show_author', 1)) : ?>
					<th class="list-author" id="categorylist_header_author">
						<?php echo JHtml::_('grid.sort', 'JAUTHOR', 'author', $listDirn, $listOrder); ?>
					</th>
				<?php endif; ?>
				<?php if ($this->params->get('list_show_hits', 1)) : ?>
					<th class="list-hits" id="categorylist_header_hits">
						<?php echo JHtml::_('grid.sort', 'JGLOBAL_HITS', 'a.hits', $listDirn, $listOrder); ?>
					</th>
				<?php endif; ?>
				<?php if ($isEditable) : ?>
					<th id="categorylist_header_edit">
						<?php echo JText::_('COM_CONTENT_EDIT_ITEM'); ?>
					</th>
				<?php endif; ?>
			</tr>
			</thead>
		<?php endif; ?>
		<tbody>

		<?php foreach ($this->items as $i => $article) : ?>
			<?php if ($this->items[$i]->state == 0) : ?>
				<tr class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
			<?php else: ?>
				<tr class="cat-list-row<?php echo $i % 2; ?>" >
			<?php endif; ?>
			<?php if (in_array($article->access, $this->user->getAuthorisedViewLevels())) : ?>

				<td headers="categorylist_header_title" class="list-title">
					<a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($article->slug, $article->catid)); ?>">
						<?php echo $this->escape($article->title); ?>
					</a>

					<?php if ($article->params->get('access-edit')) : ?>
						<ul class="actions">
							<li class="edit-icon">
								<?php echo JHtml::_('icon.edit', $article, $params); ?>
							</li>
						</ul>
					<?php endif; ?>
				</td>

				<?php if ($this->params->get('list_show_date')) : ?>
					<td headers="categorylist_header_date" class="list-date">
						<?php
						echo JHtml::_(
							'date', $article->displayDate,
							$this->escape($this->params->get('date_format', JText::_('DATE_FORMAT_LC3')))
						); ?>
					</td>
				<?php endif; ?>

				<?php if ($this->params->get('list_show_author', 1)) : ?>
					<td headers="categorylist_header_author" class="list-author">
						<?php if (!empty($article->author) || !empty($article->created_by_alias)) : ?>
							<?php $author = $article->author ?>
							<?php $author = ($article->created_by_alias ? $article->created_by_alias : $author); ?>

							<?php if (!empty($article->contactid) && $this->params->get('link_author') == true): ?>
								<?php echo JHtml::_('link', JRoute::_('index.php?option=com_contact&view=contact&id=' . $article->contactid), $author); ?>
							<?php else : ?>
								<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', '<strong>' . $author . '<strong>'); ?>
							<?php endif; ?>
						<?php endif; ?>
					</td>
				<?php endif; ?>
				<?php if ($this->params->get('list_show_hits', 1)) : ?>
					<td headers="categorylist_header_hits" class="list-hits">
						<span class="badge badge-info">
							<?php echo $article->hits; ?>
						</span>
					</td>
				<?php endif; ?>
				<?php if ($isEditable) : ?>
					<td headers="categorylist_header_edit" class="list-edit">
						<?php if ($article->params->get('access-edit')) : ?>
							<?php echo JHtml::_('icon.edit', $article, $params); ?>
						<?php endif; ?>
					</td>
				<?php endif; ?>

			<?php else : // Show unauth links. ?>
				<td>
					<?php
					echo $this->escape($article->title) . ' : ';
					$menu = JFactory::getApplication()->getMenu();
					$active = $menu->getActive();
					$itemId = $active->id;
					$link = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId);
					$returnURL = JRoute::_(ContentHelperRoute::getArticleRoute($article->slug));
					$fullURL = new JURI($link);
					$fullURL->setVar('return', base64_encode($returnURL));
					?>
					<a href="<?php echo $fullURL; ?>" class="register">
						<?php echo JText::_('COM_CONTENT_REGISTER_TO_READ_MORE'); ?></a>
				</td>
			<?php endif; ?>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
	<?php endif; ?>

	<?php // Code to add a link to submit an article. ?>
	<?php if ($this->category->getParams()->get('access-create')) : ?>
		<?php echo JHtml::_('icon.create', $this->category, $this->category->params); ?>
	<?php endif; ?>

	<?php // Add pagination links ?>
	<?php if (!empty($this->items)) : ?>
	<?php if (($this->params->def('show_pagination', 2) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>
		<div class="pagination-wrap">

			<?php if ($this->params->def('show_pagination_results', 1)) : ?>
				<div class="counter">
					<?php echo $this->pagination->getPagesCounter(); ?>
				</div>
			<?php endif; ?>

			<?php echo $this->pagination->getPagesLinks(); ?>
		</div>
	<?php endif; ?>
</form>
<?php endif; ?>
