<?php
/**
* @version 1.0
* @package BreezingForms Download
* @copyright (C) 2013 by Markus Bopp
* @license Released under the terms of the GNU General Public License
**/

/** ensure this file is being included by a parent file */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.plugin.plugin' );

class plgContentBreezingforms_download extends JPlugin {

    function __construct( &$subject, $params )
    {
        parent::__construct($subject, $params);
    }
    
    function mime_content_type($filename) {

        $mime_types = array(

            'txt' => 'text/plain',
            'htm' => 'text/html',
            'html' => 'text/html',
            'php' => 'text/html',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'json' => 'application/json',
            'xml' => 'application/xml',
            'swf' => 'application/x-shockwave-flash',
            'flv' => 'video/x-flv',

            // images
            'png' => 'image/png',
            'jpe' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpeg',
            'gif' => 'image/gif',
            'bmp' => 'image/bmp',
            'ico' => 'image/vnd.microsoft.icon',
            'tiff' => 'image/tiff',
            'tif' => 'image/tiff',
            'svg' => 'image/svg+xml',
            'svgz' => 'image/svg+xml',

            // archives
            'zip' => 'application/zip',
            'rar' => 'application/x-rar-compressed',
            'exe' => 'application/x-msdownload',
            'msi' => 'application/x-msdownload',
            'cab' => 'application/vnd.ms-cab-compressed',

            // audio/video
            'mp3' => 'audio/mpeg',
            'qt' => 'video/quicktime',
            'mov' => 'video/quicktime',

            // adobe
            'pdf' => 'application/pdf',
            'psd' => 'image/vnd.adobe.photoshop',
            'ai' => 'application/postscript',
            'eps' => 'application/postscript',
            'ps' => 'application/postscript',

            // ms office
            'doc' => 'application/msword',
            'rtf' => 'application/rtf',
            'xls' => 'application/vnd.ms-excel',
            'ppt' => 'application/vnd.ms-powerpoint',

            // open office
            'odt' => 'application/vnd.oasis.opendocument.text',
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        );

        $ext = strtolower(array_pop(explode('.',$filename)));
        if (array_key_exists($ext, $mime_types)) {
            return $mime_types[$ext];
        }
        elseif (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME);
            $mimetype = finfo_file($finfo, $filename);
            finfo_close($finfo);
            return $mimetype;
        }
        else {
            return 'application/octet-stream';
        }
    }

    
    /**
     * Joomla 1.5 compatibility
     */
    
    function onPrepareContent(&$article, &$params2, $limitstart = 0 )
    {
        $this->onContentPrepare('', $article, $params2, $limitstart);
    }

    function onContentPrepare($context, &$article, &$params2, $limitstart = 0) {
        
        jimport('joomla.filesystem.file');
        jimport('joomla.filesystem.folder');
        
        if(!JFile::exists(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_breezingforms'.DS.'breezingforms.php')){
            return true;
        }
        
        $protect = false;
        
        jimport('joomla.version');
        $version = new JVersion();
        
        if(version_compare($version->getShortVersion(), '3.0', '<')){
            $plugin = JPluginHelper::getPlugin('content', 'breezingforms_download');
            jimport( 'joomla.html.parameter' );
            $pluginParams = new JParameter($plugin->params);
        }else{
            $params = new JRegistry;
            $params->loadString($this->params);
            $pluginParams = $params;
        }
        
        $lang = JFactory::getLanguage();
        $lang->load('plg_content_breezingforms_download', JPATH_ADMINISTRATOR);
        
        if(!JFolder::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms')) {
            JFolder::create(JPATH_SITE . DS . 'media' . DS . 'breezingforms');
        }
        
        if(!JFile::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'index.html')) JFile::write(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'index.html', $def = '');
        
        if(!JFolder::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins')) {
            JFolder::create(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins');
        }
        
        if(!JFile::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'index.html')) JFile::write(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'index.html', $def = '');
        
        if(!JFolder::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'download')) {
            JFolder::create(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'download');
        }
        
        if(!JFile::exists(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'download' . DS . 'index.html')) JFile::write(JPATH_SITE . DS . 'media' . DS . 'breezingforms' . DS . 'plugins' . DS . 'download' . DS . 'index.html', $def = '');
        
        if(isset($article->text)){
            
            $db = JFactory::getDBO();
            
            $matches = array();
            
            preg_match_all("/\{BFDownload([^}]*)\}/i", $article->text, $matches);
            
            if(isset($matches[0]) && is_array($matches[0]) && isset($matches[1]) && is_array($matches[1])){
                
                $record = null;
                $default_title = '';
                $protect = 0;
                $form_id = 0;
                $record_id = 0;
                $type = '';
                
                $frontend = true;
                if (JFactory::getApplication()->isAdmin()) {
                    $frontend = false;
                }
                
                if(!trim($default_title)){
                    $default_title = strtotime('now');
                }

                $i = 0;
                foreach($matches[1] As $match){
                    
                    $out = '';
                    $field = '';
                    $box_style = '';
                    $info_style = '';
                    $align = '';
                    $info = true;
                    $hide_filename = false;
                    $hide_mime = false;
                    $hide_size = false;
                    $hide_downloads = false;
                    $form_id = 0;
                    $record_id = 0;
                    $protect = false;
                    $class = '';
                                             
                    $options = explode(';', trim($match));
                    foreach($options As $option){
                        $keyval = explode(':',trim($option), 2);
                        if(count($keyval) == 2){
                            
                            $value = trim($keyval[1]);
                            switch(strtolower(trim($keyval[0]))){
                                case 'record-id':
                                    $record_id = intval($value);
                                    break;
                                case 'form-id':
                                    $form_id = intval($value);
                                    break;
                                case 'class':
                                    $class = $value;
                                    break;
                                case 'protect':
                                    $protect = $value == 'true' ? true : false;
                                    break;
                                case 'field':
                                    $field = $value;
                                    break;
                                case 'info-style':
                                    $info_style = $value;
                                    break;
                                case 'box-style':
                                    $box_style = $value;
                                    break;
                                case 'align':
                                    $align = $value;
                                    break;
                                case 'info':
                                    $info = $value == 'true' ? true : false;
                                    break;
                                case 'hide-filename':
                                    $hide_filename = $value == 'true' ? true : false;
                                    break;
                                case 'hide-mime':
                                    $hide_mime = $value == 'true' ? true : false;
                                    break;
                                case 'hide-size':
                                    $hide_size = $value == 'true' ? true : false;
                                    break;
                                case 'hide-downloads':
                                    $hide_downloads = $value == 'true' ? true : false;
                                    break;
                            }
                        }
                    }
                    
                    $db->setQuery("Select tags_content_template_default_element From #__facileforms_forms Where id = " . intval($form_id));
                    $form = $db->loadObject();
                    
                    if($form->tags_content_template_default_element){
                        $default_title = $form->tags_content_template_default_element;
                    }
                    
                    $db->setQuery("Select * From #__facileforms_subrecords Where `record` = " . intval($record_id));
                    $record = $db->loadObjectList();
                    
                    $is_series = false;
                    
                    if ($field && isset($record) && $record !== null) {

                       foreach ($record As $item){
                           if( $default_title == $item->id ){
                            $default_title = $item->value;
                            break;
                           }
                       }

                       foreach ($record As $item){

                           if($item->name == $field && $item->type == 'File Upload'){

                                $the_files = explode("\n", str_replace("\r",'',$item->value));

                                $the_files_size = count($the_files);

                                if($the_files_size > 0){
                                   $is_series = true;
                                }

                                for($fcnt = 0; $fcnt < $the_files_size; $fcnt++){

                                    $the_value = str_replace(array('{CBSite}','{cbsite}'), JPATH_SITE, trim($the_files[$fcnt]));

                                    if ($the_value) {

                                       $exists = JFile::exists( $the_value );

                                       if($exists){

                                           $phpversion  = explode('-',phpversion());
                                           $phpversion  = $phpversion[0];
                                           // because of mime_content_type deprecation
                                           if(version_compare($phpversion, '5.3', '<')){
                                                if(function_exists('mime_content_type')){
                                                    $mime = mime_content_type($the_value);
                                                }else{
                                                    // fallback if not even that one exists
                                                    $mime = $this->mime_content_type($the_value);
                                                }
                                           }else{
                                                if(function_exists('finfo_open')){
                                                    $finfo = finfo_open(FILEINFO_MIME_TYPE);
                                                    $mime  = finfo_file($finfo, $the_value);
                                                    finfo_close($finfo);
                                                }else{
                                                    $mime = $this->mime_content_type($the_value);
                                                }
                                           }

                                           if(JRequest::getVar('breezingforms_download_file', '', 'GET', 'STRING', JREQUEST_ALLOWRAW) == sha1($field.$the_value)){

                                                 $download_name = basename(JFilterOutput::stringURLSafe($default_title).'_'.$the_value);
                                                 // clean up before displaying
                                                 @ob_end_clean();

                                                 header('Content-Type: application/octet-stream; name="'.$download_name.'"');
                                                 header('Content-Disposition: inline; filename="'.$download_name.'"');
                                                 header('Content-Length: ' . @filesize($the_value));

                                                 // NOTE: if running IIS and CGI, raise the CGI timeout to serve large files
                                                 @$this->readfile_chunked($the_value);

                                                 exit;
                                             }

                                             $info_style_ = $info_style;
                                             $box_style_  = $box_style;
                                             $info_       = $info;
                                             $align_      = $align;
                                             
                                             $download_name = basename(JFilterOutput::stringURLSafe($default_title).'_'.$the_value);
                                             
                                             $hits = 0;
                                             
                                             $size = @number_format(filesize($the_value)/(1024*1024),2) . ' MB';
                                             if(!floatval($size)){
                                                 $size = @number_format(filesize($the_value)/(1024),2) . ' kb';
                                             }
                                             
                                             $hide_filename_ = $hide_filename;
                                             $hide_mime_ = $hide_mime;
                                             $hide_size_ = $hide_size;
                                             
                                             $url = JURI::getInstance()->toString();

                                             $open_ = JRoute::_($url.(strstr($url,'?') !== false ? '&' : '?').'breezingforms_download_file='.  sha1($field.$the_value));

                                             $out .= '<div class="'.$class.'" style="'.($align_ ? 'float: '.$align_.';' : '' ). str_replace('::',';',$box_style_).'">
                                                        <a href="'.$open_.'">'.JText::_('COM_BREEZINGFORMS_PLUGIN_DOWNLOAD_DOWNLOAD').'</a>'
                                                     .($info_ ? 
                                                                '<div style="'.(str_replace('::',';',$info_style_)).'">
                                                                    '.($hide_filename_ ? '' : '<span class="bfPluginDownloadFilename">'.JText::_('COM_BREEZINGFORMS_PLUGIN_DOWNLOAD_FILENAME').':</span> '.$download_name.'<br/>').'
                                                                    '.($hide_mime_ ? '' : '<span class="bfPluginDownloadMime">'.JText::_('COM_BREEZINGFORMS_PLUGIN_DOWNLOAD_MIME').':</span> '.$mime.'<br/>').'
                                                                    '.($hide_size_ ? '' : '<span '.($hide_size_ ? ' style="display:none;" ' : '').'class="bfPluginDownloadSize">'.JText::_('COM_BREEZINGFORMS_PLUGIN_DOWNLOAD_SIZE').':</span> '.$size.'<br/>').'
                                                                 </div>' : '').'</div>';

                                             if($is_series && $align_ && (strtolower($align_) == 'left' || strtolower($align_) == 'right' )){
                                                 $out .= '<div style="float:'.strtolower($align_).';width: 5px;">&nbsp;</div>';
                                             }
                                        }
                                    }
                               }
                           }
                       }
                    }
                    
                    if($is_series && $align && (strtolower($align) == 'left' || strtolower($align) == 'right' )){
                        $out .= '<div style="clear:'.strtolower($align).';"></div>';
                    }
                    
                    $article->text = str_replace($matches[0][$i], $out, $article->text);
        
                    $i++;
                }
            }
        }

	return true;
    }
    
    function readfile_chunked ($filename) {
      $chunksize = 1*(1024*1024); // how many bytes per chunk
      $buffer = '';
      $handle = @fopen($filename, 'rb');
      if ($handle === false) {
        return false;
      }
      while (!@feof($handle)) {
        $buffer = @fread($handle, $chunksize);
        print $buffer;
      }
      return @fclose($handle);
    }
}