<?php
/**
* @copyright	@copyright	Copyright (c) 2017 iBroker (http://www.ibroker.net.au/). All rights reserved.
* @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die;

// include the syndicate functions only once
require_once __DIR__ . '/helper.php';

// configurable elements
$postcode_label     = $params->get('postcode_label', 'What is your postcode?');
$postcode_tooltip   = $params->get('postcode_tooltip', '<p>The various State and Territory Governments apply different Stamp Duty rates to insurance purchases. So we can calculate the correct premium for you, we need to know what postcode you live in.</p>');
$device_label       = $params->get('device_label', 'Type of device');
$device_tooltip     = $params->get('device_tooltip', '<p>There are 2 types of devices:</p>
<ol>
<li><strong>Laptop</strong> &mdash; A device that opens and closes in a clam-shell action. This type of device includes Convertibles, Hybrids and Transformer-type devices (that is, the screen can swivel, fold or turn to create a Tablet-type surface).
<br />
</li>
<li><strong>Tablet</strong> &mdash; A device that consists of only a screen, which may or may not have a keyboard that can be attached, but does not open and close in a clam-shell action.
<br />
</li>
</ol>');
$make_label         = $params->get('make_label', 'Make of device');
$make_tooltip       = $params->get('make_tooltip', '<p>Please specify the Make or brand of your device.</p>');
$suminsured_label   = $params->get('suminsured_label', 'Sum insured');
$suminsured_tooltip = $params->get('suminsured_tooltip', '<p>This amount should represent the ex-GST Recommended Retail Price of the device you wish to insure. It should include all hardware accessories (including bags, protective cases, external hard drives, attachable keyboards, etc.), but exclude software.</p>');
$promocode_label    = $params->get('promocode_label', 'Promo code');
$promocode_tooltip  = $params->get('promocode_tooltip', '<p>If you have received a Promotion Code from an Education Institution, Laptop Supplier, or Financier, enter it here.</p>');
$associate_form     = $params->get('associate_form', '0');
$onsitecover_tooltip = $params->get('onsitecover_tooltip', '<p>For an extra $11.00 (inc GST) we can arrange for Unisys to carry out any accidental damage repair that forms part of a valid claim under this insurance. This means that Unisys will contact you after your claim has been registered and make arrangements to carry out the necessary repairs at your chosen location - at home, work or school. Unisys is a worldwide IT services company and Apple’s premier service agent in Australia.</p>');
$device_types       = modquoteformHelper::getDeviceTypes();

// request variables
$q_postcode = JRequest::getVar('p', '');
if ($q_postcode !== '') {
  $q_postcode = intval($q_postcode);
}
$q_device = JRequest::getVar('d', 0);
$q_make = JRequest::getVar('m', '');
$q_insured = JRequest::getVar('i', '');
if ($q_insured !== '') {
  $q_insured = floatval($q_insured);
}
$q_promocode = JRequest::getVar('c', '');
$q_referrer = JRequest::getVar('ref', '');

$session = JFactory::getSession();
$referrer = $session->get('ibroker_referrer');
if (empty($referrer)) {
  $referrer = $q_referrer;
}
if (!empty($referrer)) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')->from($db->quoteName('#__ibroker_referralcode'));
    $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_field_name').' = '."'promo_code'");
    $db->setQuery($query);
    $results = $db->loadObjectList();
    foreach ($results as $vresult) {
      if (!empty($vresult->domain_field_value)) {
        $q_promocode = $vresult->domain_field_value;
        break;
      }
    }
}

require(JModuleHelper::getLayoutPath('mod_quoteform', $params->get('layout', 'default')));
