<?php
defined('_JEXEC') or die;

ini_set('error_reporting', E_ALL ^ E_DEPRECATED);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require_once dirname(__FILE__).'/dBug.php';

# --- MPGS NEW PAYMENT SETTINGS (2023-07-27) ----------------------------------
define('MPGS_NEW_PAYMENT_URL', 'https://test-tyro.mtf.gateway.mastercard.com/api/rest');
define('MPGS_NEW_PAYMENT_VER', 73);
define('MPGS_NEW_CURL_DEBUG', false);
define('MPGS_NEW_MERCHANT_ID', 'TESTTYRO_122710');
define('MPGS_NEW_API_USERNAME', 'merchant.' . MPGS_NEW_MERCHANT_ID);
define('MPGS_NEW_API_PASSWORD', '6637d8fc6b397e4617235e86716734ef');
define('MPGS_NEW_PRICE_OVERRIDE', 0); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

# --- DEPRECATED SETTINGS (NEW PAYMENT METHOD AVAILABLE) ----------------------
# Payment merchant settings.
define('MIGS_NEW_PAYMENT_URL', 'https://bendigo.ap.gateway.mastercard.com/api/rest');
define('MIGS_NEW_PAYMENT_VER', 34);
define('MIGS_NEW_CURL_DEBUG', false);
define('MIGS_NEW_MERCHANT_ID', 'BBL9576596');
define('MIGS_NEW_API_USERNAME', 'merchant.' . MIGS_NEW_MERCHANT_ID);
define('MIGS_NEW_API_PASSWORD', 'dc923788c384cf98ebef8e21cc6e44da');
define('MIGS_NEW_PRICE_OVERRIDE', 0); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

# --- DEPRECATED SETTINGS (NEW PAYMENT METHOD AVAILABLE) ----------------------
# Payment merchant settings.
define('MIGS_SECURE_SECRET', '3A46D4AE6ED8D9D841787E1630B9F946');
define('MIGS_ACCESS_CODE', '9DD56372');
define('MIGS_MERCHANT_ID', 'BBL9576596');
define('MIGS_PAYMENT_URL', 'https://migs.mastercard.com.au/vpcpay'); // Live payment.
#define('MIGS_PAYMENT_URL', 'https://migs-mtf.mastercard.com.au/vpcpay'); // Test payment.
define('MIGS_PRICE_OVERRIDE', 0); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

# -- ATTVEST FINANCE INTEGRATION SETTINGS -------------------------------------
#define('ATTVEST_PAYMENT_URL', 'https://chrono.tecsico.com.au'); // Test mode
define('ATTVEST_PAYMENT_URL', 'https://www.quib.com.au'); // Live mode
#define('ATTVEST_AUTH_CODE', 'b8ea4c08-7ea0-4b16-953e-131e5d0109a7'); // Test mode
define('ATTVEST_AUTH_CODE', '715ba86b-61ba-42d5-a654-b4baed215677'); // Live mode
# -----------------------------------------------------------------------------

define('IBROKER_POLICY_RECIPIENT', 'info@ibroker.net.au');
define('IBROKER_DEFAULT_EXCESS', 100);
define('IBROKER_GST', 10);
define('IBROKER_DEFAULT_UNDERWRITER', 1);
define('IBROKER_DEFAULT_YEARLY_INTEREST_RATE', 7);
define('IBROKER_DEFAULT_QUOTE_COUNTRY', 'AUSTRALIA');
define('IBROKER_DEFAULT_API_TAG', '[API]');

define('IBROKER_REFERRAL_CODE_KEY', 'ref');
define('IBROKER_QUOTE_FORM_MODULE_POSITION', 'associate-quote');
define('IBROKER_UNISYS_COVER_PREMIUM_INC_GST', 11.00);

class IO
{
  public static function getDevices() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('id')->from($db->quoteName('#__ibroker_devicetype'))->where('`state` = 1');
    $db->setQuery($query);

    $results = $db->loadObjectList();
    $devices = array();
    foreach ($results as $result) {
      $devices[$result->id] = self::getDevice($result->id);
    }

    return $devices;
  }

  public static function getDevice($id) {
    $device = self::sqlSelect('#__ibroker_devicetype', array(
      'column' => 'id',
      'operator' => '=',
      'value' => intval($id),
      ));

    // get device's makes/brands
    if (!empty($device->device_makes)) {
      $device->device_makes = explode(',', $device->device_makes);
    } else {
      $device->device_makes = array();
    }

    $device->parameter = array();
    if (!empty($device->device_options)) {
      $device->parameter = parse_ini_string($device->device_options, true);
      foreach ($device->parameter as $key => $value) {
        $values = explode(',', $value);
        foreach ($values as $detail_key => $detail_value) {
          $detail_values = explode('|', $detail_value);
          if (count($detail_values) == 1) {
            $values[$detail_key] = $detail_values[0];
          } else {
            $values[$detail_key] = $detail_values;
          }
        }
        $device->parameter[$key] = $values;
      }
    }
    $device->parameter['make'] = $device->device_makes;

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('*')->from($db->quoteName('#__ibroker_formula'))->where('`state` = 1 AND `device` = '.intval($id));
    $db->setQuery($query);
    $results = $db->loadObjectList();
    // expand parameters
    foreach ($results as $result) {
      $result->parameter = parse_ini_string(@$result->parameter, true);
      foreach ($result->parameter as $key => $value) {
        $values = explode(',', $value);
        foreach ($values as $detail_key => $detail_value) {
          $detail_values = explode('|', $detail_value);
          if (count($detail_values) == 1) {
            $values[$detail_key] = $detail_values[0];
          } else {
            $values[$detail_key] = $detail_values;
          }
        }
        $result->parameter[$key] = $values;
      }
      $device->underwriter[$result->uw_id] = $result;
    }

    // for legacy purposes
    $device->make = $device->device_makes;
    $device->device = $device->device_name;
    $device->name = $device->device_name;

    return $device;
  }

  public static function getUnderwriter($id) {
    $underwriter = self::sqlSelect('#__ibroker_underwriter', array(
      'column' => 'id',
      'operator' => '=',
      'value' => intval($id),
      ));
    return $underwriter;
  }

  public static function getUnderwriterName($id) {
    $underwriter = self::getUnderwriter($id);
    if (!empty($underwriter->uw_name)) {
      return $underwriter->uw_name;
    }
    return '';
  }

  public static function getUnderwriterLink($id) {
    $underwriter = self::getUnderwriter($id);
    if (!empty($underwriter->uw_name)) {
      return '<a href="'.JRoute::_('index.php?option=com_ibroker_underwriter&task=underwriter.edit&id='.$id).'">'.$underwriter->uw_name.'</a>';
    }
    return '';
  }

  public static function getQuotes($device_id, $parameters = array()) {
    $device = self::getDevice($device_id);
    $quotes = array();
    if (!empty($device->underwriter)) {
      foreach ($device->underwriter as $underwriter_id => $underwriter_data) {
        $quote_data = self::getQuote($device_id, $underwriter_id, $parameters);
        if (!empty($quote_data)) {
          $quotes[$underwriter_id] = $quote_data;
        }
      }
    }
    return $quotes;
  }

  public static function getQuote($device_id, $underwriter_id, $parameters = array()) {
    $device = self::getDevice($device_id);
    $formula = $device->underwriter[ $underwriter_id ];

    $available = array();

    $underwriter_data = self::getUnderwriter($underwriter_id);
    $available['underwriter_id'] = $underwriter_id;
    $available['underwriter_name'] = $underwriter_data->uw_name;
    $available['underwriter_opts'] = parse_ini_string($underwriter_data->uw_options, true);
    $available['underwriter_data'] = $underwriter_data;

    $com_params = JComponentHelper::getParams('com_ibroker_formula');

    $associate = 0;
    $onsite = 0;
    $monthly = 0;

    extract($parameters);

    if (!empty($formula->parameter)) {
      $available['parameter'] = $formula->parameter;
    }

    $sum_insured = floatval($sum_insured);

    if (!empty($formula->parameter['min_insured_threshold'])) {
      $min_insured_threshold = floatval($formula->parameter['min_insured_threshold'][0]);
    }

    if (!empty($formula->parameter['min_insured'])) {
      $min_insured = floatval($formula->parameter['min_insured'][0]);
      if (!empty($min_insured_threshold) && $sum_insured <= $min_insured_threshold) {
      } else if ($sum_insured < $min_insured) {
        $sum_insured = $min_insured;
      }
    }

    if (!empty($formula->parameter['max_insured_threshold'])) {
      $max_insured_threshold = floatval($formula->parameter['max_insured_threshold'][0]);
    }

    if (!empty($formula->parameter['max_insured'])) {
      $max_insured = floatval($formula->parameter['max_insured'][0]);
      if (!empty($max_insured_threshold) && $sum_insured >= $max_insured_threshold) {
      } else if ($sum_insured > $max_insured) {
        $sum_insured = $max_insured;
      }
    }

    if (empty($formula->parameter['excess'])) {
      $formula->parameter['excess'] = array(0);
    } else {
      if (!empty($formula->parameter['excess_rule'])) {
        foreach ($formula->parameter['excess_rule'] as $excess_rules) {
          $excess_values = explode(';', $excess_rules[0]);
          $excess_rule = $excess_rules[1];
          $excess_check = 'return ('.$excess_rule.') ? true : false;';
          if (eval($excess_check) === true) {
            $formula->parameter['excess'] = $excess_values;
          }
        }
      }
    }

    if (!empty($postcode)) {
      $postcode_data = IO::getPostcodeData($postcode);
      if (!empty($postcode_data['state'])) {
        $state   = $postcode_data['state'];
        $service = $postcode_data['service'];
      }
    }

    $onsite_cover = false;
    if (!empty($make) && !empty($device->parameter['make']) && !empty($device->parameter['coverable'])) {
      if (in_array($make, $device->parameter['make']) && in_array($make, $device->parameter['coverable'])) {
        if (!empty($onsite) && !empty($service) && $service == 'onsite') {
          $onsite_cover = true;
        }
      }
    }

    $referrer = self::isUserAssociate();
    if (empty($referrer)) {
      $session = JFactory::getSession();
      $referrer = $session->get('ibroker_referrer');
    }

    $associate = false;
    $overrides = array();
    if (!empty($referrer)) {
      $db = JFactory::getDbo();

      // associate flag
      $query = $db->getQuery(true);
      $query->select('*')->from($db->quoteName('#__ibroker_referralcode'));
      $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_field_name').' = '."'associateFlag'".' AND '.$db->quoteName('state').' = 1');
      $db->setQuery($query);
      $results = $db->loadObjectList();
      foreach ($results as $vresult) {
        if (!empty($vresult->domain_field_value)) {
          $associate = true;
          break;
        }
      }

      // formula overrides
      $query = $db->getQuery(true);
      $query->select('*')->from($db->quoteName('#__ibroker_formulaoverride'));
      $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_value_device').' = '.intval($device_id).' AND '.$db->quoteName('state').' = 1');
      $db->setQuery($query);
      $results = $db->loadObjectList();
      foreach ($results as $vresult) {
        if (!empty($vresult->domain_value_key) && !empty($vresult->domain_value_formula)) {
          $overrides[$vresult->domain_value_key] = $vresult->domain_value_formula;
        }
      }
    }

    $underwriter_allowed = false;

    /* Underwriter component checking: Associate Users. */
    $user = JFactory::getUser();
    $userId = $user->get('id');
    if (!empty($userId)) {
      if (!empty($underwriter_data->uw_associate_users)) {
        $associate_users = explode(',', $underwriter_data->uw_associate_users);
        if (in_array($userId, $associate_users)) {
          $underwriter_allowed = true;
        }
      }
      if (!$underwriter_allowed) {
        return array();
      }
    }
    /* Underwriter component checking: Referral Codes. */
    if (!empty($referrer) && !$underwriter_allowed) {
      if (!empty($underwriter_data->uw_referral_codes)) {
        $referral_codes = explode(',', $underwriter_data->uw_referral_codes);
        if (in_array($referrer, $referral_codes)) {
          $underwriter_allowed = true;
        }
      }
      if (!$underwriter_allowed) {
        return array();
      }
    }

    if (!empty($promo)) {
      $promo_discount = self::getPromoByCode($promo);
    }

    if (!empty($formula->parameter['period']) && !empty($formula->parameter['excess'])) {
      foreach ($formula->parameter['excess'] as $excess) {
        foreach ($formula->parameter['period'] as $period) {
          $base_premium = !empty($overrides['base_premium']) ? eval($overrides['base_premium']) : eval($formula->fml_base_premium);

          $discount = $discount_gst = 0;
          $discount_value = '';
          if (!empty($promo_discount) && !empty($promo_discount['value']) && !empty($promo_discount['type'])) {
            if ($promo_discount['type'] == 'fixed') {
              $discount = $promo_discount['value'];
              $discount_value = '$'.self::fixRounding($discount);
            } else if ($promo_discount['type'] == 'percentage') {
              $discount = $base_premium * floatval($promo_discount['value']) / 100;
              $discount_value = self::fixRounding($promo_discount['value']).'%';
            }
            $discount_gst = ($discount * IBROKER_GST) / 100;
          }

          $fire_services_levy = !empty($overrides['fire_services_levy']) ? eval($overrides['fire_services_levy']) : eval($formula->fml_fire_services_levy);
          $marine_gst = !empty($overrides['marine_gst']) ? eval($overrides['marine_gst']) : eval($formula->fml_marine_gst);
          $static_gst = !empty($overrides['static_gst']) ? eval($overrides['static_gst']) : eval($formula->fml_static_gst);
          $total_gst = !empty($overrides['total_gst']) ? eval($overrides['total_gst']) : eval($formula->fml_total_gst);
          $stamp_duty = !empty($overrides['stamp_duty']) ? eval($overrides['stamp_duty']) : eval($formula->fml_stamp_duty);

          $underwriter_levy = !empty($overrides['underwriter_levy']) ? eval($overrides['underwriter_levy']) : eval($formula->fml_underwriter_levy);
          $underwriter_levy_gst = !empty($overrides['underwriter_levy_gst']) ? eval($overrides['underwriter_levy_gst']) : eval($formula->fml_underwriter_levy_gst);

          $broker_fee = !empty($overrides['broker_fee']) ? eval($overrides['broker_fee']) : eval($formula->fml_broker_fee);
          $broker_fee_gst = !empty($overrides['broker_fee_gst']) ? eval($overrides['broker_fee_gst']) : eval($formula->fml_broker_fee_gst);

          $additional_cover = !empty($overrides['additional_cover']) ? eval($overrides['additional_cover']) : eval($formula->fml_additional_cover);
          $additional_cover_gst = !empty($overrides['additional_cover_gst']) ? eval($overrides['additional_cover_gst']) : eval($formula->fml_additional_cover_gst);

          $period_interest_rate = (float) $com_params->get('interest_'.$period.'_year');
          if (empty($period_interest_rate)) {
            $period_interest_rate = IBROKER_DEFAULT_YEARLY_INTEREST_RATE * $period;
          }

          $premium_payable_nodiscount = 0;
          $premium_payable_monthly_nodiscount = 0;

          $premium_payable = !empty($overrides['premium_payable']) ? eval($overrides['premium_payable']) : eval($formula->fml_premium_payable);
          $premium_payable_monthly = !empty($overrides['premium_payable_monthly']) ? eval($overrides['premium_payable_monthly']) : eval($formula->fml_premium_payable_monthly);
          if (!empty($discount)) {
            $premium_payable_nodiscount = $premium_payable;
            $premium_payable_monthly_nodiscount = $premium_payable_monthly;
            $premium_payable = $premium_payable - ($discount + $discount_gst);
          }

          $premium_payable += ($additional_cover + $additional_cover_gst);
          $premium_payable_monthly = !empty($overrides['premium_payable_monthly']) ? eval($overrides['premium_payable_monthly']) : eval($formula->fml_premium_payable_monthly);

          $associate_commission = !empty($overrides['associate_commission']) ? eval($overrides['associate_commission']) : eval($formula->fml_associate_commission);
          $associate_commission_gst = !empty($overrides['associate_commission_gst']) ? eval($overrides['associate_commission_gst']) : eval($formula->fml_associate_commission_gst);

          $ibroker_commission = !empty($overrides['ibroker_commission']) ? eval($overrides['ibroker_commission']) : eval($formula->fml_ibroker_commission);
          $ibroker_commission_gst = !empty($overrides['ibroker_commission_gst']) ? eval($overrides['ibroker_commission_gst']) : eval($formula->fml_ibroker_commission_gst);

          $rch_commission = !empty($overrides['rch_commission']) ? eval($overrides['rch_commission']) : eval($formula->fml_rch_commission);
          $rch_commission_gst = !empty($overrides['rch_commission_gst']) ? eval($overrides['rch_commission_gst']) : eval($formula->fml_rch_commission_gst);

          $sell_price = $premium_payable;
          $buy_price = ($sell_price - $associate_commission - $associate_commission_gst) / (110 / 100);

          $base_premium = self::fixRounding($base_premium);
          $discount = self::fixRounding($discount);
          $discount_gst = self::fixRounding($discount_gst);
          $fire_services_levy = self::fixRounding($fire_services_levy);
          $marine_gst = self::fixRounding($marine_gst);
          $static_gst = self::fixRounding($static_gst);
          $total_gst = self::fixRounding($total_gst);
          $stamp_duty = self::fixRounding($stamp_duty);
          $underwriter_levy = self::fixRounding($underwriter_levy);
          $underwriter_levy_gst = self::fixRounding($underwriter_levy_gst);
          $broker_fee = self::fixRounding($broker_fee);
          $broker_fee_gst = self::fixRounding($broker_fee_gst);
          $additional_cover = self::fixRounding($additional_cover);
          $additional_cover_gst = self::fixRounding($additional_cover_gst);
          $premium_payable = self::fixRounding($premium_payable);
          $premium_payable_nodiscount = self::fixRounding($premium_payable_nodiscount);
          $premium_payable_monthly = self::fixRounding($premium_payable_monthly);
          $premium_payable_monthly_nodiscount = self::fixRounding($premium_payable_monthly_nodiscount);
          $sell_price = self::fixRounding($sell_price);
          $buy_price = self::fixRounding($buy_price);
          $associate_commission_gst = self::fixRounding($associate_commission_gst);
          $associate_commission = self::fixRounding($associate_commission);
          $ibroker_commission = self::fixRounding($ibroker_commission);
          $ibroker_commission_gst = self::fixRounding($ibroker_commission_gst);
          $rch_commission = self::fixRounding($rch_commission);
          $rch_commission_gst = self::fixRounding($rch_commission_gst);

          $available['quote'][$excess][$period] = array(
            'referrer' => !empty($associate) ? $referrer : '',
            'associate' => intval($associate),
            'base_premium' => $base_premium,
            'discount' => $discount,
            'discount_gst' => $discount_gst,
            'discount_value' => $discount_value,
            'fire_services_levy' => $fire_services_levy,
            'marine_gst' => $marine_gst,
            'static_gst' => $static_gst,
            'total_gst' => $total_gst,
            'stamp_duty' => $stamp_duty,
            'underwriter_id' => $underwriter_id,
            'underwriter_levy' => $underwriter_levy,
            'underwriter_levy_gst' => $underwriter_levy_gst,
            'broker_fee' => $broker_fee,
            'broker_fee_gst' => $broker_fee_gst,
            'additional_cover' => $additional_cover,
            'additional_cover_gst' => $additional_cover_gst,
            'premium_payable' => $premium_payable,
            'premium_payable_nodiscount' => $premium_payable_nodiscount,
            'monthly_payable' => $premium_payable_monthly,
            'monthly_payable_nodiscount' => $premium_payable_monthly_nodiscount,
            'monthly_enable' => intval($monthly),
            'associate_commission' => $associate_commission,
            'associate_commission_gst' => $associate_commission_gst,
            'ibroker_commission' => $ibroker_commission,
            'ibroker_commission_gst' => $ibroker_commission_gst,
            'rch_commission' => $rch_commission,
            'rch_commission_gst' => $rch_commission_gst,
            'sell_price' => $sell_price,
            'buy_price' => $buy_price,
            'onsite_cover' => $onsite_cover,
            'promo_code' => $promo,
            'period_interest_rate' => $period_interest_rate,
            );
        }
      }
    }

    return $available;
  }

  public static function sqlInsert($table, $fields)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $columns = $values = array();
    foreach ($fields as $column => $value) {
      $columns[] = $column;
      $values[] = $db->quote($value);
    }
    $query->insert($db->quoteName($table))
    ->columns($db->quoteName($columns))
    ->values(implode(',', $values));
    $db->setQuery($query);
    $db->query();
    return $db->insertid();
  }

  public static function sqlUpdate($table, $fields, $conditions)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $ufields = $uconditions = array();
    foreach ($fields as $column => $value) {
      $ufields[] = $db->quoteName($column).' = '.$db->quote($value);
    }
    foreach ($conditions as $column => $value) {
      $uconditions[] = $db->quoteName($column).' = '.$db->quote($value);
    }
    $query->update($db->quoteName($table))->set($ufields)->where($uconditions);
    $db->setQuery($query);
    return $db->execute();
  }

  public static function sqlSelect($table, $condition)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->select('*')->from($db->quoteName($table));
    $query->where($db->quoteName($condition['column']).' '.$condition['operator'].' '.$db->quote($condition['value']));
    $db->setQuery($query);

    $result = $db->loadObjectList();
    if (count($result) > 0) {
      return $result[0];
    } else {
      return new stdClass;
    }
  }

  public static function fixRounding($number) {
    $number = round($number, 2);
    return $number;
  }

  public static function checkAndStoreReferrer() {
    if (!empty($_GET[IBROKER_REFERRAL_CODE_KEY]) && ctype_alnum($_GET[IBROKER_REFERRAL_CODE_KEY])) {
      $referrer = trim($_GET[IBROKER_REFERRAL_CODE_KEY]);
      register_shutdown_function('io_set_referrer_code', $referrer);
    }
  }

  public static function isUserAssociate() {
    $user = JFactory::getUser();
    $userId = $user->get('id');
    if (!empty($userId)) {
      $mapusercode = self::sqlSelect('#__ibroker_mapusercode', array(
        'column' => 'associate_user',
        'operator' => '=',
        'value' => $userId,
        ));
      if (!empty($mapusercode->referral_code)) {
        return $mapusercode->referral_code;
      }
    }
    return false;
  }

  public static function getPostcodeData($postcode) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('`suburb`, `austate`, `service`')->from('#__ibroker_postcode');
    $query->where('`postcode` = '.intval($postcode));
    $db->setQuery($query);
    $results = $db->loadObjectList();
    $return = array();
    if (!empty($results)) {
      foreach ($results as $result) {
        $return['suburb'][] = $result->suburb;
        $return['state'] = $result->austate;
        $return['service'] = $result->service;
      }
    }
    return $return;
  }

  public static function submitPayment($refnum) {
    $return = array();

    $order = self::sqlSelect('#__priceleaf_session', array(
      'column' => 'refnumber',
      'operator' => '=',
      'value' => $refnum,
      ));
    if (empty($order->details) || empty($order->id)) {
      return array('error' => 'Invalid reference data.');
    }
    $details = explode("{{}}", $order->details);
    if (empty($details) || empty($details[13]) || empty($details[8]) || empty($details[14]) || empty($details[9]) || empty($details[15]) || empty($details[22])) {
      return array('error' => 'Invalid reference details.');
    }
    $quote = self::getQuote($details[13], $details[22], array('postcode' => $details[8], 'sum_insured' => floatval($details[14]), 'make' => $details[9], 'onsite' => intval(@$details[21]), 'promo' => $details[16], 'monthly' => $details[23]));
    list($numyear, $excess) = explode(',', $details[15]);
    $price = 0;
    if (!empty($quote['quote'][$excess][$numyear]['premium_payable'])) {
      $price = $quote['quote'][$excess][$numyear]['premium_payable'];
    }
    if (empty($price)) {
      return array('error' => 'Unable to determine policy price.');
    }

    if (!empty(MPGS_NEW_PRICE_OVERRIDE)) {
      $price = MPGS_NEW_PRICE_OVERRIDE;
    }

    $data = $_POST;
    $data['apiOperation'] = 'PAY';
    $data['sourceOfFunds']['type'] = 'CARD';
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace(' ', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace('-', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['order']['amount'] = $price;
    $data['order']['currency'] = 'AUD';
    $token = JSession::getFormToken();
    unset($data[$token]);
    $request = json_encode($data);
    $return['data'] = $data;

    $payment_url  = MPGS_NEW_PAYMENT_URL;
    $payment_url .= '/version/' . MPGS_NEW_PAYMENT_VER;
    $payment_url .= '/merchant/' . MPGS_NEW_MERCHANT_ID;
    $payment_url .= '/order/' . $order->id;
    $payment_url .= '/transaction/' . $refnum;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Length: ' . strlen($request)));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: Application/json; charset=UTF-8'));
    curl_setopt($ch, CURLOPT_URL, $payment_url);
    curl_setopt($ch, CURLOPT_USERPWD, MPGS_NEW_API_USERNAME . ':' . MPGS_NEW_API_PASSWORD);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    if (MPGS_NEW_CURL_DEBUG) {
      curl_setopt($ch, CURLOPT_HEADER, TRUE);
      curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
    }

    $return['response'] = curl_exec($ch);
    if (!empty($return['response'])) {
      $return['parsed_response'] = json_decode($return['response'], true);
    }
    
    if (curl_error($ch)) {
      $return['error'] = 'CURL(' . curl_errno($ch) . ') - ' . curl_error($ch);
    }
    if (MPGS_NEW_CURL_DEBUG) {
      $info = curl_getinfo($ch);
      if (array_key_exists('request_header', $info)) {
        $return['header'] = $info['request_header'];
      }
    }
    curl_close($ch);

    if (!empty($return['error'])) {
      return $return;
    }

    $response = json_decode($return['response'], true);
    if (empty($response)) {
      $return['error'] = 'Failure when decoding payment response.';
      return $return;
    }

    $return['response'] = $response;
    if (array_key_exists('result', $response)) {
      $return['status'] = $response['result'];
    }

    return $return;
  }

  public static function submitPaymentDeprecated($refnum) {
    $return = array();

    $order = self::sqlSelect('#__priceleaf_session', array(
      'column' => 'refnumber',
      'operator' => '=',
      'value' => $refnum,
      ));
    if (empty($order->details) || empty($order->id)) {
      return array('error' => 'Invalid reference data.');
    }
    $details = explode("{{}}", $order->details);
    if (empty($details) || empty($details[13]) || empty($details[8]) || empty($details[14]) || empty($details[9]) || empty($details[15]) || empty($details[22])) {
      return array('error' => 'Invalid reference details.');
    }
    $quote = self::getQuote($details[13], $details[22], array('postcode' => $details[8], 'sum_insured' => floatval($details[14]), 'make' => $details[9], 'onsite' => intval(@$details[21]), 'promo' => $details[16], 'monthly' => $details[23]));
    list($numyear, $excess) = explode(',', $details[15]);
    $price = 0;
    if (!empty($quote['quote'][$excess][$numyear]['premium_payable'])) {
      $price = $quote['quote'][$excess][$numyear]['premium_payable'];
    }
    if (empty($price)) {
      return array('error' => 'Unable to determine policy price.');
    }

    if (!empty(MIGS_NEW_PRICE_OVERRIDE)) {
      $price = MIGS_NEW_PRICE_OVERRIDE;
    }

    $data = $_POST;
    $data['apiOperation'] = 'PAY';
    $data['sourceOfFunds']['type'] = 'CARD';
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace(' ', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace('-', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['order']['amount'] = $price;
    $data['order']['currency'] = 'AUD';
    $token = JSession::getFormToken();
    unset($data[$token]);
    $request = json_encode($data);
    $return['data'] = $data;

    $payment_url  = MIGS_NEW_PAYMENT_URL;
    $payment_url .= '/version/' . MIGS_NEW_PAYMENT_VER;
    $payment_url .= '/merchant/' . MIGS_NEW_MERCHANT_ID;
    $payment_url .= '/order/' . $order->id;
    $payment_url .= '/transaction/' . $refnum;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Length: ' . strlen($request)));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: Application/json; charset=UTF-8'));
    curl_setopt($ch, CURLOPT_URL, $payment_url);
    curl_setopt($ch, CURLOPT_USERPWD, MIGS_NEW_API_USERNAME . ':' . MIGS_NEW_API_PASSWORD);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    if (MIGS_NEW_CURL_DEBUG) {
      curl_setopt($ch, CURLOPT_HEADER, TRUE);
      curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
    }

    $return['response'] = curl_exec($ch);
    if (curl_error($ch)) {
      $return['error'] = 'CURL(' . curl_errno($ch) . ') - ' . curl_error($ch);
    }
    if (MIGS_NEW_CURL_DEBUG) {
      $info = curl_getinfo($ch);
      if (array_key_exists('request_header', $info)) {
        $return['header'] = $info['request_header'];
      }
    }
    curl_close($ch);

    if (!empty($return['error'])) {
      return $return;
    }

    $response = json_decode($return['response'], true);
    if (empty($response)) {
      $return['error'] = 'Failure when decoding payment response.';
      return $return;
    }

    $return['response'] = $response;
    if (array_key_exists('result', $response)) {
      $return['status'] = $response['result'];
    }

    return $return;
  }

  public static function getPromoByCode($promoCode) {
    $return = array();
    if (!ctype_alnum($promoCode)) {
      return $return;
    }
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('`promo_code`, `promo_discount`, `promo_parameters`')->from('#__ibroker_discount');
    $query->where('`promo_code` = '.$db->quote($promoCode).' AND `state` = 1');
    $db->setQuery($query);
    $results = $db->loadObjectList();
    if (!empty($results)) {
      foreach ($results as $result) {
        $return['code'] = $result->promo_code;
        if (preg_match("/[0-9]+%/", $result->promo_discount, $matches)) {
          $return['value'] = floatval($matches[0]);
          $return['type'] = 'percentage';
        } else {
          $return['value'] = floatval($result->promo_discount);
          $return['type'] = 'fixed';
        }
        $return['params'] = $result->promo_parameters;
      }
    }
    return $return;
  }

  public static function registerMonthlyPaymentQuote($reference_number, $monthly_details) {
    $invoice_number = '';
    $result = self::attvestCreateQuote($reference_number, $monthly_details, $invoice_number);
    self::attvestCheckError($result);

    if (!empty($result['response']->brokerId) && !empty($result['response']->externalReference)) {
      $app = JFactory::getApplication();
      $session = JFactory::getSession();
      $session->set('attvest_response', $result['response']);
      $session->set('reference_number', $reference_number);
      $ibroker_token = base64_encode($reference_number.'::'.$invoice_number);
      $redirect_url = JRoute::_('index.php?option=com_priceleafs&view=policy&layout=domonthly&ibroker='.$ibroker_token, true, -1);
      $back_url = JRoute::_('index.php?option=com_priceleafs&view=policy', true, -1);
      $url = ATTVEST_PAYMENT_URL.'/'.$result['response']->brokerId.'/#?externalReference='.$result['response']->externalReference.'&redirectURL='.urlencode($redirect_url).'&backURL='.urlencode($back_url);
      $app->redirect($url);
    }
    exit();
  }

  public static function attvestCheckError($result) {
    if (!empty($result['error_code']) && !empty($result['error_text'])) {
      trigger_error('CURL['.$result['error_code'].']: '.$result['error_text'], E_USER_ERROR);
      die();
    }

    if (!empty($result['response']->error->code) && !empty($result['response']->error->message)) {
      trigger_error('ATTVEST['.$result['response']->error->code.']: '.$result['response']->error->message, E_USER_ERROR);
      die();
    }
  }

  public static function attvestCreateQuote($reference_number, $monthly_details, &$invoice_number) {
    $split_ey = explode(',', $monthly_details[15]);
    $excess   = $split_ey[1];
    $numyear  = $split_ey[0];

    $incept = date('Y-m-d').' 00:00:00';
    $expiry = date('Y-m-d', strtotime('+'.intval($numyear).'year')).' 00:00:00';
    if (!empty($monthly_details[20])) {
      $incept = $monthly_details[20].' 00:00:00';
      $instamp = strtotime($incept);
      $expiry = date('Y-m-d H:i:s', strtotime('+'.intval($numyear).'year', $instamp));
    }

    $available = IO::getQuote($monthly_details[13], $monthly_details[22], array('postcode' => $monthly_details[8], 'sum_insured' => floatval($monthly_details[14]), 'make' => $monthly_details[9], 'onsite' => intval(@$monthly_details[21]), 'promo' => $monthly_details[16], 'monthly' => intval(@$monthly_details[23])));
    $quote = $available['quote'][$excess][$numyear];

    $invoice_number = 'INV-'.strtoupper(uniqid());

    $postdata = array(
      'externalReference' => null,
      'brokerId' => null,
      'client' => array(
        'id' => null,
        'externalReference' => null,
        'createDate' => null,
        'lastUpdatedDate' => null,
        'name' => $monthly_details[0],
        'abn' => null,
        'telephone' => $monthly_details[5],
        'email' => $monthly_details[12],
        'addressPostLine1' => $monthly_details[4],
        'addressPostLine2' => '',
        'addressPostSuburb' => $monthly_details[6],
        'addressPostCode' => $monthly_details[8],
        'addressPostState' => $monthly_details[7],
        'addressLine1' => $monthly_details[4],
        'addressLine2' => '',
        'addressSuburb' => $monthly_details[6],
        'addressCode' => $monthly_details[8],
        'addressState' => $monthly_details[7],
        'brokerId' => null,
      ),
      'policies' => array(
        array(
          'id' => null,
          'clientId' => null,
          'policyNumber' => $reference_number,
          'invoiceNumber' => $invoice_number,
          'clazz' => null,
          'insurer' => null,
          'inceptionDate' => $incept,
          'expiryDate' => $expiry,
          'insuredName' => $monthly_details[2],
          'previouslyFunded' => false,
          'coInsurance' => false,
          'fsraType' => 'R',
          'secondaryReference' => null,
          'fundLoanNumber' => null,
          'basePremium' => $quote['base_premium'],
          'basePremiumGst' => self::fixRounding($quote['base_premium'] * IBROKER_GST / 100),
          'stampDuty' => $quote['stamp_duty'],
          'fsl' => $quote['fire_services_levy'],
          'brokerFee' => $quote['broker_fee'],
          'brokerFeeGst' => $quote['broker_fee_gst'],
          'commission' => $quote['ibroker_commission'],
          'commissionGst' => $quote['ibroker_commission_gst'],
          'premium' => $quote['premium_payable'],
          'numberOfPayments' => intval($numyear * 12),
        ),
      ),
    );

    $postfields = json_encode($postdata);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, ATTVEST_PAYMENT_URL.'/attvest-funding-service/interface/createQuote/json');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
      'Authorization: '.ATTVEST_AUTH_CODE,
      'Content-Type: application/json',
      'Content-Length: '.strlen($postfields),
    ));
    $response = curl_exec($ch);
    $result = array();
    $result['error_http'] = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $result['error_code'] = curl_errno($ch);
    $result['error_text'] = curl_error($ch);
    $result['response'] = json_decode($response);
    curl_close($ch);

    return $result;
  }

  public static function pluralize($quantity, $singular, $plural=null) {
    if($quantity==1 || !strlen($singular)) return $singular;
    if($plural!==null) return $plural;

    $last_letter = strtolower($singular[strlen($singular)-1]);
    switch($last_letter) {
        case 'y':
            return substr($singular,0,-1).'ies';
        case 's':
            return $singular.'es';
        default:
            return $singular.'s';
    }
  }


}

IO::checkAndStoreReferrer();
function io_set_referrer_code($referrer) {
  $session = JFactory::getSession();
  $session->set('ibroker_referrer', $referrer);
}

