<?php

if (version_compare(PHP_VERSION, '5.3.10', '<'))
{
  die('Your host needs to use PHP 5.3.10 or higher to run this version of Joomla!');
}

define('_JEXEC', 1);

if (file_exists(__DIR__ . '/defines.php'))
{
  include_once __DIR__ . '/defines.php';
}

if (!defined('_JDEFINES'))
{
  define('JPATH_BASE', __DIR__);
  require_once JPATH_BASE . '/includes/defines.php';
}

require_once JPATH_BASE . '/includes/framework.php';
require_once JPATH_BASE . '/io.php';

JDEBUG ? $_PROFILER->mark('afterLoad') : null;

$app = JFactory::getApplication('site');

//echo str_replace('.', '', 'ibroker-'.strtoupper(uniqid('', true))).PHP_EOL;

if (!defined('JPATH_COMPONENT')) {
  define('JPATH_COMPONENT', JPATH_BASE . '/components');
}

JLoader::import('joomla.application.component.model');
JLoader::import('policy', JPATH_SITE  . '/components/com_priceleafs/models' );

$param = strtoupper(md5(trim(str_replace('ibroker-', '', basename(__FILE__, '.php')))));
list($param1, $param2, $param3) = str_split($param, 15);

$refnum = JRequest::getVar($param1, '');
$invoice = JRequest::getVar($param2, '');
$check = JRequest::getVar($param3, '');

if (!empty($refnum) && !empty($invoice) && !empty($check)) {
  $result = IO::sqlSelect('#__priceleaf_session', array(
    'column' => 'refnumber',
    'operator' => '=',
    'value' => $refnum,
  ));

  if (!empty($result)) {
    $hash_details = md5($result->details);
    if ($hash_details == $check) {
      if ($result->type == 'pay') {
        $policy = JModelLegacy::getInstance( 'policy', 'PriceleafsModel' );
        $session = JFactory::getSession();
        $session->set('cathrine', $result->details);
        if ($policy->newpolicy($invoice)) {
          die('New policy/inventory has been registered.');
        } else {
          die('New policy/inventory creation failed');
        }
      }
    }
  }
}

die('Invalid script usage.');
