<?php
defined('_JEXEC') or die;

class PriceleafsViewPolicy extends JViewLegacy
{
  function display($tpl = null) {
    $layout = JRequest::getVar('layout','');
    $ibroker = JRequest::getVar('ibroker','');
    $app = JFactory::getApplication();
    $session = JFactory::getSession();
    $success_link_monthly = 'index.php?option=com_content&view=article&id=23&Itemid=228';
    $success_link_premium = 'index.php?option=com_content&view=article&id=18&Itemid=195';
    
    switch ($layout) {
    case 'domonthly':
      $link = 'index.php?option=com_priceleafs&view=policy';
      $message = JText::_( 'Error' );
      $type = 'warning';

      $response = $session->get('attvest_response');
      if (!empty($response->policies[0]->invoiceNumber)) {
        $receipt = $response->policies[0]->invoiceNumber;
      }
      $refnum = $session->get('reference_number');

      if (empty($receipt) || empty($refnum)) {
        if (!empty($ibroker)) {
          $ibroker = base64_decode($ibroker);
          list($refnum, $receipt) = explode('::', $ibroker);
        }
      }

      if (!empty($receipt) && !empty($refnum)) {
        $model = $this->getModel('policy');
        if ($model->newpolicy($receipt, $refnum)) {
          $link = $success_link_monthly;
          $message = JText::_( 'COM_PRICELEAF_POLICY_SAVE' );
          $type = 'message';
        } else {
          $message = 'Unable to save policy.';
        }
      }

      $app->redirect($link, $message, $type);
      return;
      break;
    case 'dopay':
      JSession::checkToken() or die( 'Invalid Token' );
      
      $link = 'index.php?option=com_priceleafs&view=policy&layout=pay';
      $message = JText::_( 'Error' );
      $type = 'warning';
      
      $refnum = $session->get('reference_number');
      if (empty($refnum)) {
        $message = 'Invalid reference number.';
        $app->redirect($link, $message, $type);
        return;
      }
      
      $result = IO::submitPayment($refnum);      
      if ($result['status'] == 'SUCCESS' && !empty($result['response']['transaction']['receipt'])) {
        $model = $this->getModel('policy');
        $receipt = $result['response']['transaction']['receipt'];
        if ($model->newpolicy($receipt, $refnum)) {
          $link = $success_link_premium;
          $message = JText::_( 'COM_PRICELEAF_POLICY_SAVE' );
          $type = 'message';
        } else {
          $message = 'Unable to save policy.';
        }
      } else {
        $message = '<strong>'.$result['status'].'</strong>: ';
        if (!empty($result['response']['reason'])) {
          $message .= implode(' - ', $result['response']['reason']);
        } else if (!empty($result['response']['response'])) {
          $message .= implode(' - ', $result['response']['response']);
        } else if (!empty($result['response']['error'])) {
          $message .= implode(' - ', $result['response']['error']);
        } else {
          //$message .= '<pre>'.print_r($result['response'], true).'</pre>';
          $message .= '<em>Unspecified error.</em>';
        }
      }
      
      $app->redirect($link, $message, $type);
      return;
      break;
    case 'pay':
      $session = JFactory::getSession();
      $devices = IO::getDevices();
      
      $email = JRequest::getVar('email','');
      $reference_number = $session->get('reference_number');
      $price = 0;

      $monthly_enable = false;
      $monthly_details = array();

      if (empty($email) && !empty($reference_number)) {
        $order = IO::sqlSelect('#__priceleaf_session', array(
          'column' => 'refnumber',
          'operator' => '=',
          'value' => $reference_number,
          ));
        $message = '';
        if (empty($order->details) || empty($order->id)) {
          $message = 'Invalid reference data.';
        }
        $details = explode("{{}}", $order->details);
        if (empty($details) || empty($details[13]) || empty($details[8]) || empty($details[14]) || empty($details[9]) || empty($details[15]) || empty($details[22])) {
          $message = 'Invalid reference details.';
        }
        $quote = IO::getQuote($details[13], $details[22], array('postcode' => $details[8], 'sum_insured' => floatval($details[14]), 'make' => $details[9], 'onsite' => intval(@$details[21]), 'promo' => $details[16], 'monthly' => intval(@$details[23])));
        list($numyear, $excess) = explode(',', $details[15]);
        if (!empty($quote['quote'][$excess][$numyear]['premium_payable'])) {
          $price = $quote['quote'][$excess][$numyear]['premium_payable'];
        }
        if (empty($price)) {
          $message = 'Unable to determine policy price.';
        }
        if (!empty($message)) {
          $app->redirect('index.php', $message, 'danger');
          return;
        }
        
        $pagetitle = 'You are insuring a $'.number_format(floatval($details[14]), 2).' '.$devices[ $details[13] ]->device;
        $reference_number = $details[13].uniqid();
        $session->set('cathrine', $order->details);
        $session->set('reference_number',  $reference_number);
        $this->assignRef('custom', $order->details);
        $this->assignRef('price', $price);
        $this->assignRef('refNum', $reference_number);
        $this->assignRef('quote_data', $quote);
        $this->assignRef('quote', $quote['quote'][$excess][$numyear]);
        $this->assignRef('suminsured', $details[14]);
        $this->assignRef('pagetitle', $pagetitle);

        IO::sqlInsert('#__priceleaf_session', array(
          'refnumber' => $reference_number,
          'type' => $layout,
          'details' => $order->details,
          ));
        
        if (!empty($details[23])) {
          $monthly_enable = true;
          $monthly_details = $details;
        }
      } else {
        $infullname = JRequest::getVar('infullname','');
        $isurname = '';
        $eufullname = JRequest::getVar('eufullname','');
        $eusurname = '';
        $txtAddress = JRequest::getVar('txtAddress','');
        $txtPhone = JRequest::getVar('txtPhone','');
        $txtSuburb = JRequest::getVar('txtSuburb','');
        $txtState = JRequest::getVar('txtState','');
        $txtPostcode = JRequest::getVar('txtPostcode','');
        $txtMake = JRequest::getVar('txtMake','');
        $txtModel = JRequest::getVar('txtModel','');
        $datePurchase = JRequest::getVar('txtDatePurchase','');
        if (!empty($datePurchase)) {
          list($dp_date, $dp_month, $dp_year) = explode('-', $datePurchase);
          $datePurchase = $dp_year.'-'.$dp_month.'-'.$dp_date;
        }
        $dateInsured = JRequest::getVar('txtDateInsured','');
        if (!empty($dateInsured)) {
          list($dp_date, $dp_month, $dp_year) = explode('-', $dateInsured);
          $dateInsured = $dp_year.'-'.$dp_month.'-'.$dp_date;
        }
        $serialNo = JRequest::getVar('txtSerialNo','');
        $unit = 1;
        $institution = JRequest::getVar('institution','');
        $email = JRequest::getVar('email','');
        $deviceType = JRequest::getVar('deviceType','');
        $sum_insured = JRequest::getVar('sum_insured','');
        $numyear = JRequest::getVar('numyear','');
        $excess = JRequest::getVar('excess','');
        $promo_code = JRequest::getVar('promo_code','');
        $flag = JRequest::getVar('flag','');
        $onsite_cover = JRequest::getVar('onsite_cover','');
        $underwriter_id = JRequest::getVar('underwriter_id','');
        $monthly = JRequest::getVar('monthly','0');
        
        $rows = IO::getQuote($deviceType, $underwriter_id, array('postcode' => $txtPostcode, 'sum_insured' => $sum_insured, 'make' => $txtMake, 'onsite' => $onsite_cover, 'promo' => $promo_code, 'monthly' => $monthly));
        if (!empty($rows['quote'][$excess][$numyear]['premium_payable'])) {
          $price = $rows['quote'][$excess][$numyear]['premium_payable'];
        }
        
        $excessyear = $numyear.','.$excess;
        $custom = $infullname.'{{}}'.$isurname.'{{}}'.$eufullname.'{{}}'.$eusurname.'{{}}'.$txtAddress.'{{}}'.$txtPhone.'{{}}'.$txtSuburb.'{{}}'.$txtState.'{{}}'.$txtPostcode.'{{}}'.$txtMake.'{{}}'.$txtModel.'{{}}'.$institution.'{{}}'.$email.'{{}}'.$deviceType.'{{}}'.$sum_insured.'{{}}'.$excessyear.'{{}}'.$promo_code.'{{}}'.$unit.'{{}}'.$datePurchase.'{{}}'.$serialNo.'{{}}'.$dateInsured.'{{}}'.intval($onsite_cover).'{{}}'.intval($underwriter_id).'{{}}'.$monthly;
        $reference_number = $deviceType.uniqid();

        $pagetitle = 'You are insuring a $'.number_format(floatval($sum_insured), 2).' '.$devices[ $deviceType ]->device;
        $session->set('cathrine', $custom);
        $session->set('reference_number',  $reference_number);
        $this->assignRef('custom',$custom);
        $this->assignRef('price', $price);
        $this->assignRef('refNum', $reference_number);
        $this->assignRef('quote_data', $rows);
        $this->assignRef('quote', $rows['quote'][$excess][$numyear]);
        $this->assignRef('suminsured', $sum_insured);
        $this->assignRef('pagetitle', $pagetitle);
        
        IO::sqlInsert('#__priceleaf_session', array(
          'refnumber' => $reference_number,
          'type' => $layout,
          'details' => $custom,
          ));
        
        if (!empty($monthly)) {
          $monthly_enable = true;
          $monthly_details = explode("{{}}", $custom);
        }
      }

      if ($monthly_enable && !empty($reference_number) && !empty($monthly_details)) {
        IO::registerMonthlyPaymentQuote($reference_number, $monthly_details);
      }

      break;

    default:
      $session    = JFactory::getSession();
      $model      = $this->getModel();
      $devices    = IO::getDevices();

      $q_postcode = JRequest::getVar('p', '');
      $q_device   = intval(JRequest::getVar('d', 0));
      $q_make     = JRequest::getVar('m', '', 'post', 'ALNUM');
      $q_sum      = floatval(JRequest::getVar('i', 0));
      $q_year     = intval(JRequest::getVar('y', 0));
      $q_excess   = intval(JRequest::getVar('e', 0));
      $q_onsite   = intval(JRequest::getVar('o', 0));
      $q_uwid     = intval(JRequest::getVar('u', 0));
      $q_promo    = JRequest::getVar('c', '', 'post', 'ALNUM');
      $q_monthly  = intval(JRequest::getVar('monthly', 0));

      if (empty($q_postcode) || empty($q_device) || empty($q_sum) || empty($q_year)) {
        $cathrine = $session->get('cathrine');
        if (!empty($cathrine)) {
          $customs = explode("{{}}", $cathrine);
          $q_postcode = $customs[8];
          $q_device = @$customs[13];
          $q_make = @$customs[9];
          $q_sum = floatval(@$customs[14]);
          $split_ey = explode(',', @$customs[15]);
          $q_year = @$split_ey[0];
          $q_excess = @$split_ey[1];
          $q_onsite = intval(@$customs[21]);
          $q_uwid = intval(@$customs[22]);
          $q_promo = $customs[16];
          $q_monthly = intval(@$customs[23]);
          $this->assignRef('q_postdata', $customs);
        }
      }

      if (empty($q_uwid) || empty($q_postcode) || empty($q_device) || empty($q_sum) || empty($q_year)) {
        $app = JFactory::getApplication('site');
        $app->redirect('index.php', 'Quote data invalid.');
        return;
      }

      if ($referrer = $session->get('ibroker_referrer')) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')->from($db->quoteName('#__ibroker_referralcode'));
        $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer));
        $db->setQuery($query);
        $results = $db->loadObjectList();
        $q_refdata = array();
        foreach ($results as $vresult) {
          if (!empty($vresult->domain_field_name) && !empty($vresult->domain_field_value)) {
            $q_refdata[$vresult->domain_field_name] = $vresult->domain_field_value;
          }
        }
        $this->assignRef('q_refdata', $q_refdata);
      }

      if (!empty($q_uwid) && !empty($q_postcode) && !empty($q_device) && !empty($q_sum) && !empty($q_year) && isset($q_excess)) {
        $rows = IO::getQuote($q_device, $q_uwid, array('postcode' => $q_postcode, 'sum_insured' => $q_sum, 'make' => $q_make, 'onsite' => $q_onsite, 'promo' => $q_promo, 'monthly' => $q_monthly));
        if (!empty($rows['quote'][$q_excess][$q_year]['premium_payable'])) {
          $postcode_data = IO::getPostcodeData($q_postcode);
          if (!empty($postcode_data['state'])) {
            $q_state = $postcode_data['state'];
          }
          $q_calculate = $rows['quote'][$q_excess][$q_year];
          $q_rowquote = (object) array(
            'id' => 0,
            'create_date' => date('Y-m-d'),
            'institution' => '',
            'name' => '',
            'email' => '',
            'deviceType' => $q_device,
            'sum_insured' => $q_sum,
            'promo_code' => $q_promo,
            'excess' => $q_excess,
            'numyear' => $q_year,
            'premium' => $q_calculate['base_premium'],
            'FSL' => $q_calculate['fire_services_levy'],
            'stampDuty' => $q_calculate['stamp_duty'],
            'UWID' => $q_uwid,
            'UWLevy' => $q_calculate['underwriter_levy'],
            'UWLevyGST' => $q_calculate['underwriter_levy_gst'],
            'brokerFee' => $q_calculate['rch_commission'],
            'associate' => $q_calculate['associate'],
            'AC' => $q_calculate['associate_commission'],
            'ACGST' => $q_calculate['associate_commission_gst'],
            'IC' => $q_calculate['ibroker_commission'],
            'ICGST' => $q_calculate['ibroker_commission_gst'],
            'RCH' => $q_calculate['rch_commission'],
            'RCHGST' => $q_calculate['rch_commission_gst'],
            'GST' => $q_calculate['total_gst'],
            'brokerFee' => $q_calculate['broker_fee'],
            'brokerFeeGST' => $q_calculate['broker_fee_gst'],
            'additionalCover' => $q_calculate['additional_cover'],
            'additionalCoverGST' => $q_calculate['additional_cover_gst'],
            'discount' => $q_calculate['discount'],
            'discount_value' => $q_calculate['discount_value'],
            'total' => $q_calculate['premium_payable'],
            'state' => $q_state,
            'device' => $devices[$q_device]->device,
            'onsite_cover' => $q_calculate['onsite_cover'],
            'monthly_payable' => $q_calculate['monthly_payable'],
            'monthly_enable' => $q_calculate['monthly_enable'],
            );
          $this->assignRef('q_rowquote', $q_rowquote);
          $this->assignRef('q_calculate', $q_calculate);
          if (!empty($q_make)) {
            $page_title = '$'.floatval($q_sum).' '.$q_make.' '.$devices[$q_device]->device.' in '.$q_state;
          } else {
            $page_title = '$'.floatval($q_sum).' '.$devices[$q_device]->device.' in '.$q_state;
          }
          $this->assignRef('q_pagetitle', $page_title);

          $this->assignRef('q_postcode', $q_postcode);
          $this->assignRef('q_device', $q_device);
          $this->assignRef('q_make', $q_make);
          $this->assignRef('q_sum', $q_sum);
          $this->assignRef('q_year', $q_year);
          $this->assignRef('q_excess', $q_excess);
          $this->assignRef('q_onsite', $q_onsite);
          $this->assignRef('q_uwid', $q_uwid);
          $this->assignRef('q_promo', $q_promo);

          $this->assignRef('q_state', $q_state);
        }
      }
      break;
    }
    parent::display($tpl);
  }
}
