<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

class PriceleafsControllerQuote extends JControllerForm
{

	function __construct()
	{
		parent::__construct();

		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'publish'    , 	'publish' );
		$this->registerTask( 'unpublish'  , 	'publish' );
	}

  function saveprequote()
  {
		$model = $this->getModel('quote');
    $data = JRequest::get('post');

    $postcode = @$data['postcode'];

    $postcode_data = IO::getPostcodeData($postcode);
    if (empty($postcode_data['state'])) {
      return array(
        'error' => true,
        'message' => JText::_( 'Please provide a valid postcode' ),
      );
    }

    $state = $data['state'] = $postcode_data['state'];

    $insured = floatval($data['insured']);
    if (empty($insured)) {
      return array(
        'error' => true,
        'message' => JText::_( 'Please provide a valid sum insured value' ),
      );
    }

    $device_id = intval($data['device']);
    $make = @$data['make'];

    $device = IO::getDevice($device_id);
    if (empty($device->device)) {
      return array(
        'error' => true,
        'message' => JText::_( 'Invalid device type selected' ),
      );
    }
    if (!empty($device->parameter['make'])) {
      if (!in_array($make, $device->parameter['make'])) {
        return array(
          'error' => true,
          'message' => JText::_( 'Invalid device make selected' ),
        );
      }
    }

    $promo = @$data['promo'];
    $promo_discount = IO::getPromoByCode($promo);
    if (!empty($promo) && empty($promo_discount)) {
        return array(
          'error' => true,
          'message' => JText::_( 'The Promotion Code you have entered is not recognised. Please enter the code exactly as shown on the handout you have been given.' ),
        );
    }

    $model->saveprequote($data);

    if (!empty($device->parameter['coverable'])) {
      if (in_array($make, $device->parameter['coverable']) &&
        $postcode_data['service'] == 'onsite') {
        return array(
          'error' => false,
          'onsite' => true,
        );
      }
    }

    return array(
      'error' => false,
    );
  }

  public function execute($task)
  {
    $this->task = $task;

    $task = strtolower($task);
    if (isset($this->taskMap[$task])) {
      $doTask = $this->taskMap[$task];
    } elseif (isset($this->taskMap['__default'])) {
      $doTask = $this->taskMap['__default'];
    } else {
      throw new Exception(JText::sprintf('JLIB_APPLICATION_ERROR_TASK_NOT_FOUND', $task), 404);
    }
    $this->doTask = $doTask;
    $result = $this->$doTask();

    if ($task == 'saveprequote') {
      header('content-type: application/json; charset=utf-8');
      echo json_encode( $result );
      JFactory::getApplication()->close();
      return;
    }

    return $result;
  }

}
