<?php
defined( '_JEXEC' ) or die( 'Restricted access' );

class PriceleafsControllerPolicy extends JControllerLegacy
{

  function api() {
    ini_set('display_errors', 0);
    ini_set('display_startup_errors', 0);
    $data = json_decode(file_get_contents('php://input'), true);
    try {
      $details = $this->_api_validate_get_details($data);
      $type = 'api';
      $refnumber = $data['device_id'].uniqid();
      $receipt = $data['policy_invoice_number'];
      $session = array(
        'refnumber' => $refnumber,
        'type' => $type,
        'details' => $details,
      );
      IO::sqlInsert('#__priceleaf_session', $session);
      
      $total_premium_override = 0;
      if (!empty($data['policy_total_premium'])) {
        $total_premium_override = $data['policy_total_premium'];
      }
      $model = $this->getModel('policy');
      if (!$model->newpolicy($receipt, $refnumber, $total_premium_override)) {
        throw new Exception('Unable to save policy data: '.$receipt.' [#'.$refnumber.']');
      }
      
      $message = JText::_('Operation successful.');
      echo new JResponseJson($response, $message);
    } catch(Exception $e) {
      $message = $e->getMessage();
      $copy_data = $data;
      unset($copy_data['login_username']);
      unset($copy_data['login_password']);
      echo new JResponseJson([], $message, true);
    }
    jexit();
  }
  
  function _api_validate_get_details(&$data) {
    $all_devices = IO::getDevices();
    $required_fields = array(
      'login_username',
      'login_password',
      'contact_insured_name',
      'contact_enduser_name',
      'contact_institution',
      'contact_email',
      'contact_phone',
      'contact_address',
      'contact_suburb',
      'contact_state',
      'contact_postcode',
      'device_type',
      'device_make',
      'device_model',
      'device_purchase_date',
      'device_serial_number',
      'policy_invoice_number',
      'policy_reference_number',
      'policy_date_insured',
      'policy_sum_insured',
      'policy_num_of_year',
      'policy_excess',
      'policy_total_premium',
    );
    foreach ($required_fields as $field_name) {
      if (empty($data[ $field_name ])) {
        throw new Exception('Field [' .$field_name. '] is mandatory.');
      }
    }
    $mainframe = JFactory::getApplication('site');
    jimport('joomla.plugin.helper');
    $credentials = array();
    $credentials['username'] = $data['login_username'];
    $credentials['password'] = $data['login_password'];
    $error = $mainframe->login($credentials);
    $user = JFactory::getUser();
    if (empty($user->id)) {
      throw new Exception('Unable to login with provided credentials.');
    }
    if (!filter_var($data['contact_email'], FILTER_VALIDATE_EMAIL)) {
      throw new Exception('Field [contact_email] must contain valid email address.');
    }
    foreach ($all_devices as $device_id => $device_data) {
      if ($device_data->device_name == $data['device_type']) {
        $data['device_id'] = $device_id;
        $data['device_makes'] = $device_data->device_makes;
      }
    }
    if (empty($data['device_id']) || empty($data['device_makes'])) {
      throw new Exception('Value "'.$data['device_type'].'" is not a valid [device_type].');
    }
    if (!in_array($data['device_make'], $data['device_makes'])) {
      throw new Exception('Value "'.$data['device_make'].'" is not a valid [device_make].');
    }
    $device_purchase_date = date_parse($data['device_purchase_date']);
    if (!checkdate($device_purchase_date['month'], $device_purchase_date['day'], $device_purchase_date['year'])) {
      throw new Exception('Field [device_purchase_date] must contain a valid YYYY-MM-DD date value.');
    }
    if (strtotime($data['device_purchase_date']) < strtotime('-1 year')) {
      throw new Exception('Field [device_purchase_date] must be within a valid range.');
    }
    if (strtotime($data['device_purchase_date']) > strtotime('tomorrow')) {
      throw new Exception('Field [device_purchase_date] must be within a valid range.');
    }
    $policy_date_insured = date_parse($data['policy_date_insured']);
    if (!checkdate($policy_date_insured['month'], $policy_date_insured['day'], $policy_date_insured['year'])) {
      throw new Exception('Field [policy_date_insured] must contain a valid YYYY-MM-DD date value.');
    }
    //if (strtotime($data['policy_date_insured']) < strtotime('today')) {
    /*
    if (strtotime($data['policy_date_insured']) < strtotime('-1 month')) {
      throw new Exception('Field [policy_date_insured] must be within a valid range.');
    }
    if (strtotime($data['policy_date_insured']) > strtotime('+1 month')) {
      throw new Exception('Field [policy_date_insured] must be within a valid range.');
    }
    */
    $quotes = IO::getQuote($data['device_id'], IBROKER_DEFAULT_UNDERWRITER, array('postcode' => $data['contact_postcode'], 'sum_insured' => $data['policy_sum_insured'], 'make' => $data['device_make'], 'onsite' => 0, 'promo' => '', 'monthly' => 0));
    if (empty($quotes)) {
      throw new Exception('Provided field value [policy_sum_insured] do not produce valid quote.');
    }
    if (empty($quotes['quote'][ $data['policy_excess'] ][ $data['policy_num_of_year'] ]['premium_payable'])) {
      throw new Exception('Provided field values [policy_excess] and/or [policy_num_of_year] do not produce valid quote.');
    }
    $data['policy_quotes'] = $quotes['quote'][ $data['policy_excess'] ][ $data['policy_num_of_year'] ]['premium_payable'];
    $existing = IO::sqlSelect('#__priceleaf_policy', array(
      'column' => 'invoice',
      'operator' => '=',
      'value' => $data['policy_invoice_number'],
    ));
    if (!empty($existing->refNumber)) {
      throw new Exception('Policy with the same [policy_invoice_number] already exists.');
    }

    $excessyear = $data['policy_num_of_year'].','.$data['policy_excess'];
    $details = $data['contact_insured_name'].'{{}}'.IBROKER_DEFAULT_API_TAG.' '.$data['policy_reference_number'].'{{}}'.$data['contact_enduser_name'].'{{}}'.$user->id.'{{}}'.$data['contact_address'].'{{}}'.$data['contact_phone'].'{{}}'.$data['contact_suburb'].'{{}}'.$data['contact_state'].'{{}}'.$data['contact_postcode'].'{{}}'.$data['device_make'].'{{}}'.$data['device_model'].'{{}}'.$data['contact_institution'].'{{}}'.$data['contact_email'].'{{}}'.$data['device_id'].'{{}}'.$data['policy_sum_insured'].'{{}}'.$excessyear.'{{}}{{}}1{{}}'.$data['device_purchase_date'].'{{}}'.$data['device_serial_number'].'{{}}'.$data['policy_date_insured'].'{{}}0{{}}'.IBROKER_DEFAULT_UNDERWRITER.'{{}}0';

    $mainframe->logout();
    return $details;
  }

	function notification(){
	    $txnResponseCode = JRequest::getVar("vpc_TxnResponseCode");
	    $receiptNo       = JRequest::getVar("vpc_ReceiptNo");
	    $referenceNo     = JRequest::getVar("vpc_MerchTxnRef");
	    $link = 'index.php?option=com_priceleafs&view=policy';
	    if($txnResponseCode=="0"){
	        $model = $this->getModel('policy'); 
            if ($model->newpolicy($receiptNo, $referenceNo)) {	
                $msg = JText::_( 'COM_PRICELEAF_POLICY_SAVE' );
	              $link = 'index.php?option=com_content&view=article&id=18&Itemid=195';
	        } else {
		        $msg = JText::_( 'Error' );
	        }
	    }else{
	        switch ($responseCode) {
                case "?" : $result = "Transaction status is unknown"; break;
                case "1" : $result = "Unknown Error"; break;
                case "2" : $result = "Bank Declined Transaction"; break;
                case "3" : $result = "No Reply from Bank"; break;
                case "4" : $result = "Expired Card"; break;
                case "5" : $result = "Insufficient funds"; break;
                case "6" : $result = "Error Communicating with Bank"; break;
                case "7" : $result = "Payment Server System Error"; break;
                case "8" : $result = "Transaction Type Not Supported"; break;
                case "9" : $result = "Bank declined transaction (Do not contact Bank)"; break;
                case "A" : $result = "Transaction Aborted"; break;
                case "C" : $result = "Transaction Cancelled"; break;
                case "D" : $result = "Deferred transaction has been received and is awaiting processing"; break;
                case "F" : $result = "3D Secure Authentication failed"; break;
                case "I" : $result = "Card Security Code verification failed"; break;
                case "L" : $result = "Shopping Transaction Locked (Please try the transaction again later)"; break;
                case "N" : $result = "Cardholder is not enrolled in Authentication scheme"; break;
                case "P" : $result = "Transaction has been received by the Payment Adaptor and is being processed"; break;
                case "R" : $result = "Transaction was not processed - Reached limit of retry attempts allowed"; break;
                case "S" : $result = "Duplicate SessionID (OrderInfo)"; break;
                case "T" : $result = "Address Verification Failed"; break;
                case "U" : $result = "Card Security Code Failed"; break;
                case "V" : $result = "Address Verification and Card Security Code Failed"; break;
                default  : $result = "Your payment was unsuccessful. Please try again."; 
            }
            $msg = $result;
	    }
		$this->setRedirect($link, $msg);
	}
	
    function _processIPN($paypal_data) {
		$secure_post = false;
		$paypal_url = $this->_getPaypalURL(true); //true=sandbox, false=live url
		// read the post from PayPal system and add 'cmd'
		$post_msg = 'cmd=_notify-validate';
		foreach ($paypal_data as $key => $value) {
			if ($key != 'view' && $key != 'layout') {
			  $value = urlencode($value);
			  $post_msg .= "&$key=$value";
			}
		}
	
		//$this->checkPaypalIps($paypal_data['ipn_test']);
	
		// post back to PayPal system to validate
		$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-Length: " . strlen($post_msg) . "\r\n\r\n";
	
		//if ($secure_post) {
			// If possible, securely post back to paypal using HTTPS
			// Your PHP server will need to be SSL enabled
			$fps = fsockopen('ssl://' . $paypal_url, 443, $errno, $errstr, 30);
		//} else {
		//	$fps = fsockopen($paypal_url, 80, $errno, $errstr, 30);
		//}
	
		if (!$fps) {
			//$this->sendEmailToVendorAndAdmins("error with paypal", JText::sprintf('VMPAYMENT_PAYPAL_ERROR_POSTING_IPN', $errstr, $errno));
			return JText::sprintf('VMPAYMENT_PAYPAL_ERROR_POSTING_IPN', $errstr, $errno); // send email
		} else {
			fputs($fps, $header . $post_msg);
			while (!feof($fps)) {
			  $res = fgets($fps, 1024);
  	
			  if (strcmp($res, 'VERIFIED') == 0) {
				  return '';
			  } elseif (strcmp($res, 'INVALID') == 0) {
				  //$this->sendEmailToVendorAndAdmins("error with paypal IPN NOTIFICATION", JText::_('VMPAYMENT_PAYPAL_ERROR_IPN_VALIDATION') . $res);
				  return JText::_('VMPAYMENT_PAYPAL_ERROR_IPN_VALIDATION') . $res;
			  }
		  }
		}
	
		fclose($fps);
		return '';
  }
  
  function _getPaypalUrl($method) {
	
		$url = $method ? 'www.sandbox.paypal.com' : 'www.paypal.com';
	
		return $url;
  }
  
  
    
}
