<?php
defined('_JEXEC') or die;
class PriceleafsModelMenus extends JModelList
{
  protected function getListQuery()
	{
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		$query->select($this->getState('list.select','a.*,r.name AS device'));
		$query->from($db->quoteName('#__priceleaf_quotes').' AS a');
    $query->join('LEFT', '#__priceleaf_razdel AS r ON a.deviceType = r.id');
    $search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.')');
			}
		}						
				
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		if ($orderCol == '' || $orderCol == 'category_title') {
			$orderCol = 'a.id '.$orderDirn.', a.create_date, a.RefNumber';
		}
    $orderCol .= ', a.create_date, a.RefNumber';
		$query->order($db->escape($orderCol.' '.$orderDirn));

		return $query;
	}
	
  public function getQuotes($startdate,$enddate,&$referrers = array(),&$promoquotes = array(),&$promocodes = array(),&$apiquotes = array()){
	    $db = JFactory::getDBO();
        if($startdate==''){
            $startdate = date("Y-m-d");
        }else{
            $ndate = explode('-', $startdate);
            $startdate = $ndate[2].'-'.$ndate[1].'-'.$ndate[0];
        }
        
        if($enddate==''){
            $enddate = date("Y-m-d");
        }else{
            $mdate = explode('-', $enddate);
            $enddate = $mdate[2].'-'.$mdate[1].'-'.$mdate[0];
        }
	    $sql = "SELECT
        w.create_date,
        COUNT(IF(w.email = '', 1, null) AND IF(w.associate = 0, 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_prequote,
        COUNT(IF(w.email != '', 1, null) AND IF(w.associate = 0, 1, null)  AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_quote,
        COUNT(IF(w.RefNumber IN (SELECT refNumber from #__priceleaf_policy), 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_policy,
        COUNT(IF(w.RefNumber IN (SELECT refNumber from #__priceleaf_policy), 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null) AND IF(w.monthly_payment = 0, 1, null)) AS full_policy,
        COUNT(IF(w.RefNumber IN (SELECT refNumber from #__priceleaf_policy), 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null) AND IF(w.monthly_payment != 0, 1, null)) AS monthly_policy,
        COUNT(IF(w.email = '', 1, null) AND IF(w.associate = 1, 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_associate,
        COUNT(IF(w.email = '', 1, null) AND IF(w.promo_code != '', 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_promo_quote,
        COUNT(IF(w.email != '', 1, null) AND IF(w.promo_code != '', 1, null) AND IF(w.referrer NOT LIKE '[API]%', 1, null)) AS total_promo,
        COUNT(IF(w.email != '', 1, null) AND IF(w.referrer LIKE '[API]%', 1, null)) AS total_api
        FROM #__priceleaf_quotes AS w WHERE w.create_date BETWEEN ".$db->quote($startdate)." AND ".$db->quote($enddate)." GROUP BY w.create_date";
	    $db->setQuery($sql);
	    $rows = $db->loadObjectList();

      $referrers = $promoquotes = $promocodes = $apiquotes = array();
      foreach ($rows as $row) {
        $create_date = $row->create_date;
        if ($row->total_associate > 0) {
          $sql = "SELECT
            w.referrer,
            COUNT(w.referrer) AS total_referrer
            FROM #__priceleaf_quotes AS w
            WHERE w.create_date = ".$db->quote($create_date)."
            AND w.email = ''
            AND w.associate = 1
            AND w.referrer != ''
            GROUP BY w.referrer";
	        $db->setQuery($sql);
	        $refcounts = $db->loadObjectList();
          if (!empty($refcounts)) {
            foreach ($refcounts as $refcount) {
              $referrers[$create_date][$refcount->referrer] = $refcount->total_referrer;
            }
          }
        }
        if ($row->total_promo_quote > 0) {
          $sql = "SELECT
            w.promo_code,
            COUNT(w.promo_code) AS total_promo_quote
            FROM #__priceleaf_quotes AS w
            WHERE w.create_date = ".$db->quote($create_date)."
            AND w.promo_code != ''
            AND w.email = ''
            GROUP BY w.promo_code";
          $db->setQuery($sql);
          $refpromos = $db->loadObjectList();
          if (!empty($refpromos)) {
            foreach ($refpromos as $refpromo) {
              $promoquotes[$create_date][$refpromo->promo_code] = $refpromo->total_promo_quote;
            }
          }
        }
        if ($row->total_promo > 0) {
          $sql = "SELECT
            w.promo_code,
            COUNT(w.promo_code) AS total_promo
            FROM #__priceleaf_quotes AS w
            WHERE w.create_date = ".$db->quote($create_date)."
            AND w.promo_code != ''
            AND w.email != ''
            GROUP BY w.promo_code";
          $db->setQuery($sql);
          $refpromos = $db->loadObjectList();
          if (!empty($refpromos)) {
            foreach ($refpromos as $refpromo) {
              $promocodes[$create_date][$refpromo->promo_code] = $refpromo->total_promo;
            }
          }
        }
        if ($row->total_api > 0) {
          $sql = "SELECT
            w.referrer,
            COUNT(w.referrer) AS total_referrer
            FROM #__priceleaf_quotes AS w
            WHERE w.create_date = ".$db->quote($create_date)."
            AND w.associate = 0
            AND w.referrer LIKE '[API]%'
            GROUP BY w.referrer";
          $db->setQuery($sql);
          $refapis = $db->loadObjectList();
          if (!empty($refapis)) {
            foreach ($refapis as $refapi) {
              $apiquotes[$create_date][$refapi->referrer] = $refapi->total_referrer;
            }
          }
        }
      }

	    return $rows;
	}
	
}
