<?php

/**
 * @version    CVS: 1.underwriter
 * @package    Com_Ibroker_underwriter
 * @author     Ario Jatmiko <rarioj@gmail.com>
 * @copyright  2018 Ario Jatmiko
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
/**
 * underwriter Table class
 *
 * @since  1.6
 */
class Ibroker_underwriterTableunderwriter extends JTable
{
	
	/**
	 * Constructor
	 *
	 * @param   JDatabase  &$db  A database connector object
	 */
	public function __construct(&$db)
	{
		JObserverMapper::addObserverClassToClass('JTableObserverContenthistory', 'Ibroker_underwriterTableunderwriter', array('typeAlias' => 'com_ibroker_underwriter.underwriter'));
		parent::__construct('#__ibroker_underwriter', 'id', $db);
	}

	/**
	 * Overloaded bind function to pre-process the params.
	 *
	 * @param   array  $array   Named array
	 * @param   mixed  $ignore  Optional array or list of parameters to ignore
	 *
	 * @return  null|string  null is operation was satisfactory, otherwise returns an error
	 *
	 * @see     JTable:bind
	 * @since   1.5
	 */
	public function bind($array, $ignore = '')
	{
	    $date = JFactory::getDate();
		$task = JFactory::getApplication()->input->get('task');
	    
		$input = JFactory::getApplication()->input;
		$task = $input->getString('task', '');

		if ($array['id'] == 0 && empty($array['created_by']))
		{
			$array['created_by'] = JFactory::getUser()->id;
		}

		if ($array['id'] == 0 && empty($array['modified_by']))
		{
			$array['modified_by'] = JFactory::getUser()->id;
		}

		if ($task == 'apply' || $task == 'save')
		{
			$array['modified_by'] = JFactory::getUser()->id;
		}
		// Support for multi file field: uw_logo
		if (!empty($array['uw_logo']))
		{
			if (is_array($array['uw_logo']))
			{
				$array['uw_logo'] = implode(',', $array['uw_logo']);
			}
			elseif (strpos($array['uw_logo'], ',') != false)
			{
				$array['uw_logo'] = explode(',', $array['uw_logo']);
			}
		}
		else
		{
			$array['uw_logo'] = '';
		}

		// Support for multi file field: uw_pdf_document1
		if (!empty($array['uw_pdf_document1']))
		{
			if (is_array($array['uw_pdf_document1']))
			{
				$array['uw_pdf_document1'] = implode(',', $array['uw_pdf_document1']);
			}
			elseif (strpos($array['uw_pdf_document1'], ',') != false)
			{
				$array['uw_pdf_document1'] = explode(',', $array['uw_pdf_document1']);
			}
		}
		else
		{
			$array['uw_pdf_document1'] = '';
		}

		// Support for multi file field: uw_pdf_document2
		if (!empty($array['uw_pdf_document2']))
		{
			if (is_array($array['uw_pdf_document2']))
			{
				$array['uw_pdf_document2'] = implode(',', $array['uw_pdf_document2']);
			}
			elseif (strpos($array['uw_pdf_document2'], ',') != false)
			{
				$array['uw_pdf_document2'] = explode(',', $array['uw_pdf_document2']);
			}
		}
		else
		{
			$array['uw_pdf_document2'] = '';
		}

		// Support for multi file field: uw_pdf_document3
		if (!empty($array['uw_pdf_document3']))
		{
			if (is_array($array['uw_pdf_document3']))
			{
				$array['uw_pdf_document3'] = implode(',', $array['uw_pdf_document3']);
			}
			elseif (strpos($array['uw_pdf_document3'], ',') != false)
			{
				$array['uw_pdf_document3'] = explode(',', $array['uw_pdf_document3']);
			}
		}
		else
		{
			$array['uw_pdf_document3'] = '';
		}

		// Support for multi file field: uw_pdf_document4
		if (!empty($array['uw_pdf_document4']))
		{
			if (is_array($array['uw_pdf_document4']))
			{
				$array['uw_pdf_document4'] = implode(',', $array['uw_pdf_document4']);
			}
			elseif (strpos($array['uw_pdf_document4'], ',') != false)
			{
				$array['uw_pdf_document4'] = explode(',', $array['uw_pdf_document4']);
			}
		}
		else
		{
			$array['uw_pdf_document4'] = '';
		}

		// Support for multi file field: uw_pdf_document5
		if (!empty($array['uw_pdf_document5']))
		{
			if (is_array($array['uw_pdf_document5']))
			{
				$array['uw_pdf_document5'] = implode(',', $array['uw_pdf_document5']);
			}
			elseif (strpos($array['uw_pdf_document5'], ',') != false)
			{
				$array['uw_pdf_document5'] = explode(',', $array['uw_pdf_document5']);
			}
		}
		else
		{
			$array['uw_pdf_document5'] = '';
		}

		// Support for multi file field: uw_pdf_document6
		if (!empty($array['uw_pdf_document6']))
		{
			if (is_array($array['uw_pdf_document6']))
			{
				$array['uw_pdf_document6'] = implode(',', $array['uw_pdf_document6']);
			}
			elseif (strpos($array['uw_pdf_document6'], ',') != false)
			{
				$array['uw_pdf_document6'] = explode(',', $array['uw_pdf_document6']);
			}
		}
		else
		{
			$array['uw_pdf_document6'] = '';
		}

		// Support for multi file field: uw_pdf_document7
		if (!empty($array['uw_pdf_document7']))
		{
			if (is_array($array['uw_pdf_document7']))
			{
				$array['uw_pdf_document7'] = implode(',', $array['uw_pdf_document7']);
			}
			elseif (strpos($array['uw_pdf_document7'], ',') != false)
			{
				$array['uw_pdf_document7'] = explode(',', $array['uw_pdf_document7']);
			}
		}
		else
		{
			$array['uw_pdf_document7'] = '';
		}

		// Support for multi file field: uw_pdf_document8
		if (!empty($array['uw_pdf_document8']))
		{
			if (is_array($array['uw_pdf_document8']))
			{
				$array['uw_pdf_document8'] = implode(',', $array['uw_pdf_document8']);
			}
			elseif (strpos($array['uw_pdf_document8'], ',') != false)
			{
				$array['uw_pdf_document8'] = explode(',', $array['uw_pdf_document8']);
			}
		}
		else
		{
			$array['uw_pdf_document8'] = '';
		}


		// Support for multiple field: uw_associate_users
		if (isset($array['uw_associate_users']))
		{
			if (is_array($array['uw_associate_users']))
			{
				$array['uw_associate_users'] = implode(',',$array['uw_associate_users']);
			}
			elseif (strpos($array['uw_associate_users'], ',') != false)
			{
				$array['uw_associate_users'] = explode(',',$array['uw_associate_users']);
			}
			elseif (strlen($array['uw_associate_users']) == 0)
			{
				$array['uw_associate_users'] = '';
			}
		}
		else
		{
			$array['uw_associate_users'] = '';
		}

		// Support for multiple field: uw_referral_codes
		if (isset($array['uw_referral_codes']))
		{
			if (is_array($array['uw_referral_codes']))
			{
				$array['uw_referral_codes'] = implode(',',$array['uw_referral_codes']);
			}
			elseif (strpos($array['uw_referral_codes'], ',') != false)
			{
				$array['uw_referral_codes'] = explode(',',$array['uw_referral_codes']);
			}
			elseif (strlen($array['uw_referral_codes']) == 0)
			{
				$array['uw_referral_codes'] = '';
			}
		}
		else
		{
			$array['uw_referral_codes'] = '';
		}

		if (isset($array['params']) && is_array($array['params']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['params']);
			$array['params'] = (string) $registry;
		}

		if (isset($array['metadata']) && is_array($array['metadata']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['metadata']);
			$array['metadata'] = (string) $registry;
		}

		if (!JFactory::getUser()->authorise('core.admin', 'com_ibroker_underwriter.underwriter.' . $array['id']))
		{
			$actions         = JAccess::getActionsFromFile(
				JPATH_ADMINISTRATOR . '/components/com_ibroker_underwriter/access.xml',
				"/access/section[@name='underwriter']/"
			);
			$default_actions = JAccess::getAssetRules('com_ibroker_underwriter.underwriter.' . $array['id'])->getData();
			$array_jaccess   = array();

			foreach ($actions as $action)
			{
                if (key_exists($action->name, $default_actions))
                {
                    $array_jaccess[$action->name] = $default_actions[$action->name];
                }
			}

			$array['rules'] = $this->JAccessRulestoArray($array_jaccess);
		}

		// Bind the rules for ACL where supported.
		if (isset($array['rules']) && is_array($array['rules']))
		{
			$this->setRules($array['rules']);
		}

		return parent::bind($array, $ignore);
	}

	/**
	 * This function convert an array of JAccessRule objects into an rules array.
	 *
	 * @param   array  $jaccessrules  An array of JAccessRule objects.
	 *
	 * @return  array
	 */
	private function JAccessRulestoArray($jaccessrules)
	{
		$rules = array();

		foreach ($jaccessrules as $action => $jaccess)
		{
			$actions = array();

			if ($jaccess)
			{
				foreach ($jaccess->getData() as $group => $allow)
				{
					$actions[$group] = ((bool)$allow);
				}
			}

			$rules[$action] = $actions;
		}

		return $rules;
	}

	/**
	 * Overloaded check function
	 *
	 * @return bool
	 */
	public function check()
	{
		// If there is an ordering column and this is a new row then get the next ordering value
		if (property_exists($this, 'ordering') && $this->id == 0)
		{
			$this->ordering = self::getNextOrder();
		}
		
		
		// Support multi file field: uw_logo
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_logo'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_logo');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/images/underwriters/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_logo = "";

			foreach ($files['uw_logo'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_logo']))
					{
						$this->uw_logo = $array['uw_logo'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'image/jpeg,image/png';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/images/underwriters/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_logo .= (!empty($this->uw_logo)) ? "," : "";
					$this->uw_logo .= $filename;
				}
			}
		}
		else
		{
			$this->uw_logo .= $array['uw_logo_hidden'];
		}
		// Support multi file field: uw_pdf_document1
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document1'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document1');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document1 = "";

			foreach ($files['uw_pdf_document1'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document1']))
					{
						$this->uw_pdf_document1 = $array['uw_pdf_document1'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document1 .= (!empty($this->uw_pdf_document1)) ? "," : "";
					$this->uw_pdf_document1 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document1 .= $array['uw_pdf_document1_hidden'];
		}
		// Support multi file field: uw_pdf_document2
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document2'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document2');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document2 = "";

			foreach ($files['uw_pdf_document2'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document2']))
					{
						$this->uw_pdf_document2 = $array['uw_pdf_document2'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document2 .= (!empty($this->uw_pdf_document2)) ? "," : "";
					$this->uw_pdf_document2 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document2 .= $array['uw_pdf_document2_hidden'];
		}
		// Support multi file field: uw_pdf_document3
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document3'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document3');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document3 = "";

			foreach ($files['uw_pdf_document3'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document3']))
					{
						$this->uw_pdf_document3 = $array['uw_pdf_document3'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document3 .= (!empty($this->uw_pdf_document3)) ? "," : "";
					$this->uw_pdf_document3 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document3 .= $array['uw_pdf_document3_hidden'];
		}
		// Support multi file field: uw_pdf_document4
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document4'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document4');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document4 = "";

			foreach ($files['uw_pdf_document4'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document4']))
					{
						$this->uw_pdf_document4 = $array['uw_pdf_document4'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document4 .= (!empty($this->uw_pdf_document4)) ? "," : "";
					$this->uw_pdf_document4 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document4 .= $array['uw_pdf_document4_hidden'];
		}
		// Support multi file field: uw_pdf_document5
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document5'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document5');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document5 = "";

			foreach ($files['uw_pdf_document5'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document5']))
					{
						$this->uw_pdf_document5 = $array['uw_pdf_document5'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document5 .= (!empty($this->uw_pdf_document5)) ? "," : "";
					$this->uw_pdf_document5 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document5 .= $array['uw_pdf_document5_hidden'];
		}
		// Support multi file field: uw_pdf_document6
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document6'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document6');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document6 = "";

			foreach ($files['uw_pdf_document6'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document6']))
					{
						$this->uw_pdf_document6 = $array['uw_pdf_document6'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document6 .= (!empty($this->uw_pdf_document6)) ? "," : "";
					$this->uw_pdf_document6 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document6 .= $array['uw_pdf_document6_hidden'];
		}
		// Support multi file field: uw_pdf_document7
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document7'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document7');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document7 = "";

			foreach ($files['uw_pdf_document7'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document7']))
					{
						$this->uw_pdf_document7 = $array['uw_pdf_document7'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document7 .= (!empty($this->uw_pdf_document7)) ? "," : "";
					$this->uw_pdf_document7 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document7 .= $array['uw_pdf_document7_hidden'];
		}
		// Support multi file field: uw_pdf_document8
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if ($files['uw_pdf_document8'][0]['size'] > 0)
		{
			// Deleting existing files
			$oldFiles = Ibroker_underwriterHelper::getFiles($this->id, $this->_tbl, 'uw_pdf_document8');

			foreach ($oldFiles as $f)
			{
				$oldFile = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $f;

				if (file_exists($oldFile) && !is_dir($oldFile))
				{
					unlink($oldFile);
				}
			}

			$this->uw_pdf_document8 = "";

			foreach ($files['uw_pdf_document8'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['uw_pdf_document8']))
					{
						$this->uw_pdf_document8 = $array['uw_pdf_document8'];
					}
				}
				else
				{

					// Check for filetype
					$okMIMETypes = 'application/pdf,application/x-pdf';
					$validMIMEArray = explode(',', $okMIMETypes);
					$fileMime = $singleFile['type'];

					if (!in_array($fileMime, $validMIMEArray))
					{
						$app->enqueueMessage('This filetype is not allowed', 'warning');

						return false;
					}

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $filename;
					$fileTemp = $singleFile['tmp_name'];

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}

					$this->uw_pdf_document8 .= (!empty($this->uw_pdf_document8)) ? "," : "";
					$this->uw_pdf_document8 .= $filename;
				}
			}
		}
		else
		{
			$this->uw_pdf_document8 .= $array['uw_pdf_document8_hidden'];
		}

		return parent::check();
	}

	/**
	 * Method to set the publishing state for a row or list of rows in the database
	 * table.  The method respects checked out rows by other users and will attempt
	 * to checkin rows that it can after adjustments are made.
	 *
	 * @param   mixed    $pks     An optional array of primary key values to update.  If not
	 *                            set the instance property value is used.
	 * @param   integer  $state   The publishing state. eg. [0 = unpublished, 1 = published]
	 * @param   integer  $userId  The user id of the user performing the operation.
	 *
	 * @return   boolean  True on success.
	 *
	 * @since    1.0.4
	 *
	 * @throws Exception
	 */
	public function publish($pks = null, $state = 1, $userId = 0)
	{
		// Initialise variables.
		$k = $this->_tbl_key;

		// Sanitize input.
		ArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state  = (int) $state;

		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			// Nothing to set publishing state on, return false.
			else
			{
				throw new Exception(500, JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
			}
		}

		// Build the WHERE clause for the primary keys.
		$where = $k . '=' . implode(' OR ' . $k . '=', $pks);

		// Determine if there is checkin support for the table.
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time'))
		{
			$checkin = '';
		}
		else
		{
			$checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
		}

		// Update the publishing state for rows with the given primary keys.
		$this->_db->setQuery(
			'UPDATE `' . $this->_tbl . '`' .
			' SET `state` = ' . (int) $state .
			' WHERE (' . $where . ')' .
			$checkin
		);
		$this->_db->execute();

		// If checkin is supported and all rows were adjusted, check them in.
		if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
		{
			// Checkin each row.
			foreach ($pks as $pk)
			{
				$this->checkin($pk);
			}
		}

		// If the JTable instance value is in the list of primary keys that were set, set the instance.
		if (in_array($this->$k, $pks))
		{
			$this->state = $state;
		}

		return true;
	}

	/**
	 * Define a namespaced asset name for inclusion in the #__assets table
	 *
	 * @return string The asset name
	 *
	 * @see JTable::_getAssetName
	 */
	protected function _getAssetName()
	{
		$k = $this->_tbl_key;

		return 'com_ibroker_underwriter.underwriter.' . (int) $this->$k;
	}

	/**
	 * Returns the parent asset's id. If you have a tree structure, retrieve the parent's id using the external key field
	 *
	 * @param   JTable   $table  Table name
	 * @param   integer  $id     Id
	 *
	 * @see JTable::_getAssetParentId
	 *
	 * @return mixed The id on success, false on failure.
	 */
	protected function _getAssetParentId(JTable $table = null, $id = null)
	{
		// We will retrieve the parent-asset from the Asset-table
		$assetParent = JTable::getInstance('Asset');

		// Default: if no asset-parent can be found we take the global asset
		$assetParentId = $assetParent->getRootId();

		// The item has the component as asset-parent
		$assetParent->loadByName('com_ibroker_underwriter');

		// Return the found asset-parent-id
		if ($assetParent->id)
		{
			$assetParentId = $assetParent->id;
		}

		return $assetParentId;
	}

	/**
	 * Delete a record by id
	 *
	 * @param   mixed  $pk  Primary key value to delete. Optional
	 *
	 * @return bool
	 */
	public function delete($pk = null)
	{
		$this->load($pk);
		$result = parent::delete($pk);
		
		if ($result)
		{
			jimport('joomla.filesystem.file');

			foreach ($this->uw_logo as $uw_logoFile)
			{
				JFile::delete(JPATH_ROOT . '/images/underwriters/' . $uw_logoFile);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document1 as $uw_pdf_document1File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document1File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document2 as $uw_pdf_document2File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document2File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document3 as $uw_pdf_document3File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document3File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document4 as $uw_pdf_document4File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document4File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document5 as $uw_pdf_document5File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document5File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document6 as $uw_pdf_document6File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document6File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document7 as $uw_pdf_document7File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document7File);
			}
			jimport('joomla.filesystem.file');

			foreach ($this->uw_pdf_document8 as $uw_pdf_document8File)
			{
				JFile::delete(JPATH_ROOT . '/media/com_ibroker_underwriter/pdfs/' . $uw_pdf_document8File);
			}
		}

		return $result;
	}
}
