<?php

/**
 * @version    CVS: 1.underwriter
 * @package    Com_Ibroker_underwriter
 * @author     Ario Jatmiko <rarioj@gmail.com>
 * @copyright  2018 Ario Jatmiko
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Ibroker_underwriter records.
 *
 * @since  1.6
 */
class Ibroker_underwriterModelUnderwriters extends JModelList
{
    
        
/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.`id`',
				'ordering', 'a.`ordering`',
				'state', 'a.`state`',
				'created_by', 'a.`created_by`',
				'modified_by', 'a.`modified_by`',
				'uw_name', 'a.`uw_name`',
				'uw_logo', 'a.`uw_logo`',
				'uw_custom_editor1', 'a.`uw_custom_editor1`',
				'uw_custom_editor2', 'a.`uw_custom_editor2`',
				'uw_custom_editor3', 'a.`uw_custom_editor3`',
				'uw_custom_editor4', 'a.`uw_custom_editor4`',
				'uw_custom_editor5', 'a.`uw_custom_editor5`',
				'uw_custom_text1', 'a.`uw_custom_text1`',
				'uw_custom_text2', 'a.`uw_custom_text2`',
				'uw_custom_text3', 'a.`uw_custom_text3`',
				'uw_custom_text4', 'a.`uw_custom_text4`',
				'uw_custom_text5', 'a.`uw_custom_text5`',
				'uw_options', 'a.`uw_options`',
				'uw_pdf_document1', 'a.`uw_pdf_document1`',
				'uw_pdf_document2', 'a.`uw_pdf_document2`',
				'uw_pdf_document3', 'a.`uw_pdf_document3`',
				'uw_pdf_document4', 'a.`uw_pdf_document4`',
				'uw_pdf_document5', 'a.`uw_pdf_document5`',
				'uw_pdf_document6', 'a.`uw_pdf_document6`',
				'uw_pdf_document7', 'a.`uw_pdf_document7`',
				'uw_pdf_document8', 'a.`uw_pdf_document8`',
				'uw_associate_users', 'a.`uw_associate_users`',
				'uw_referral_codes', 'a.`uw_referral_codes`',
			);
		}

		parent::__construct($config);
	}

    
        
    
        
	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
		$this->setState('filter.state', $published);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_ibroker_underwriter');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.uw_name', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return   string A store id.
	 *
	 * @since    1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.state');

                
                    return parent::getStoreId($id);
                
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select', 'DISTINCT a.*'
			)
		);
		$query->from('`#__ibroker_underwriter` AS a');
                
		// Join over the users for the checked out user
		$query->select("uc.name AS uEditor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");

		// Join over the user field 'created_by'
		$query->select('`created_by`.name AS `created_by`');
		$query->join('LEFT', '#__users AS `created_by` ON `created_by`.id = a.`created_by`');

		// Join over the user field 'modified_by'
		$query->select('`modified_by`.name AS `modified_by`');
		$query->join('LEFT', '#__users AS `modified_by` ON `modified_by`.id = a.`modified_by`');
                

		// Filter by published state
		$published = $this->getState('filter.state');

		if (is_numeric($published))
		{
			$query->where('a.state = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.state IN (0, 1))');
		}

		// Filter by search in title
		$search = $this->getState('filter.search');

		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->Quote('%' . $db->escape($search, true) . '%');
				$query->where('( a.uw_name LIKE ' . $search . '  OR  a.uw_referral_codes LIKE ' . $search . ' )');
			}
		}
                
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering', "a.id");
		$orderDirn = $this->state->get('list.direction', "ASC");

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}

	/**
	 * Get an array of data items
	 *
	 * @return mixed Array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();
                
		foreach ($items as $oneItem)
		{

			if (isset($oneItem->uw_referral_codes))
			{
				$values    = explode(',', $oneItem->uw_referral_codes);
				$textValue = array();

				foreach ($values as $value)
				{
					if (!empty($value))
					{
						$db = JFactory::getDbo();
						$query = "SELECT `referral_code` AS code_key, `referral_code` code_value FROM #__ibroker_referralcode GROUP BY `referral_code` HAVING code_key LIKE '" . $value . "'";
						$db->setQuery($query);
						$results = $db->loadObject();

						if ($results)
						{
							$textValue[] = $results->code_value;
						}
					}
				}

				$oneItem->uw_referral_codes = !empty($textValue) ? implode(', ', $textValue) : $oneItem->uw_referral_codes;
			}
		}

		return $items;
	}
}
