<?php

/**
 * @version    CVS: 1.formulaoverride
 * @package    Com_Ibroker_formulaoverride
 * @author     Ario Jatmiko <rarioj@gmail.com>
 * @copyright  2017 Ario Jatmiko
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Ibroker_formulaoverride.
 *
 * @since  1.6
 */
class Ibroker_formulaoverrideViewFormulaoverrides extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
        $this->filterForm = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}

        JHtmlSidebar::addEntry( 'Device Types', 'index.php?option=com_ibroker_devicetype&view=devicetypes', false );
        JHtmlSidebar::addEntry( 'Underwriters', 'index.php?option=com_ibroker_underwriter&view=underwriters', false );
        JHtmlSidebar::addEntry( 'Formulas', 'index.php?option=com_ibroker_formula&view=formulas', false );
        JHtmlSidebar::addEntry( 'Formula Overrides', 'index.php?option=com_ibroker_formulaoverride&view=formulaoverrides', true );
        JHtmlSidebar::addEntry( 'Map User Codes', 'index.php?option=com_ibroker_mapusercode&view=mapusercodes', false );
        JHtmlSidebar::addEntry( 'Postcodes', 'index.php?option=com_ibroker_postcode&view=postcodes', false );
        JHtmlSidebar::addEntry( 'Referral Codes', 'index.php?option=com_ibroker_referralcode&view=referralcodes', false );
        JHtmlSidebar::addEntry( 'Promo Discounts', 'index.php?option=com_ibroker_discount&view=discounts', false );
        JHtmlSidebar::addEntry( '<hr />', '', false );
        JHtmlSidebar::addEntry( 'Quote Report', 'index.php?option=com_priceleafs&view=menus', false );
        JHtmlSidebar::addEntry( 'Policies', 'index.php?option=com_priceleafs&view=zakazs', false );
        JHtmlSidebar::addEntry( 'All Policies', 'index.php?option=com_priceleafs&view=csvs', false );
        JHtmlSidebar::addEntry( '<hr />', '', false );
        JHtmlSidebar::addEntry( 'Inventories', 'index.php?option=com_helloworld', false );

		$this->addToolbar();

		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return void
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		$state = $this->get('State');
		$canDo = Ibroker_formulaoverrideHelper::getActions();

		JToolBarHelper::title(JText::_('COM_IBROKER_FORMULAOVERRIDE_TITLE_FORMULAOVERRIDES'), 'formulaoverrides.png');

		// Check if the form exists before showing the add/edit buttons
		$formPath = JPATH_COMPONENT_ADMINISTRATOR . '/views/formulaoverride';

		if (file_exists($formPath))
		{
			if ($canDo->get('core.create'))
			{
				JToolBarHelper::addNew('formulaoverride.add', 'JTOOLBAR_NEW');

				if (isset($this->items[0]))
				{
					JToolbarHelper::custom('formulaoverrides.duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
				}
			}

			if ($canDo->get('core.edit') && isset($this->items[0]))
			{
				JToolBarHelper::editList('formulaoverride.edit', 'JTOOLBAR_EDIT');
			}
		}

		if ($canDo->get('core.edit.state'))
		{
			if (isset($this->items[0]->state))
			{
				JToolBarHelper::divider();
				JToolBarHelper::custom('formulaoverrides.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
				JToolBarHelper::custom('formulaoverrides.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			}
			elseif (isset($this->items[0]))
			{
				// If this component does not use state then show a direct delete button as we can not trash
				JToolBarHelper::deleteList('', 'formulaoverrides.delete', 'JTOOLBAR_DELETE');
			}

			if (isset($this->items[0]->state))
			{
				JToolBarHelper::divider();
				JToolBarHelper::archiveList('formulaoverrides.archive', 'JTOOLBAR_ARCHIVE');
			}

			if (isset($this->items[0]->checked_out))
			{
				JToolBarHelper::custom('formulaoverrides.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
			}
		}

		// Show trash and delete for components that uses the state field
		if (isset($this->items[0]->state))
		{
			if ($state->get('filter.state') == -2 && $canDo->get('core.delete'))
			{
				JToolBarHelper::deleteList('', 'formulaoverrides.delete', 'JTOOLBAR_EMPTY_TRASH');
				JToolBarHelper::divider();
			}
			elseif ($canDo->get('core.edit.state'))
			{
				JToolBarHelper::trash('formulaoverrides.trash', 'JTOOLBAR_TRASH');
				JToolBarHelper::divider();
			}
		}

		if ($canDo->get('core.admin'))
		{
			JToolBarHelper::preferences('com_ibroker_formula');
		}

		// Set sidebar action - New in 3.0
		JHtmlSidebar::setAction('index.php?option=com_ibroker_formulaoverride&view=formulaoverrides');
	}

	/**
	 * Method to order fields 
	 *
	 * @return void 
	 */
	protected function getSortFields()
	{
		return array(
			'a.`id`' => JText::_('JGRID_HEADING_ID'),
			'a.`ordering`' => JText::_('JGRID_HEADING_ORDERING'),
			'a.`state`' => JText::_('JSTATUS'),
			'a.`domain_rule_name`' => JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_DOMAIN_RULE_NAME'),
			'a.`referral_url`' => JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_REFERRAL_URL'),
			'a.`referral_code`' => JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_REFERRAL_CODE'),
			'a.`domain_value_device`' => JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_DOMAIN_VALUE_DEVICE'),
			'a.`domain_value_key`' => JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_DOMAIN_VALUE_KEY'),
		);
	}

    /**
     * Check if state is set
     *
     * @param   mixed  $state  State
     *
     * @return bool
     */
    public function getState($state)
    {
        return isset($this->state->{$state}) ? $this->state->{$state} : false;
    }
}
