<?php
/**
 * @version    CVS: 1.formulaoverride
 * @package    Com_Ibroker_formulaoverride
 * @author     Ario Jatmiko <rarioj@gmail.com>
 * @copyright  2017 Ario Jatmiko
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_ibroker_formulaoverride/css/form.css');
?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	js('input:hidden.domain_value_device').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('domain_value_devicehidden')){
			js('#jform_domain_value_device option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_domain_value_device").trigger("liszt:updated");
	});

	Joomla.submitbutton = function (task) {
		if (task == 'formulaoverride.cancel') {
			Joomla.submitform(task, document.getElementById('formulaoverride-form'));
		}
		else {
			
			if (task != 'formulaoverride.cancel' && document.formvalidator.isValid(document.id('formulaoverride-form'))) {
				
				Joomla.submitform(task, document.getElementById('formulaoverride-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_ibroker_formulaoverride&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="formulaoverride-form" class="form-validate">

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_IBROKER_FORMULAOVERRIDE_TITLE_FORMULAOVERRIDE', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

									<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php echo $this->form->renderField('created_by'); ?>
				<?php echo $this->form->renderField('modified_by'); ?>				<?php echo $this->form->renderField('domain_rule_name'); ?>
				<?php echo $this->form->renderField('referral_url'); ?>
				<?php echo $this->form->renderField('referral_code'); ?>
				<?php echo $this->form->renderField('domain_value_device'); ?>

			<?php
				foreach((array)$this->item->domain_value_device as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="domain_value_device" name="jform[domain_value_devicehidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>				<?php echo $this->form->renderField('domain_value_key'); ?>

      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('domain_value_formula'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->domain_value_formula.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('domain_value_formula'); ?></div>
      </div>


					<?php if ($this->state->params->get('save_history', 1)) : ?>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>

<style type="text/css">
code {
  background-color: transparent;
  border: none;
}
.code-view {
  margin-left: 180px;
}
textarea {
  font-family: monospace;
  width: 600px;
  height: 300px;
}
.formula .controls {
  display: none;
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
  $('.formula .code-view').click(function() {
    $(this).hide();
    $(this).next().show();
  });
});
</script>
