<?php
/**
 * @version     1.1.0
 * @package     com_ibroker_formula
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ario Jatmiko <ario@dedicated-it.com> - http://earthlinkdesign.com.au
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_ibroker_formula/assets/css/ibroker_formula.css');
?>
<script type="text/javascript">
    js = jQuery.noConflict();
    js(document).ready(function() {
        
    });

    Joomla.submitbutton = function(task)
    {
        if (task == 'formula.cancel') {
            Joomla.submitform(task, document.getElementById('formula-form'));
        }
        else {
            
            if (task != 'formula.cancel' && document.formvalidator.isValid(document.id('formula-form'))) {
                
                Joomla.submitform(task, document.getElementById('formula-form'));
            }
            else {
                alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
            }
        }
    }
</script>

<form action="<?php echo JRoute::_('index.php?option=com_ibroker_formula&layout=edit&id=' . (int) $this->item->id); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="formula-form" class="form-validate">

    <div class="form-horizontal">
        <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

        <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_IBROKER_FORMULA_TITLE_FORMULA', true)); ?>
        <div class="row-fluid">
            <div class="span10 form-horizontal">
                <fieldset class="adminform">

                    				<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php if(empty($this->item->created_by)){ ?>
					<input type="hidden" name="jform[created_by]" value="<?php echo JFactory::getUser()->id; ?>" />

				<?php } 
				else{ ?>
					<input type="hidden" name="jform[created_by]" value="<?php echo $this->item->created_by; ?>" />

				<?php } ?>			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('device'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('device'); ?></div>
			</div>
      <div class="control-group">
        <div class="control-label"><?php echo $this->form->getLabel('uw_id'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('uw_id'); ?></div>
      </div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('parameter'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('parameter'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_base_premium'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_base_premium.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_base_premium'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_fire_services_levy'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_fire_services_levy.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_fire_services_levy'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_marine_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_marine_gst.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_marine_gst'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_static_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_static_gst.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_static_gst'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_total_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_total_gst.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_total_gst'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_stamp_duty'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_stamp_duty.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_stamp_duty'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_underwriter_levy'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_underwriter_levy.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_underwriter_levy'); ?></div>
			</div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_underwriter_levy_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_underwriter_levy_gst.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_underwriter_levy_gst'); ?></div>
			</div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_broker_fee'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_broker_fee.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_broker_fee'); ?></div>
      </div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_broker_fee_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_broker_fee_gst.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_broker_fee_gst'); ?></div>
      </div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_additional_cover'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_additional_cover.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_additional_cover'); ?></div>
      </div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_additional_cover_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_additional_cover_gst.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_additional_cover_gst'); ?></div>
      </div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_premium_payable'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_premium_payable.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_premium_payable'); ?></div>
			</div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_premium_payable_monthly'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_premium_payable_monthly.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_premium_payable_monthly'); ?></div>
      </div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_associate_commission'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_associate_commission.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_associate_commission'); ?></div>
			</div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_associate_commission_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_associate_commission_gst.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_associate_commission_gst'); ?></div>
      </div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_ibroker_commission'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_ibroker_commission.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_ibroker_commission'); ?></div>
			</div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_ibroker_commission_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_ibroker_commission_gst.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_ibroker_commission_gst'); ?></div>
      </div>
			<div class="control-group formula">
				<div class="control-label"><?php echo $this->form->getLabel('fml_rch_commission'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_rch_commission.PHP_EOL.'?>'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('fml_rch_commission'); ?></div>
			</div>
      <div class="control-group formula">
        <div class="control-label"><?php echo $this->form->getLabel('fml_rch_commission_gst'); ?></div>
        <div class="code-view"><?php highlight_string('<?php'.PHP_EOL.$this->item->fml_rch_commission_gst.PHP_EOL.'?>'); ?></div>
        <div class="controls"><?php echo $this->form->getInput('fml_rch_commission_gst'); ?></div>
      </div>

                </fieldset>
            </div>
        </div>
        <?php echo JHtml::_('bootstrap.endTab'); ?>
        
        

        <?php echo JHtml::_('bootstrap.endTabSet'); ?>

        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>

    </div>
</form>

<style type="text/css">
code {
  background-color: transparent;
  border: none;
}
.code-view {
  margin-left: 180px;
}
textarea {
  font-family: monospace;
  width: 600px;
  height: 300px;
}
.formula .controls {
  display: none;
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
  $('.formula .code-view').click(function() {
    $(this).hide();
    $(this).next().show();
  });
});
</script>
