<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modellist');

class HelloWorldModelChange extends JModelLegacy
{
  public function getInventory($serial)
  {
    $db = JFactory::getDBO();
    $query = "SELECT * FROM #__inventory WHERE inv_serialno = ".$db->quote($serial)." ORDER BY inv_incept_date DESC LIMIT 1";
    $db->setQuery($query);
    $row = $db->loadObject();
    return $row;
  }
  public function insertInventory($fields)
  {
    return IO::sqlInsert('#__inventory', $fields);
  }
  public function changeValidate() {
    $old_serial = JRequest::getVar('old_serial', '');
    $old_serial = trim($old_serial);
    $new_serial = JRequest::getVar('new_serial', '');
    $new_serial = trim($new_serial);
    $effective_date = JRequest::getVar('effective_date', '');
    $effective_date = trim($effective_date);
    list($date, $month, $year) = explode('-', $effective_date);
    $effective_time = strtotime($year.'-'.$month.'-'.$date.' 00:00:00');
    if (empty($old_serial)) {
      return '<span class="error">'.JText::_('Please provide the old valid serial number.').'</span>';
    }
    if (empty($new_serial)) {
      return '<span class="error">'.JText::_('Please provide the new serial number.').'</span>';
    }
    if (empty($effective_date)) {
      return '<span class="error">'.JText::_('Please provide effective date.').'</span>';
    }
    if ($old_serial == $new_serial) {
      return '<span class="error">'.JText::_('Old and new serial cannot be identical.').'</span>';
    }
    $inventory = $this->getInventory($old_serial);
    if (empty($inventory)) {
      return '<span class="error">'.sprintf(JText::_("Old serial number [%s] cannot be found."), $old_serial).'</span>';
    }
    $new_inventory = $this->getInventory($new_serial);
    if (!empty($new_inventory)) {
      return '<span class="error">'.sprintf(JText::_('New serial number [%s] exists in inventory.'), $new_serial).'</span>';
    }

    $inception_time = strtotime($inventory->inv_incept_date);
    $expiration_time = strtotime($inventory->inv_expiry_date);
    $inception_input = date('d-m-Y', $inception_time);
    $expiration_input = date('d-m-Y', $expiration_time);
    $effective_input = date('d-m-Y', $effective_time);
    if ($effective_time < $inception_time || $effective_time > $expiration_time) {
      return '<span class="error">'.sprintf(JText::_('For device with serial number [%s] the new effective date must be between the inception date [%s] and the expiration date [%s].'), $old_serial, $inception_input, $expiration_input).'</span>';
    }

    return true;
  }
  public function changeSerial()
  {
    $inv_serialno     = JRequest :: getVar('inv_serialno', '');
		$inv_new_serialno = JRequest :: getVar('inv_new_serialno', ''); 
		$inv_eff_date2	  = JRequest :: getVar('inv_eff_date', ''); 
		$inv_incept_date2   = JRequest :: getVar('inv_incept_date', '');
		$inv_expiry_date2   = JRequest :: getVar('inv_expiry_date', '');
		$inv_make           = JRequest :: getVar('inv_make', '');
		$inv_model          = JRequest :: getVar('inv_model', '');
		$inv_serialno       = JRequest :: getVar('inv_serialno', '');
		$inv_sum_ins        = JRequest :: getVar('inv_sum_ins', '');
		$inv_excess         = JRequest :: getVar('inv_excess', '');
		$inv_id             = JRequest :: getVar('inv_id', '');
		$inv_incept_date    = date('Y-m-d', strtotime(str_replace('/', '-', $inv_incept_date2 .' 00:00:00')));
		$inv_expiry_date    = date('Y-m-d', strtotime(str_replace('/', '-', $inv_expiry_date2 .' 00:00:00')));
		
		$user	=& JFactory::getUser();
		$inv_user_id      = $user->id;
        $db =& JFactory::getDBO();
        $q = "INSERT INTO #__inventory(inv_incept_date, inv_expiry_date, inv_make, inv_model, inv_serialno, inv_sum_ins, inv_excess, inv_user_id, inv_cdate)";
		$q .= " VALUES ('".$inv_incept_date."', '".$inv_expiry_date."', '".$inv_make."', '".$inv_model."', '".$inv_serialno."', '".$inv_sum_ins."'";
		$q .= ", '".$inv_excess."', '".$inv_user_id."', NOW() )"; 
		$db->setQuery($q);
        $resul = $db->query();
		$msg = ($resul ? 'Create new Serial# success !' : 'Error create new Serial# !');
        return $msg;
  }
}
