﻿<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.controlleradmin');

class HelloWorldControllerChange extends JControllerLegacy
{
  protected $text_prefix = 'COM_HELLOWORLD_CHANGE';
  public function getModel($name = 'Change', $prefix = 'HelloWorldModel', $config = array())
  {
    $model = parent::getModel($name, $prefix, array('ignore_request' => true));
    return $model;
	}
  public function serial()
  {
    $model = parent::getModel('Change','HelloWorldModel');
    $msg = $model->changeSerial();
    $link = 'index.php?option=com_helloworld&view=serials';
    $this->setRedirect($link, $msg);
  }
  public function cancel()
  {
    $link = 'index.php?option=com_helloworld&view=serials';
    $this->setRedirect($link);
  }
  protected function inventoryHeaders() {
    return array(
      'inv_incept_date' => JText::_('Inception Date'),
      'inv_expiry_date' => JText::_('Expiration Date'),
      'inv_make' => JText::_('Make'),
      'inv_model' => JText::_('Model'),
      'inv_serialno' => JText::_('Serial Number'),
      'inv_sum_ins' => JText::_('Sum Insured'),
      'inv_excess' => JText::_('Excess'),
      'inv_referrer' => JText::_('Reference'),
      );
  }
  public function checkserial() {
    $model = parent::getModel('Change','HelloWorldModel');

    $error = $model->changeValidate();
    if ($error !== true) {
      die($error);
    }

    $old_serial = JRequest::getVar('old_serial', '');
    $old_serial = trim($old_serial);
    $new_serial = JRequest::getVar('new_serial', '');
    $new_serial = trim($new_serial);
    $effective_date = JRequest::getVar('effective_date', '');
    $effective_date = trim($effective_date);
    list($date, $month, $year) = explode('-', $effective_date);
    $effective_time = strtotime($year.'-'.$month.'-'.$date.' 00:00:00');
    $inventory = $model->getInventory($old_serial);
    $inception_time = strtotime($inventory->inv_incept_date);
    $expiration_time = strtotime($inventory->inv_expiry_date);
    $inception_input = date('d-m-Y', $inception_time);
    $expiration_input = date('d-m-Y', $expiration_time);
    $effective_input = date('d-m-Y', $effective_time);

    $headers = $this->inventoryHeaders();

    echo '<table id="change-serial-preview">';
    echo '<tr>';
    echo '<th colspan="2" class="table-header">'.JText::_('Existing Inventory Entry').'</th>';
    echo '<th colspan="2" class="table-header">'.JText::_('New Inventory Entries').'</th>';
    echo '</tr>';
    foreach ($headers as $column => $header) {
      echo '<tr>';
      echo '<th>'.$header.'</th>';
      switch ($column) {
        case 'inv_incept_date':
          echo '<th>'.$inception_input.'</th>';
          echo '<td>'.$inception_input.'</td>';
          echo '<td><span class="changed">'.$effective_input.'</span></td>';
          break;
        case 'inv_expiry_date':
          echo '<th>'.$expiration_input.'</th>';
          echo '<td><span class="changed">'.$effective_input.'</span></td>';
          echo '<td>'.$expiration_input.'</td>';
          break;
        case 'inv_model':
          echo '<th>'.$inventory->{$column}.'</th>';
          echo '<td><span class="changed">Replaced by '.$new_serial.'</span></td>';
          echo '<td><span class="changed">Replaces '.$old_serial.'</span></td>';
          break;
        case 'inv_serialno':
          echo '<th>'.$old_serial.'</th>';
          echo '<td>'.$old_serial.'</td>';
          echo '<td><span class="changed">'.$new_serial.'</span></td>';
          break;
        case 'inv_sum_ins':
        case 'inv_excess':
          echo '<th>$'.number_format($inventory->{$column}, 2).'</th>';
          echo '<td>$'.number_format($inventory->{$column}, 2).'</td>';
          echo '<td>$'.number_format($inventory->{$column}, 2).'</td>';
          break;
        default:
          echo '<th>'.$inventory->{$column}.'</th>';
          echo '<td>'.$inventory->{$column}.'</td>';
          echo '<td>'.$inventory->{$column}.'</td>';
          break;
      }
      echo '</tr>';
    }
    echo '</table>';

    echo '<br />';

    die();
  }
  public function confirm() {
    $new_inception_date = JRequest::getVar('new_inception_date', '');
    $new_inception_date = trim($new_inception_date);
    JRequest::setVar('effective_date', $new_inception_date); 

    $model = parent::getModel('Change','HelloWorldModel');
    $error = $model->changeValidate();
    if ($error !== true) {
      die($error);
    }

    $old_inception_date = JRequest::getVar('old_inception_date', '');
    $old_inception_date = trim($old_inception_date);
    list($date, $month, $year) = explode('-', $old_inception_date);
    $old_inception_date = $year.'-'.$month.'-'.$date.' 00:00:00';

    $new_inception_date = JRequest::getVar('new_inception_date', '');
    $new_inception_date = trim($new_inception_date);
    list($date, $month, $year) = explode('-', $new_inception_date);
    $new_inception_date = $year.'-'.$month.'-'.$date.' 00:00:00';

    $old_expiration_date = JRequest::getVar('old_expiration_date', '');
    $old_expiration_date = trim($old_expiration_date);
    list($date, $month, $year) = explode('-', $old_expiration_date);
    $old_expiration_date = $year.'-'.$month.'-'.$date.' 00:00:00';

    $new_expiration_date = JRequest::getVar('new_expiration_date', '');
    $new_expiration_date = trim($new_expiration_date);
    list($date, $month, $year) = explode('-', $new_expiration_date);
    $new_expiration_date = $year.'-'.$month.'-'.$date.' 00:00:00';

    $fields1 = array(
      'inv_incept_date' => $old_inception_date,
      'inv_expiry_date' => $old_expiration_date,
      'inv_make' => JRequest::getVar('old_make', ''),
      'inv_model' => JRequest::getVar('old_model', ''),
      'inv_serialno' => JRequest::getVar('old_serial', ''),
      'inv_sum_ins' => JRequest::getVar('old_sum_insured', 0),
      'inv_excess' => JRequest::getVar('old_excess', 0),
      'inv_user_id' => '',
      'inv_cdate' => date('Y-m-d H:i:s'),
      'inv_mdate' => date('Y-m-d H:i:s'),
      'inv_new_serialno' => JRequest::getVar('new_serial', ''),
      'inv_referrer' => JRequest::getVar('old_referrer', ''),
      );

    $fields2 = array(
      'inv_incept_date' => $new_inception_date,
      'inv_expiry_date' => $new_expiration_date,
      'inv_make' => JRequest::getVar('new_make', ''),
      'inv_model' => JRequest::getVar('new_model', ''),
      'inv_serialno' => JRequest::getVar('new_serial', ''),
      'inv_sum_ins' => JRequest::getVar('new_sum_insured', 0),
      'inv_excess' => JRequest::getVar('new_excess', 0),
      'inv_user_id' => '',
      'inv_cdate' => date('Y-m-d H:i:s'),
      'inv_mdate' => date('Y-m-d H:i:s'),
      'inv_new_serialno' => '',
      'inv_referrer' => JRequest::getVar('new_referrer', ''),
      );

    $msg = 'Failed adding new entries in the system';
    if (!empty($model->insertInventory($fields1))) {
      if (!empty($model->insertInventory($fields2))) {
        $msg = 'Entries added in the inventory';
      }
    }

    $link = 'index.php?option=com_helloworld&view=serials';
    $this->setRedirect($link, $msg);
  }
}
