<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_akquickicons
 *
 * @copyright   Copyright (C) 2012 Asikart. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Generated by AKHelper - http://asikart.com
 */

// no direct access
defined('_JEXEC') or die;

JFormHelper::loadFieldClass('Modal');

/**
 * Supports a modal article picker.
 *
 * @package        Joomla.Administrator
 * @subpackage     com_content
 * @since          1.6
 */
class JFormFieldIcon_Modal extends JFormFieldModal
{
	/**
	 * The form field type.
	 *
	 * @var     string
	 */
	protected $type = 'Icon_Modal';

	/**
	 * Property view_list.
	 *
	 * @var  string
	 */
	protected $view_list = 'icons';

	/**
	 * Property view_item.
	 *
	 * @var  string
	 */
	protected $view_item = 'icon';

	/**
	 * Property extension.
	 *
	 * @var  string
	 */
	protected $extension = 'com_akquickicons';

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 */
	public function getInput()
	{
		// Load the modal behavior script.
		JHtml::_('behavior.modal', 'a.modal');
		$this->setElement();

		$asset = \Windwalker\DI\Container::getInstance('com_akquickicons')->get('helper.asset');

		$asset->addCss('akicons.css');
		$asset->addCss('font-awesome.css');

		// Build the script.
		$script   = array();
		$script[] = '	function jSelect' . ucfirst($this->component) . '_' . $this->id . '(id, title) {';
		$script[] = '		document.id("' . $this->id . '_id").value = id;';
		$script[] = '		document.id("' . $this->id . '_name").value = title;';
		$script[] = '		$$("#' . $this->id . '_preview i").set("class", "ak"+title)';
		$script[] = '		SqueezeBox.close();';
		$script[] = '	}';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		// Setup variables for display.
		$html = array();
		$link = $this->getLink();

		$class = $this->value;

		if (empty($class))
		{
			$class = JText::_('COM_' . strtoupper($this->component) . '_SELECT_ITEM');
		}
		
		$class = htmlspecialchars($class, ENT_QUOTES, 'UTF-8');

		// The current user display field.
		$html[] = '<span class="input-append input-prepend">';
		$html[] = '<div class="media-preview add-on" id="' . $this->id . '_preview"><i class="' . $class . '"></i></div>';
		$html[] = '<input type="text" class="input-medium" id="' . $this->id . '_name" value="' . $class . '" disabled="disabled" size="35" /><a class="modal btn" title="' . JText::_('COM_' . strtoupper($this->component) . '_CHANGE_ITEM_BUTTON') . '"  href="' . $link . '&amp;' . JSession::getFormToken() . '=1" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-file"></i> ' . JText::_('JSELECT') . '</a>';
		$html[] = '</span>';

		$class = '';
		if ($this->required)
		{
			$class = ' class="required modal-value"';
		}

		$html[] = '<input type="hidden" id="' . $this->id . '_id"' . $class . ' name="' . $this->name . '" value="' . $this->value . '" />';

		return implode("\n", $html);
	}

	/**
	 * getLink
	 *
	 * @return  string
	 */
	public function getLink()
	{
		$input = JFactory::getApplication()->input;
		
		// Avoid self
		$id     = $input->get('id');
		$option = $input->get('option');
		$view   = $input->get('view');
		$layout = $input->get('layout');
		$params = '';

		$select = (string) $this->element['select'];
		$params .= "&select={$select}";

		return 'index.php?option=' . $this->extension . '&view=' . $this->view_list . $params . '&layout=modal_icon&tmpl=component&function=jSelect' . ucfirst($this->component) . '_' . $this->id;
	}
}
