<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonTimeline extends SppagebuilderAddons {

    public function render() {
        $class              = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $heading_selector   = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';
        $title              = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';

        $output = '';
        $output .= '<div class="sppb-addon sppb-addon-timeline ' . $class . '">';
        $output .= '<div class="sppb-addon-timeline-text-wrap">';
        $output .= ($title) ? '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>' : '';
        $output .= '</div>'; //.sppb-addon-instagram-text-wrap

        $output .= '<div class="sppb-addon-timeline-wrapper">';

        foreach ($this->addon->settings->sp_timeline_items as $key => $timeline) {
            $oddeven = (round($key % 2) == 0) ? 'even' : 'odd';
            $output .= '<div class="sppb-row timeline-movement ' . $oddeven . '">';
            $output .= '<div class="timeline-badge"></div>';
            if ($oddeven == 'odd') {
                $output .= '<div class="sppb-col-xs-12 sppb-col-sm-6  timeline-item">';
				$output .= '<div class="time-line">';
				$output .= '<div class="time-img-inner">';
				$output .= '<a class="time-img-inner-wrap">';
				$output  .= '<img class="sppb-img-responsive" src="' . $timeline->image . '" alt="">';
				$output .= '</a>';
				$output .= '</div>';
				$output .= '<div class="time-date">';
                $output .= '<p class="timeline-date text-right">' . $timeline->date . '</p>';
				$output .= '</div>';
				$output .= '</div>';
                
				$output .= '</div>';
				$output .= '<div class="sppb-col-xs-12 sppb-col-sm-6  timeline-item">';
                $output .= '<div class="timeline-panel" style="background-color:' . $timeline->box_bg_color . '; padding:' . $timeline->box_padding . '; border:' . $timeline->box_border_width . ' solid ' . $timeline->box_border_color . '; border-radius:' . $timeline->box_border_radius . '">';
				
				$output .= '<div class="sppb-media">';
				$output .= '<div class="pull-left">';
				$output .= '<div class="sppb-icon" style=" margin:' . $timeline->icon_margin_top . 'px ' . $timeline->icon_margin_right . 'px ' . $timeline->icon_margin_bottom . 'px ' . $timeline->icon_margin_left . 'px;">';
				$output .= '<div class="for-shadow" style="border-radius:' . $timeline->icon_border_radius . ';">';
				$output .= '<span class="for-shadow-spn" style="border:' . $timeline->icon_border_width . 'px solid ' . $timeline->icon_border_color . '; border-radius:' . $timeline->icon_border_radius . '; padding:' . $timeline->icon_padding . 'px; display:inline-block; text-align:center; background:' . $timeline->icon_background . ';">';
				
				$output  .= '<i class="fa ' . $timeline->icon_name . '" style="color:' . $timeline->icon_color . ';font-size:' . $timeline->icon_size . 'px; width:' . $timeline->icon_size . 'px; height:' . $timeline->icon_size . 'px; line-height:' . $timeline->icon_size . 'px;"></i>';
				$output .= '</span>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
							
				$output .= '<div class="sppb-media-body">';
                $output .= '<a href="' . $timeline->title_url . '" class="title" style="font-size:' . $timeline->title_fontsize . 'px; margin-top:' . $timeline->title_top_margin . ';  margin-bottom:' . $timeline->title_bottom_margin . ';  font-weight:' . $timeline->title_fontweight . '; text-transform:' . $timeline->heading_transform . ';  color:' . $timeline->title_text_color . '; ">' . $timeline->title . '</a>';
                $output .= '<div class="" style="margin-top:10px; color:' . $timeline->text_color . ';">' . $timeline->content . '</div>';
				$output .= '</div>';
				$output .= '</div>';
				
				$output .= '</div>';
                $output .= '</div>';
				
				
            } elseif ($oddeven == 'even') {
                $output .= '<div class="sppb-col-xs-12 sppb-col-sm-6  timeline-item">';
                $output .= '<div class="timeline-panel left-part" style="background-color:' . $timeline->box_bg_color . '; padding:' . $timeline->box_padding . '; border:' . $timeline->box_border_width . ' solid ' . $timeline->box_border_color . '; border-radius:' . $timeline->box_border_radius . '">';
				
				$output .= '<div class="sppb-media">';
				$output .= '<div class="pull-right">';
				$output .= '<div class="sppb-icon"  style="margin:' . $timeline->icon_margin_top . 'px ' . $timeline->icon_margin_right . 'px ' . $timeline->icon_margin_bottom . 'px ' . $timeline->icon_margin_left . 'px;">';
				$output .= '<div class="for-shadow" style="border-radius:' . $timeline->icon_border_radius . ';">';
				$output .= '<span class="for-shadow-spn" style="border:' . $timeline->icon_border_width . 'px solid ' . $timeline->icon_border_color . '; border-radius:' . $timeline->icon_border_radius . '; padding:' . $timeline->icon_padding . 'px; display:inline-block; text-align:center; background:' . $timeline->icon_background . ';">';
				
				$output  .= '<i class="fa ' . $timeline->icon_name . '" style="color:' . $timeline->icon_color . ';font-size:' . $timeline->icon_size . 'px; width:' . $timeline->icon_size . 'px; height:' . $timeline->icon_size . 'px; line-height:' . $timeline->icon_size . 'px;"></i>';
				$output .= '</span>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</div>';
				
				$output .= '<div class="sppb-media-body">';
                $output .= '<a href="' . $timeline->title_url . '" class="title" style="font-size:' . $timeline->title_fontsize . 'px; margin-top:' . $timeline->title_top_margin . ';  margin-bottom:' . $timeline->title_bottom_margin . ';  font-weight:' . $timeline->title_fontweight . '; text-transform:' . $timeline->heading_transform . ';  color:' . $timeline->title_text_color . '; ">' . $timeline->title . '</a>';
                $output .= '<div class="" style="margin-top:10px; color:' . $timeline->text_color . ';">' . $timeline->content . '</div>';
				$output .= '</div>';
				$output .= '</div>';
				
                $output .= '</div>';
                $output .= '</div>';
                $output .= '<div class="sppb-col-xs-12 sppb-col-sm-6  timeline-item">';
				
				$output .= '<div class="time-line">';
				$output .= '<div class="time-img-inner">';
				$output .= '<a class="time-img-inner-wrap">';
				$output  .= '<img class="sppb-img-responsive" src="' . $timeline->image . '" alt="">';
				$output .= '</a>';
				$output .= '</div>';
				$output .= '<div class="time-date">';
                $output .= '<p class="timeline-date text-left">' . $timeline->date . '</p>';
				$output .= '</div>';
				$output .= '</div>';
				
				$output .= '</div>';
            }
            $output .= '</div>'; //.timeline-movement
        } // foreach timelines

        $output .= '</div>'; //.Timeline

        $output .= '</div>'; //.sppb-addon-instagram-gallery

        return $output;
    }

    public function css() {
        $addon_id = '#sppb-addon-' . $this->addon->id;
        $bar_color = (isset($this->addon->settings->bar_color) && $this->addon->settings->bar_color) ? $this->addon->settings->bar_color : '#0095eb';

        $css = '';
        if ($bar_color) {
            $css .= $addon_id . ' .sppb-addon-timeline .sppb-addon-timeline-wrapper:before, ' . $addon_id . ' .sppb-addon-timeline .sppb-addon-timeline-wrapper .timeline-badge:after, '. $addon_id .' .sppb-addon-timeline .timeline-movement.even:before{';
            $css .= 'background-color: ' . $bar_color . ';';
            $css .= '}';

            $css .= $addon_id . ' .sppb-addon-timeline .sppb-addon-timeline-wrapper .timeline-badge:before, '. $addon_id .' .sppb-addon-timeline .timeline-movement.even:after{';
            $css .= 'border-color: ' . $bar_color . ';';
            $css .= '}';
        }

        return $css;
    }

}
