<?php
/**
 * @package         Better Trash
 * @version         1.1.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2018 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

require_once __DIR__ . '/script.install.helper.php';

class PlgSystemBetterTrashInstallerScript extends PlgSystemBetterTrashInstallerScriptHelper
{
	public $name           = 'BETTER_TRASH';
	public $alias          = 'bettertrash';
	public $extension_type = 'plugin';

	public function onAfterInstall($route)
	{
		$this->deleteOldTable();
	}


	public function deleteOldTable()
	{
		$query = 'DROP TABLE IF EXISTS `#__bettertrash_sefs`;';
		$this->db->setQuery($query);
		$this->db->execute();
	}
}
