<?php
/**
 * @package         Better Trash
 * @version         1.1.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://www.regularlabs.com
 * @copyright       Copyright © 2018 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

// Do not instantiate plugin on install pages
// to prevent installation/update breaking because of potential breaking changes
if (
	in_array(JFactory::getApplication()->input->get('option'), ['com_installer', 'com_regularlabsmanager'])
	&& JFactory::getApplication()->input->get('action') != ''
)
{
	return;
}

if ( ! is_file(__DIR__ . '/vendor/autoload.php'))
{
	return;
}

require_once __DIR__ . '/vendor/autoload.php';

use RegularLabs\Plugin\System\BetterTrash\Plugin;

class PlgSystemBetterTrash extends Plugin
{
	public $_alias       = 'bettertrash';
	public $_title       = 'BETTER_TRASH';
	public $_lang_prefix = 'BP';

	public $_enable_in_frontend    = false;
	public $_enable_in_admin       = true;
	public $_disable_on_components = true;
	public $_page_types            = ['html'];

	/*
	 * Below are the events that this plugin uses
	 * All handling is passed along to the parent run method
	 */
	public function onAfterInitialise()
	{
		$this->run();
	}

	public function onContentAfterSave()
	{
		$this->run();
	}

	public function onContentAfterDelete()
	{
		$this->run();
	}

	public function onContentChangeState()
	{
		$this->run();
	}

	public function onAfterRender()
	{
		$this->run();
	}
}
