<?php
/**
 * @package Helix Shortcode Generator
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2015 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined('_JEXEC') or die;

jimport( 'joomla.version' );

class plgButtonHelix_Shortcode extends JPlugin{

	protected $autoloadLanguage = true;

	public function onDisplay($name){

		require_once( dirname( __FILE__ ) . '/shortcodes.php' );

		$doc = JFactory::getDocument();
		JHtml::_('jquery.ui', array('core', 'more', 'sortable'));
		$doc->addScriptDeclaration( "var helix_editor = '{$name}';" );
		asort($sp_shortcodes);

		// if joomla version is more than 3.5
		if ( version_compare(JVERSION, '3.5', 'ge') ) {
			$doc->addScriptDeclaration( "var helix_jversion = 'true';" );
		} else {
			$doc->addScriptDeclaration( "var helix_jversion = 'false';" );
		}

		?>
		
		<div id="helix-shortcode-modal" class="modal hide">
			<div class="modal-header">
				<div class="row-fluid">
					<div class="span4">
						<h3><?php echo JText::_('PLG_HELIX_SHORTCODE_SELECT_SHORTCODE'); ?></h3>
					</div>
					<div class="span7">

						<?php

						echo '<select id="select-shortcode">>';
						echo '<option value="">--' . JText::_('PLG_HELIX_SHORTCODE_SELECT_SHORTCODE') . '--</option>';

						foreach( $sp_shortcodes as $shortcode => $options ){
							echo '<option value="sp-' . $shortcode . '">'. $options['title'] .'</option>';
						} 

						echo '</select>';

						?>

					</div>
					<div class="span1">
						<a href="#" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></a>
					</div>
				</div>
			</div>
			<div class="modal-body" style="overflow:auto;">

			</div>

			<div class="modal-footer">
				<a href="#" class="btn btn-info pull-left" id="add-shortcode" data-dismiss="modal"><?php echo JText::_('PLG_HELIX_SHORTCODE_ADD_SHORTCODE'); ?></a>
				<button class="btn btn-danger pull-left" data-dismiss="modal" aria-hidden="true"><?php echo JText::_('PLG_HELIX_SHORTCODE_CANCEL'); ?></button>
			</div>

		</div>

			<div id="generated-shortcode" style="display:none;">

				<?php

				echo '<div class="shortcode-list">';

				foreach( $sp_shortcodes as $shortcode => $options ){


					if( !empty($options['attr']) )
					{
						echo '<div data-shortcode_type="' . $options['type'] . '" data-shortcode="' . $shortcode . '" class="shortcode-item sp-' . $shortcode . '">';

						foreach( $options['attr'] as $name => $attr_option )
						{


							if( $attr_option['type'] == 'repetable' )
							{

								echo '<div class="shortcode-repeatable">';
								echo '<a href="#" class="clone-shortcode btn btn-success"><i class="icon-new"></i> ' . JText::_('PLG_HELIX_SHORTCODE_ADD') . ' ' . $options['title'] . '</a>';
								echo '<div class="repeatable-container">';
								echo '<div data-shortcode_item="' . $shortcode . '_item" class="repeatable-item">';

								?>
								<div class="repeatable-title clearfix">
									<a href="#" class="action-move"><i class="icon-menu"></i></a>
									<h3><i></i> <span><?php echo $options['title']; ?></span></h3>
									<a href="#" class="action-remove"><i class="icon-cancel"></i></a>
									<a href="#" class="action-duplicate"><i class="icon-save-copy"></i></a>
								</div>

								<div class="repeatable-content collapse">
									<div>

										<?php

										foreach( $attr_option['attr'] as $key => $attr )
										{

											echo self::generate( $key, $attr, $attr['type'], $name );

										}

										echo '</div>';
										echo '</div>';
										echo '</div>';
										echo '</div>';
										echo '</div>';
									}
									else
									{
										echo self::generate( $name, $attr_option, $options['type'], $shortcode );

									}

								}

								echo '</div>';
							}


						} 

						echo '</div>';

						?>
					</div>	


		<?php	

		$doc->addStylesheet( JURI::root( true ) . '/plugins/editors-xtd/helix_shortcode/assets/css/helix-shortcode.css');
		$doc->addScript( JURI::root( true ) . '/plugins/editors-xtd/helix_shortcode/assets/js/shortcode-generator.js');

		$button = new JObject;
		$button->modal 		= false;
		$button->class 		= 'btn btn-modal btn-primary btn-helixv2-shortcode';
		$button->link 		= '#';
		$button->text 		= 'Helix Shortcodes';
       	$button->name 		= 'plus-circle helixv2-shortcode';

		return $button;
	}


	//Generate Shortcodes
	private static function generate( $name, $attr, $type, $shortcode ){

		$output = '';

		if( !isset($attr['value']) )
		{
			$attr['value']='';
		}

		if( !isset($attr['placeholder']) )
		{
			$attr['placeholder']='';
		}

		if( !isset($attr['content']) )
		{
			$attr['content']=false;
		}

    	//Select Type
		switch( $attr['type'] )
		{ 

			//Select
			case 'select':

			$output .= '<div class="control-group">
			<label class="control-label">'.$attr['title'].'</label>

			<div class="controls"><select class="shortcode-input" data-attrname="'.$name.'">';
			$values = $attr['values'];
			foreach( $values as $index=>$value ){
				$output .= '<option value="'.$index.'">'.$value.'</option>';
			}
			$output .= '</select></div></div>';

			break;

			//Icons
			case 'icons':
			
			$fontawesome_icons = array(
					"",
					'fa-glass',
					'fa-music',
					'fa-search',
					'fa-envelope-alt',
					'fa-heart',
					'fa-star',
					'fa-star-empty',
					'fa-user',
					'fa-film',
					'fa-th-large',
					'fa-th',
					'fa-th-list',
					'fa-ok',
					'fa-remove',
					'fa-zoom-in',
					'fa-zoom-out',
					'fa-off',
					'fa-signal',
					'fa-cog',
					'fa-trash',
					'fa-home',
					'fa-file-alt',
					'fa-time',
					'fa-road',
					'fa-download-alt',
					'fa-download',
					'fa-upload',
					'fa-inbox',
					'fa-play-circle',
					'fa-repeat',
					'fa-refresh',
					'fa-list-alt',
					'fa-lock',
					'fa-flag',
					'fa-headphones',
					'fa-volume-off',
					'fa-volume-down',
					'fa-volume-up',
					'fa-qrcode',
					'fa-barcode',
					'fa-tag',
					'fa-tags',
					'fa-book',
					'fa-bookmark',
					'fa-print',
					'fa-camera',
					'fa-font',
					'fa-bold',
					'fa-italic',
					'fa-text-height',
					'fa-text-width',
					'fa-align-left',
					'fa-align-center',
					'fa-align-right',
					'fa-align-justify',
					'fa-list',
					'fa-indent-left',
					'fa-indent-right',
					'fa-facetime-video',
					'fa-picture',
					'fa-pencil',
					'fa-map-marker',
					'fa-adjust',
					'fa-tint',
					'fa-edit',
					'fa-share',
					'fa-check',
					'fa-move',
					'fa-step-backward',
					'fa-fast-backward',
					'fa-backward',
					'fa-play',
					'fa-pause',
					'fa-stop',
					'fa-forward',
					'fa-fast-forward',
					'fa-step-forward',
					'fa-eject',
					'fa-chevron-left',
					'fa-chevron-right',
					'fa-plus-sign',
					'fa-minus-sign',
					'fa-remove-sign',
					'fa-ok-sign',
					'fa-question-sign',
					'fa-info-sign',
					'fa-screenshot',
					'fa-remove-circle',
					'fa-ok-circle',
					'fa-ban-circle',
					'fa-arrow-left',
					'fa-arrow-right',
					'fa-arrow-up',
					'fa-arrow-down',
					'fa-share-alt',
					'fa-resize-full',
					'fa-resize-small',
					'fa-plus',
					'fa-minus',
					'fa-asterisk',
					'fa-exclamation-sign',
					'fa-gift',
					'fa-leaf',
					'fa-fire',
					'fa-eye-open',
					'fa-eye-close',
					'fa-warning-sign',
					'fa-plane',
					'fa-calendar',
					'fa-random',
					'fa-comment',
					'fa-magnet',
					'fa-chevron-up',
					'fa-chevron-down',
					'fa-retweet',
					'fa-shopping-cart',
					'fa-folder-close',
					'fa-folder-open',
					'fa-resize-vertical',
					'fa-resize-horizontal',
					'fa-bar-chart',
					'fa-twitter-sign',
					'fa-facebook-sign',
					'fa-camera-retro',
					'fa-key',
					'fa-cogs',
					'fa-comments',
					'fa-thumbs-up-alt',
					'fa-thumbs-down-alt',
					'fa-star-half',
					'fa-heart-empty',
					'fa-signout',
					'fa-linkedin-sign',
					'fa-pushpin',
					'fa-external-link',
					'fa-signin',
					'fa-trophy',
					'fa-github-sign',
					'fa-upload-alt',
					'fa-lemon',
					'fa-phone',
					'fa-check-empty',
					'fa-bookmark-empty',
					'fa-phone-sign',
					'fa-twitter',
					'fa-facebook',
					'fa-github',
					'fa-unlock',
					'fa-credit-card',
					'fa-rss',
					'fa-hdd',
					'fa-bullhorn',
					'fa-bell',
					'fa-certificate',
					'fa-hand-right',
					'fa-hand-left',
					'fa-hand-up',
					'fa-hand-down',
					'fa-circle-arrow-left',
					'fa-circle-arrow-right',
					'fa-circle-arrow-up',
					'fa-circle-arrow-down',
					'fa-globe',
					'fa-wrench',
					'fa-tasks',
					'fa-filter',
					'fa-briefcase',
					'fa-fullscreen',
					'fa-group',
					'fa-link',
					'fa-cloud',
					'fa-beaker',
					'fa-cut',
					'fa-copy',
					'fa-paper-clip',
					'fa-save',
					'fa-sign-blank',
					'fa-reorder',
					'fa-list-ul',
					'fa-list-ol',
					'fa-strikethrough',
					'fa-underline',
					'fa-table',
					'fa-magic',
				
					'fa-truck',
					'fa-pinterest',
					'fa-pinterest-sign',
					'fa-google-plus-sign',
					'fa-google-plus',
					'fa-money',
					'fa-caret-down',
					'fa-caret-up',
					'fa-caret-left',
					'fa-caret-right',
					'fa-columns',
					'fa-sort',
					'fa-sort-down',
					'fa-sort-up',
					'fa-envelope',
					'fa-linkedin',
					'fa-undo',
					'fa-legal',
					'fa-dashboard',
					'fa-comment-alt',
					'fa-comments-alt',
					'fa-bolt',
					'fa-sitemap',
					'fa-umbrella',
					'fa-paste',
					'fa-lightbulb',
					'fa-exchange',
					'fa-cloud-download',
					'fa-cloud-upload',
					'fa-user-md',
					'fa-stethoscope',
					'fa-suitcase',
					'fa-bell-alt',
					'fa-coffee',
					'fa-food',
					'fa-file-text-alt',
					'fa-building',
					'fa-hospital',
					'fa-ambulance',
					'fa-medkit',
					'fa-fighter-jet',
					'fa-beer',
					'fa-h-sign',
					'fa-plus-sign-alt',
					'fa-double-angle-left',
					'fa-double-angle-right',
					'fa-double-angle-up',
					'fa-double-angle-down',
					'fa-angle-left',
					'fa-angle-right',
					'fa-angle-up',
					'fa-angle-down',
					'fa-desktop',
					'fa-laptop',
					'fa-tablet',
					'fa-mobile-phone',
					'fa-circle-blank',
					'fa-quote-left',
					'fa-quote-right',
					'fa-spinner',
					'fa-circle',
					'fa-reply',
					'fa-github-alt',
					'fa-folder-close-alt',
					'fa-folder-open-alt',
					'fa-expand-alt',
					'fa-collapse-alt',
					'fa-smile',
					'fa-frown',
					'fa-meh',
					'fa-gamepad',
					'fa-keyboard',
					'fa-flag-alt',
					'fa-flag-checkered',
					'fa-terminal',
					'fa-code',
					'fa-reply-all',
					'fa-mail-reply-all',
					'fa-star-half-empty',
					'fa-location-arrow',
					'fa-crop',
					'fa-code-fork',
					'fa-unlink',
					'fa-question',
					'fa-info',
					'fa-exclamation',
					'fa-superscript',
					'fa-subscript',
					'fa-eraser',
					'fa-puzzle-piece',
					'fa-microphone',
					'fa-microphone-off',
					'fa-shield',
					'fa-calendar-empty',
					'fa-fire-extinguisher',
					'fa-rocket',
					'fa-maxcdn',
					'fa-chevron-sign-left',
					'fa-chevron-sign-right',
					'fa-chevron-sign-up',
					'fa-chevron-sign-down',
					'fa-html5',
					'fa-css3',
					'fa-anchor',
					'fa-unlock-alt',
					'fa-bullseye',
					'fa-ellipsis-horizontal',
					'fa-ellipsis-vertical',
					'fa-rss-sign',
					'fa-play-sign',
					'fa-ticket',
					'fa-minus-sign-alt',
					'fa-check-minus',
					'fa-level-up',
					'fa-level-down',
					'fa-check-sign',
					'fa-edit-sign',
					'fa-external-link-sign',
					'fa-share-sign',
					'fa-compass',
					'fa-collapse',
					'fa-collapse-top',
					'fa-expand',
					'fa-eur',
					'fa-gbp',
					'fa-usd',
					'fa-inr',
					'fa-jpy',
					'fa-cny',
					'fa-krw',
					'fa-btc',
					'fa-file',
					'fa-file-text',
					'fa-sort-by-alphabet',
					'fa-sort-by-alphabet-alt',
					'fa-sort-by-attributes',
					'fa-sort-by-attributes-alt',
					'fa-sort-by-order',
					'fa-sort-by-order-alt',
					'fa-thumbs-up',
					'fa-thumbs-down',
					'fa-youtube-sign',
					'fa-youtube',
					'fa-xing',
					'fa-xing-sign',
					'fa-youtube-play',
					'fa-dropbox',
					'fa-stackexchange',
					'fa-instagram',
					'fa-flickr',
					'fa-adn',
					'fa-bitbucket',
					'fa-bitbucket-sign',
					'fa-tumblr',
					'fa-tumblr-sign',
					'fa-long-arrow-down',
					'fa-long-arrow-up',
					'fa-long-arrow-left',
					'fa-long-arrow-right',
					'fa-apple',
					'fa-windows',
					'fa-android',
					'fa-linux',
					'fa-dribbble',
					'fa-skype',
					'fa-foursquare',
					'fa-trello',
					'fa-female',
					'fa-male',
					'fa-gittip',
					'fa-sun',
					'fa-moon',
					'fa-archive',
					'fa-bug',
					'fa-vk',
					'fa-weibo',
					'fa-renren'
				);
			
			
			

			$output .= '<div class="control-group">
			<label class="control-label">'.$attr['title'].'</label>

			<div class="controls"><select class="shortcode-input data-icon-select" data-attrname="'.$name.'">';

			foreach( $fontawesome_icons as $icon ){
				$output .= '<option data-icon="'. $icon .'" value="'.$icon.'">'. str_replace('icon-', '', $icon) .'</option>';
			}
			$output .= '</select></div></div>';

			break;

			//Textarea
			case 'textarea':

			$output .= '<div class="control-group">
			<label class="control-label">'.$attr['title'].'</label>
			<div class="controls"><textarea class="shortcode-input" data-attrname="'.$name.'" data-content="'.$attr['content'].'" placeholder="'. $attr['placeholder'] .'">'.$attr['value'].'</textarea></div></div>';

			break;

			//Text
			case 'text':
			default:

			$output .= '<div class="control-group">
			<label class="control-label">'.$attr['title'].'</label>
			<div class="controls"><input class="shortcode-input shortcode-'.$name.'" type="text" data-attrname="'.$name.'" data-content="'.$attr['content'].'" value="'.$attr['value'].'" placeholder="'. $attr['placeholder'] .'" /></div></div>';

			break;
		}

		return $output;
	}

}

