<?php
defined('_JEXEC') or die;
JHTML::_('behavior.formvalidation');
JHtml::_('jquery.ui');
?>

<script type="text/javascript">
jQuery(document).ready(function($) {
    function validate_insured(device, insured) {
      if (insured != '' && device != '') {
        var sum = parseInt(insured);
        switch (device) {
        case '1': //laptop
          if (sum < 0) {
            alert('Please enter a Sum Insured greater than $0.00');
          } else if (sum > 5000) {
            alert('Sorry, we are unable to insure devices that are valued at more than $5000.00');
            $('#quote_insured').val(5000);
          }
          break;
        case '3': //tablet
          if (sum < 0) {
            alert('Please enter a Sum Insured greater than $0.00');
          } else if (sum > 5000) {
            alert('Sorry, we are unable to insure devices that are valued at more than $5000.00');
            $('#quote_insured').val(5000);
          }
          break;
        }
      }
    }
    $('#quote_device').change(function () {
        var device = $(this).val();
        var insured = $('#quote_insured').val();
        $('#quote-make-field').hide();
        $('.quote-make-group').hide();
        $('#quote_make').prop('selectedIndex', 0);
        if (device != '') {
          if ($('#quote-make-group-' + device + ' option').length > 0) {
            $('#quote-make-field').show();
            $('#quote-make-group-' + device).show();
          }
        }
        validate_insured(device, insured);
    });
    $("#quote_insured").blur(function() {
        var device = $('#quote_device').val();
        var insured = $(this).val();
        validate_insured(device, insured);
    });
    $('#front-page-quote-form #submit-button').click(function(e) {
      e.preventDefault();
      $('#submit-button').attr('disabled', 'disabled');
      var option   = $('#front-page-quote-form input[name="option"]').val();
      var view     = $('#front-page-quote-form input[name="view"]').val();
      var postcode = $('#quote_postcode').val();
      var device   = $('#quote_device').val();
      var make     = $('#quote_make').val();
      var insured  = $('#quote_insured').val();
      var promo    = $('#quote_promo').val();
      $.ajax({
          type: "POST",
          url: "index.php?option=com_priceleafs&task=quote.saveprequote",
          data: { postcode: postcode, device: device, make: make, insured: insured, promo: promo },
          success: function (result) {
            $('#submit-button').removeAttr('disabled');
            //var link = "index.php?option=" + option + "&view=" + view + "&p=" + postcode + "&d=" + device + "&m=" + make + "&i=" + insured;
            if (result.error) {
              alert(result.message);
            } else {
              //goog_report_conversion("<?php print JURI::base(); ?>" + link);
              $('#front-page-quote-form').submit();
              location.href = link;
            }
          }
      });
    });
});
</script>

<div>
<form id="front-page-quote-form" class="form-validate get-quote" method="post" action="index.php?option=com_priceleafs&view=priceleafs" role="form">
  <input type="hidden" name="option" value="com_priceleafs" />
  <input type="hidden" name="view" value="priceleafs" />
  <div class="frm-get-quote-home row">

    <div class="col-md-15 col-xs-3">
      <label for="quote_postcode"><?php print $postcode_label; ?></label>
      <div class="ibr-tooltip">?
        <div class="ibr-tooltiptext"><?php print $postcode_tooltip; ?></div>
      </div>
      <input type="number" name="p" id="quote_postcode" class="required validate-numeric form-control" value="<?php print $q_postcode; ?>" maxlength="255" />
    </div>

    <div class="col-md-15 col-xs-3">
      <div id="quote-device-field" class="quote-device-wrapper">
        <label for="quote_device"><?php print $device_label; ?></label>
        <div class="ibr-tooltip">?
          <div class="ibr-tooltiptext"><?php print $device_tooltip; ?></div>
        </div>
        <select name="d" id="quote_device" class="required validate-select form-control">
          <option value=""></option>
          <?php
          foreach($device_types as $device) {
            $selected = '';
            if ($q_device == $device->id) {
              $selected = 'selected="selected"';
            }
          ?>
          <option value="<?php echo $device->id; ?>" <?php echo $selected; ?>><?php echo $device->name; ?></option>
          <?php } ?>
        </select>
      </div>
      <br />
      <div id="quote-make-field" class="quote-device-wrapper" style="display: <?php print !empty($q_make) ? 'block' : 'none'; ?>;">
        <label for="quote_make"><?php print $make_label; ?></label>
        <div class="ibr-tooltip">?
          <div class="ibr-tooltiptext"><?php print $make_tooltip; ?></div>
        </div>
        <select name="m" id="quote_make" class="validate-select form-control">
          <option value=""></option>
          <?php
          foreach($device_types as $device) {
            if (!empty($device->make)) {
          ?>
          <optgroup label="<?php print $device->name; ?>" id="quote-make-group-<?php print $device->id; ?>" class="quote-make-group">
          <?php
              foreach ($device->make as $make) {
              $selected = '';
              if ($q_make == $make) {
                $selected = 'selected="selected"';
              }
          ?>
          <option value="<?php echo $make; ?>" <?php echo $selected; ?>><?php echo $make; ?></option>
          <?php } ?>
          </optgroup>
          <?php } ?>
          <?php } ?>
        </select>
      </div>
    </div>

    <div class="col-md-15 col-xs-3">
      <label for="quote_insured"><?php print $suminsured_label; ?></label>
      <div class="ibr-tooltip">?
        <div class="ibr-tooltiptext"><?php print $suminsured_tooltip; ?></div>
      </div>
      <input type="number" name="i" id="quote_insured" class="required validate-numeric form-control" value="<?php print $q_insured; ?>" maxlength="255" />
    </div>

    <div class="col-md-15 col-xs-3">
      <label for="quote_promo"><?php print $promocode_label; ?></label>
      <div class="ibr-tooltip">?
        <div class="ibr-tooltiptext"><?php print $promocode_tooltip; ?></div>
      </div>
      <input type="text" name="c" id="quote_promo" class="form-control" value="<?php print $q_promocode; ?>" maxlength="255" />
    </div>

  	<div class="col-md-15 col-xs-3 text-sm-center">
      <button type="button" id="submit-button" class="sppb-btn sppb-btn-default widetop">Click for Quote <i class="fa fa-angle-double-right"></i></button>
  	</div>
  </div>

</form>
</div>

