<?php
defined('_JEXEC') or die;
JHTML::_('behavior.formvalidation');
$q_state = JRequest::getVar('s', '');
$q_device = JRequest::getVar('d', 0);
$q_insured = JRequest::getVar('i', '');
if ($q_insured !== '') {
  $q_insured = floatval($q_insured);
}

$state_label = $params->get('state_label', 'Where do you live?');
$device_label = $params->get('device_label', 'Type of device');
$suminsured_label = $params->get('suminsured_label', 'Sum insured');
?>
<script>
jQuery(document).ready(function($) {
    function validate_insured(device, insured) {
      if (insured != '' && device != '') {
        var sum = parseInt(insured);
        switch (device) {
        case '1': //laptop
          if (sum < 0) {
            alert('Please enter a Sum Insured greater than $0.00');
          } else if (sum > 5000) {
            alert('Sorry, we are unable to insure devices that are valued at more than $5000.00');
            $('#quote_insured').val(5000);
          }
          break;
        case '3': //tablet
          if (sum < 0) {
            alert('Please enter a Sum Insured greater than $0.00');
          } else if (sum > 5000) {
            alert('Sorry, we are unable to insure devices that are valued at more than $5000.00');
            $('#quote_insured').val(5000);
          }
          break;
        }
      }
    }
    $('#quote_device').change(function () {
        var device = $(this).val();
        var insured = $('#quote_insured').val();
        validate_insured(device, insured);
    });
    $("#quote_insured").blur(function() {
        var device = $('#quote_device').val();
        var insured = $(this).val();
        validate_insured(device, insured);
    });
    $('#front-page-quote-form').submit(function(e) {
      e.preventDefault();
      var device = $('#quote_device').val();
      var insured = $('#quote_insured').val();
      var state = $('#quote_state').val();
      var option = $('#front-page-quote-form input[name="option"]').val();
      var view = $('#front-page-quote-form input[name="view"]').val();
      $.ajax({
          type: "POST",
          url: "index.php?option=com_priceleafs&task=quote.saveprequote",
          data: { device: device, insured: insured, state: state },
          success: function (result) {
            location.href = "index.php?option=" + option + "&view=" + view + "&s=" + state + "&d=" + device + "&i=" + insured;
          }
      });
    });
});
</script>
<form id="front-page-quote-form" class="form-validate get-quote" method="get" action="index.php" role="form">
  <input type="hidden" name="option" value="com_priceleafs" />
  <input type="hidden" name="view" value="priceleafs" />
  <div class="frm-get-quote">
    <div class="form-group">
      <label for="quote_state"><?php print $state_label; ?></label>
      <select name="s" id="quote_state" class="required validate-select form-control">
        <option value=""></option>
        <?php
        foreach(array(
          'ACT' => 'Australian Capital Territory',
          'NSW' => 'New South Wales',
          'NT' => 'Northen Territory',
          'QLD' => 'Queensland',
          'SA' => 'South Australia',
          'TAS' => 'Tasmania',
          'VIC' => 'Victoria',
          'WA' => 'Western Australia',
        ) as $state_code => $state_name) {
          $selected = '';
          if ($q_state == $state_code) {
            $selected = 'selected="selected"';
          }
        ?>
        <option value="<?php print $state_code; ?>" <?php echo $selected; ?>><?php print $state_name; ?></option>
        <?php } ?>
      </select>
    </div>
    <div class="form-group">
      <label for="quote_device"><?php print $device_label; ?></label>
      <select name="d" id="quote_device" class="required validate-select form-control">
        <option value=""></option>
        <?php
        foreach($device_types as $device) {
          $selected = '';
          if ($q_device == $device->id) {
            $selected = 'selected="selected"';
          }
        ?>
        <option value="<?php echo $device->id?>" <?php echo $selected; ?>><?php echo $device->name?></option>
        <?php } ?>
      </select>
    </div>
    <div class="form-group">
      <label for="quote_insured"><?php print $suminsured_label; ?></label>
      <input type="text" name="i" id="quote_insured" class="required validate-numeric form-control" value="<?php print $q_insured; ?>" maxlength="255" />
    </div>
  </div>
  <input id="submit-button" type="submit" value="Submit" class="btn-next"/>
</form>
