<?php
defined('_JEXEC') or die;

ini_set('error_reporting', E_ALL ^ E_DEPRECATED);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
require_once dirname(__FILE__).'/dBug.php';

# --- MPGS NEW PAYMENT SETTINGS (2023-07-27) ----------------------------------
define('MPGS_NEW_PAYMENT_URL', 'https://tyro.gateway.mastercard.com/api/rest');
define('MPGS_NEW_PAYMENT_VER', 73);
define('MPGS_NEW_CURL_DEBUG', false);
define('MPGS_NEW_MERCHANT_ID', 'TYRLAPTOPTAB');
define('MPGS_NEW_API_USERNAME', 'merchant.' . MPGS_NEW_MERCHANT_ID);
define('MPGS_NEW_API_PASSWORD', '7833eaa0baf3eefc18aaf75174d92db2');
define('MPGS_NEW_PRICE_OVERRIDE', 0); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

# --- DEPRECATED SETTINGS (NEW PAYMENT METHOD AVAILABLE) ----------------------
# Payment merchant settings for new direct payment method.
define('MIGS_NEW_PAYMENT_URL', 'https://bendigo.ap.gateway.mastercard.com/api/rest');
define('MIGS_NEW_PAYMENT_VER', 34);
define('MIGS_NEW_CURL_DEBUG', false);
define('MIGS_NEW_MERCHANT_ID', 'BBL2182632');
define('MIGS_NEW_API_USERNAME', 'merchant.' . MIGS_NEW_MERCHANT_ID);
define('MIGS_NEW_API_PASSWORD', '92ebf06d1248a2f5d0a206a0d4b3bf42');
define('MIGS_NEW_PRICE_OVERRIDE', 0); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

# --- DEPRECATED SETTINGS (NEW PAYMENT METHOD AVAILABLE) ----------------------
# Payment merchant settings.
define('MIGS_SECURE_SECRET', '9EED76A15B61B69CC33A94C22294C58F');
define('MIGS_ACCESS_CODE', 'C32BF453');
define('MIGS_MERCHANT_ID', 'TESTBBL9576596');
#define('MIGS_PAYMENT_URL', 'https://migs.mastercard.com.au/vpcpay'); // Live payment.
define('MIGS_PAYMENT_URL', 'https://migs-mtf.mastercard.com.au/vpcpay'); // Test payment.
define('MIGS_PRICE_OVERRIDE', 59); // Set it back to 0 to disable price override.
# -----------------------------------------------------------------------------

define('IBROKER_POLICY_RECIPIENT', 'info@ltis.com.au');
define('IBROKER_DEFAULT_EXCESS', 100);
define('IBROKER_GST', 10);

define('IBROKER_REFERRAL_CODE_KEY', 'ref');
define('IBROKER_QUOTE_FORM_MODULE_POSITION', 'associate-quote');

class IO
{
  public static function getDevices() {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->select('id')->from($db->quoteName('#__ibroker_formula'))->where('`state` = 1');
    $db->setQuery($query);

    $results = $db->loadObjectList();
    $devices = array();
    foreach ($results as $result) {
      $devices[$result->id] = self::getDevice($result->id);
    }

    return $devices;
  }

  public static function getDevice($id) {
    $result = self::sqlSelect('#__ibroker_formula', array(
      'column' => 'id',
      'operator' => '=',
      'value' => intval($id),
      ));

    // expand parameters
    $result->parameter = parse_ini_string(@$result->parameter, true);
    foreach ($result->parameter as $key => $value) {
      $values = explode(',', $value);
      foreach ($values as $detail_key => $detail_value) {
        $detail_values = explode('|', $detail_value);
        if (count($detail_values) == 1) {
          $values[$detail_key] = $detail_values[0];
        } else {
          $values[$detail_key] = $detail_values;
        }
      }
      $result->parameter[$key] = $values;
    }

    return $result;
  }

  public static function getQuote($id, $parameters = array()) {
    $device = self::getDevice($id);
    $available = array();

    $associate = 0;

    extract($parameters);

    if (!empty($device->parameter)) {
      $available['parameter'] = $device->parameter;
    }

    $sum_insured = floatval($sum_insured);

    if (!empty($device->parameter['min_insured_threshold'])) {
      $min_insured_threshold = floatval($device->parameter['min_insured_threshold'][0]);
    }

    if (!empty($device->parameter['min_insured'])) {
      $min_insured = floatval($device->parameter['min_insured'][0]);
      if (!empty($min_insured_threshold) && $sum_insured <= $min_insured_threshold) {
      } else if ($sum_insured < $min_insured) {
        $sum_insured = $min_insured;
      }
    }

    if (!empty($device->parameter['max_insured_threshold'])) {
      $max_insured_threshold = floatval($device->parameter['max_insured_threshold'][0]);
    }

    if (!empty($device->parameter['max_insured'])) {
      $max_insured = floatval($device->parameter['max_insured'][0]);
      if (!empty($max_insured_threshold) && $sum_insured >= $max_insured_threshold) {
      } else if ($sum_insured > $max_insured) {
        $sum_insured = $max_insured;
      }
    }

    if (empty($device->parameter['excess'])) {
      $device->parameter['excess'] = array(0);
    } else {
      if (!empty($device->parameter['excess_rule'])) {
        foreach ($device->parameter['excess_rule'] as $excess_rules) {
          $excess_values = explode(';', $excess_rules[0]);
          $excess_rule = $excess_rules[1];
          $excess_check = 'return ('.$excess_rule.') ? true : false;';
          if (eval($excess_check) === true) {
            $device->parameter['excess'] = $excess_values;
          }
        }
      }
    }

    if (!empty($postcode)) {
      $postcode_data = IO::getPostcodeData($postcode);
      if (!empty($postcode_data['state'])) {
        $state   = $postcode_data['state'];
        $service = $postcode_data['service'];
      }
    }

    $onsite_cover = false;
    if (!empty($make) && !empty($device->parameter['make']) && !empty($device->parameter['coverable'])) {
      if (in_array($make, $device->parameter['make']) && in_array($make, $device->parameter['coverable'])) {
        if (!empty($onsite) && !empty($service) && $service == 'onsite') {
          $onsite_cover = true;
        }
      }
    }

    $referrer = self::isUserAssociate();
    if (empty($referrer)) {
      $session = JFactory::getSession();
      $referrer = $session->get('ibroker_referrer');
    }

    $associate = false;
    $overrides = array();
    if (!empty($referrer)) {
      $db = JFactory::getDbo();

      // associate flag
      $query = $db->getQuery(true);
      $query->select('*')->from($db->quoteName('#__ibroker_referralcode'));
      $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_field_name').' = '."'associateFlag'");
      $db->setQuery($query);
      $results = $db->loadObjectList();
      foreach ($results as $vresult) {
        if (!empty($vresult->domain_field_value)) {
          $associate = true;
          break;
        }
      }

      // formula overrides
      $query = $db->getQuery(true);
      $query->select('*')->from($db->quoteName('#__ibroker_formulaoverride'));
      $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_value_device').' = '.intval($id));
      $db->setQuery($query);
      $results = $db->loadObjectList();
      foreach ($results as $vresult) {
        if (!empty($vresult->domain_value_key) && !empty($vresult->domain_value_formula)) {
          $overrides[$vresult->domain_value_key] = $vresult->domain_value_formula;
        }
      }
    }

    if (!empty($promo)) {
      $promo_discount = self::getPromoByCode($promo);
    }

    if (!empty($device->parameter['period']) && !empty($device->parameter['excess'])) {
      foreach ($device->parameter['excess'] as $excess) {
        foreach ($device->parameter['period'] as $period) {
          $base_premium = !empty($overrides['base_premium']) ? eval($overrides['base_premium']) : eval($device->fml_base_premium);
          $base_premium = self::fixRounding($base_premium);

          $discount = $discount_gst = 0;
          $discount_value = '';
          if (!empty($promo_discount) && !empty($promo_discount['value']) && !empty($promo_discount['type'])) {
            if ($promo_discount['type'] == 'fixed') {
              $discount = $promo_discount['value'];
              $discount_value = '$'.self::fixRounding($discount);
            } else if ($promo_discount['type'] == 'percentage') {
              $discount = $base_premium * floatval($promo_discount['value']) / 100;
              $discount_value = self::fixRounding($promo_discount['value']).'%';
            }
            $discount_gst = ($discount * IBROKER_GST) / 100;
            $discount = self::fixRounding($discount);
            $discount_gst = self::fixRounding($discount_gst);
          }

          $fire_services_levy = !empty($overrides['fire_services_levy']) ? eval($overrides['fire_services_levy']) : eval($device->fml_fire_services_levy);
          $fire_services_levy = self::fixRounding($fire_services_levy);

          $marine_gst = !empty($overrides['marine_gst']) ? eval($overrides['marine_gst']) : eval($device->fml_marine_gst);
          $marine_gst = self::fixRounding($marine_gst);

          $static_gst = !empty($overrides['static_gst']) ? eval($overrides['static_gst']) : eval($device->fml_static_gst);
          $static_gst = self::fixRounding($static_gst);

          $total_gst = !empty($overrides['total_gst']) ? eval($overrides['total_gst']) : eval($device->fml_total_gst);
          $total_gst = self::fixRounding($total_gst);

          $stamp_duty = !empty($overrides['stamp_duty']) ? eval($overrides['stamp_duty']) : eval($device->fml_stamp_duty);
          $stamp_duty = self::fixRounding($stamp_duty);

          $underwriter_levy = !empty($overrides['underwriter_levy']) ? eval($overrides['underwriter_levy']) : eval($device->fml_underwriter_levy);
          $underwriter_levy = self::fixRounding($underwriter_levy);

          $underwriter_levy_gst = !empty($overrides['underwriter_levy_gst']) ? eval($overrides['underwriter_levy_gst']) : eval($device->fml_underwriter_levy_gst);
          $underwriter_levy_gst = self::fixRounding($underwriter_levy_gst);

          $broker_fee = !empty($overrides['broker_fee']) ? eval($overrides['broker_fee']) : eval($device->fml_broker_fee);
          $broker_fee = self::fixRounding($broker_fee);

          $broker_fee_gst = !empty($overrides['broker_fee_gst']) ? eval($overrides['broker_fee_gst']) : eval($device->fml_broker_fee_gst);
          $broker_fee_gst = self::fixRounding($broker_fee_gst);

          $additional_cover = !empty($overrides['additional_cover']) ? eval($overrides['additional_cover']) : eval($device->fml_additional_cover);
          $additional_cover = self::fixRounding($additional_cover);

          $additional_cover_gst = !empty($overrides['additional_cover_gst']) ? eval($overrides['additional_cover_gst']) : eval($device->fml_additional_cover_gst);
          $additional_cover_gst = self::fixRounding($additional_cover_gst);

          $premium_payable_nodiscount = 0;
          if (!empty($discount)) {
            $premium_payable = !empty($overrides['premium_payable']) ? eval($overrides['premium_payable']) : eval($device->fml_premium_payable);
            $premium_payable_nodiscount = $premium_payable;
            $premium_payable = self::fixRounding($premium_payable - ($discount + $discount_gst));
            $premium_payable_nodiscount = self::fixRounding($premium_payable_nodiscount);
          } else {
            $premium_payable = !empty($overrides['premium_payable']) ? eval($overrides['premium_payable']) : eval($device->fml_premium_payable);
            $premium_payable = self::fixRounding($premium_payable);
          }

          $associate_commission = !empty($overrides['associate_commission']) ? eval($overrides['associate_commission']) : eval($device->fml_associate_commission);
          $associate_commission = self::fixRounding($associate_commission);

          $associate_commission_gst = !empty($overrides['associate_commission_gst']) ? eval($overrides['associate_commission_gst']) : eval($device->fml_associate_commission_gst);
          $associate_commission_gst = self::fixRounding($associate_commission_gst);

          $ibroker_commission = !empty($overrides['ibroker_commission']) ? eval($overrides['ibroker_commission']) : eval($device->fml_ibroker_commission);
          $ibroker_commission = self::fixRounding($ibroker_commission);

          $ibroker_commission_gst = !empty($overrides['ibroker_commission_gst']) ? eval($overrides['ibroker_commission_gst']) : eval($device->fml_ibroker_commission_gst);
          $ibroker_commission_gst = self::fixRounding($ibroker_commission_gst);

          $rch_commission = !empty($overrides['rch_commission']) ? eval($overrides['rch_commission']) : eval($device->fml_rch_commission);
          $rch_commission = self::fixRounding($rch_commission);

          $rch_commission_gst = !empty($overrides['rch_commission_gst']) ? eval($overrides['rch_commission_gst']) : eval($device->fml_rch_commission_gst);
          $rch_commission_gst = self::fixRounding($rch_commission_gst);

          $sell_price = $premium_payable;
          $buy_price = ($sell_price - $associate_commission - $associate_commission_gst) / (110 / 100);
          $buy_price = self::fixRounding($buy_price);

          $available['quote'][$excess][$period] = array(
            'referrer' => !empty($associate) ? $referrer : '',
            'associate' => intval($associate),
            'base_premium' => $base_premium,
            'discount' => $discount,
            'discount_gst' => $discount_gst,
            'discount_value' => $discount_value,
            'fire_services_levy' => $fire_services_levy,
            'marine_gst' => $marine_gst,
            'static_gst' => $static_gst,
            'total_gst' => $total_gst,
            'stamp_duty' => $stamp_duty,
            'underwriter_levy' => $underwriter_levy,
            'underwriter_levy_gst' => $underwriter_levy_gst,
            'broker_fee' => $broker_fee,
            'broker_fee_gst' => $broker_fee_gst,
            'additional_cover' => $additional_cover,
            'additional_cover_gst' => $additional_cover_gst,
            'premium_payable' => $premium_payable,
            'premium_payable_nodiscount' => $premium_payable_nodiscount,
            'associate_commission' => $associate_commission,
            'associate_commission_gst' => $associate_commission_gst,
            'ibroker_commission' => $ibroker_commission,
            'ibroker_commission_gst' => $ibroker_commission_gst,
            'rch_commission' => $rch_commission,
            'rch_commission_gst' => $rch_commission_gst,
            'sell_price' => $sell_price,
            'buy_price' => $buy_price,
            'onsite_cover' => $onsite_cover,
            'promo_code' => $promo,
            );
        }
      }
    }

    //new dbug($available);
    return $available;
  }

  public static function sqlInsert($table, $fields)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $columns = $values = array();
    foreach ($fields as $column => $value) {
      $columns[] = $column;
      $values[] = $db->quote($value);
    }
    $query->insert($db->quoteName($table))
    ->columns($db->quoteName($columns))
    ->values(implode(',', $values));
    $db->setQuery($query);
    $db->query();
    return $db->insertid();
  }

  public static function sqlUpdate($table, $fields, $conditions)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $ufields = $uconditions = array();
    foreach ($fields as $column => $value) {
      $ufields[] = $db->quoteName($column).' = '.$db->quote($value);
    }
    foreach ($conditions as $column => $value) {
      $uconditions[] = $db->quoteName($column).' = '.$db->quote($value);
    }
    $query->update($db->quoteName($table))->set($ufields)->where($uconditions);
    $db->setQuery($query);
    return $db->execute();
  }

  public static function sqlSelect($table, $condition)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->select('*')->from($db->quoteName($table));
    $query->where($db->quoteName($condition['column']).' '.$condition['operator'].' '.$db->quote($condition['value']));
    $db->setQuery($query);

    $result = $db->loadObjectList();
    if (count($result) > 0) {
      return $result[0];
    } else {
      return new stdClass;
    }
  }

  public static function fixRounding($number) {
    $string = (string) $number;
    $parts = explode('.', $string.'.');
    $int = (int) $parts[0];
    $frac = substr($parts[1], 0, 2);
    if (empty($frac)) {
      $number = (float) $int;
    } else {
      $number = (float) $int.'.'.$frac;
    }
    $number = money_format($number, 2);
    return $number;
  }

  public static function checkAndStoreReferrer() {
    if (!empty($_GET[IBROKER_REFERRAL_CODE_KEY]) && ctype_alnum($_GET[IBROKER_REFERRAL_CODE_KEY])) {
      $referrer = trim($_GET[IBROKER_REFERRAL_CODE_KEY]);
      register_shutdown_function('io_set_referrer_code', $referrer);
    }
  }

  public static function isUserAssociate() {
    $user = JFactory::getUser();
    $userId = $user->get('id');
    if (!empty($userId)) {
      $mapusercode = self::sqlSelect('#__ibroker_mapusercode', array(
        'column' => 'associate_user',
        'operator' => '=',
        'value' => $userId,
        ));
      if (!empty($mapusercode->referral_code)) {
        return $mapusercode->referral_code;
      }
    }
    return false;
  }

  public static function getPostcodeData($postcode) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('`suburb`, `austate`, `service`')->from('#__ibroker_postcode');
    $query->where('`postcode` = '.intval($postcode));
    $db->setQuery($query);
    $results = $db->loadObjectList();
    $return = array();
    if (!empty($results)) {
      foreach ($results as $result) {
        $return['suburb'][] = $result->suburb;
        $return['state'] = $result->austate;
        $return['service'] = $result->service;
      }
    }
    return $return;
  }

  public static function submitPayment($refnum) {
    $return = array();

    $order = self::sqlSelect('#__priceleaf_session', array(
      'column' => 'refnumber',
      'operator' => '=',
      'value' => $refnum,
      ));
    if (empty($order->details) || empty($order->id)) {
      return array('error' => 'Invalid reference data.');
    }
    $details = explode("{{}}", $order->details);
    if (empty($details) || empty($details[13]) || empty($details[8]) || empty($details[14]) || empty($details[9]) || empty($details[15])) {
      return array('error' => 'Invalid reference details.');
    }
    $quote = self::getQuote($details[13], array('postcode' => $details[8], 'sum_insured' => floatval($details[14]), 'make' => $details[9], 'onsite' => intval(@$details[21]), 'promo' => $details[16]));
    list($numyear, $excess) = explode(',', $details[15]);
    $price = 0;
    if (!empty($quote['quote'][$excess][$numyear]['premium_payable'])) {
      $price = $quote['quote'][$excess][$numyear]['premium_payable'];
    }
    if (empty($price)) {
      return array('error' => 'Unable to determine policy price.');
    }

    if (!empty(MPGS_NEW_PRICE_OVERRIDE)) {
      $price = MPGS_NEW_PRICE_OVERRIDE;
    }

    $data = $_POST;
    $data['apiOperation'] = 'PAY';
    $data['sourceOfFunds']['type'] = 'CARD';
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace(' ', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace('-', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['order']['amount'] = $price;
    $data['order']['currency'] = 'AUD';
    $data['order']['reference'] = $refnum;
    $token = JSession::getFormToken();
    unset($data[$token]);
    $request = json_encode($data);
    $return['data'] = $data;

    $payment_url  = MPGS_NEW_PAYMENT_URL;
    $payment_url .= '/version/' . MPGS_NEW_PAYMENT_VER;
    $payment_url .= '/merchant/' . MPGS_NEW_MERCHANT_ID;
    $payment_url .= '/order/' . $order->id;
    $payment_url .= '/transaction/' . $refnum;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Length: ' . strlen($request)));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: Application/json; charset=UTF-8'));
    curl_setopt($ch, CURLOPT_URL, $payment_url);
    curl_setopt($ch, CURLOPT_USERPWD, MPGS_NEW_API_USERNAME . ':' . MPGS_NEW_API_PASSWORD);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    if (MPGS_NEW_CURL_DEBUG) {
      curl_setopt($ch, CURLOPT_HEADER, TRUE);
      curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
    }

    $return['response'] = curl_exec($ch);
    if (!empty($return['response'])) {
      $return['parsed_response'] = json_decode($return['response'], true);
    }
    if (curl_error($ch)) {
      $return['error'] = 'CURL(' . curl_errno($ch) . ') - ' . curl_error($ch);
    }
    if (MPGS_NEW_CURL_DEBUG) {
      $info = curl_getinfo($ch);
      if (array_key_exists('request_header', $info)) {
        $return['header'] = $info['request_header'];
      }
    }
    curl_close($ch);

    if (!empty($return['error'])) {
      return $return;
    }

    $response = json_decode($return['response'], true);
    if (empty($response)) {
      $return['error'] = 'Failure when decoding payment response.';
      return $return;
    }

    $return['response'] = $response;
    if (array_key_exists('result', $response)) {
      $return['status'] = $response['result'];
    }

    return $return;
  }

  public static function submitPaymentDeprecated($refnum) {
    $return = array();

    $order = self::sqlSelect('#__priceleaf_session', array(
      'column' => 'refnumber',
      'operator' => '=',
      'value' => $refnum,
      ));
    if (empty($order->details) || empty($order->id)) {
      return array('error' => 'Invalid reference data.');
    }
    $details = explode("{{}}", $order->details);
    if (empty($details) || empty($details[13]) || empty($details[8]) || empty($details[14]) || empty($details[9]) || empty($details[15])) {
      return array('error' => 'Invalid reference details.');
    }
    $quote = self::getQuote($details[13], array('postcode' => $details[8], 'sum_insured' => floatval($details[14]), 'make' => $details[9], 'onsite' => intval(@$details[21]), 'promo' => $details[16]));
    list($numyear, $excess) = explode(',', $details[15]);
    $price = 0;
    if (!empty($quote['quote'][$excess][$numyear]['premium_payable'])) {
      $price = $quote['quote'][$excess][$numyear]['premium_payable'];
    }
    if (empty($price)) {
      return array('error' => 'Unable to determine policy price.');
    }

    if (!empty(MIGS_NEW_PRICE_OVERRIDE)) {
      $price = MIGS_NEW_PRICE_OVERRIDE;
    }

    $data = $_POST;
    $data['apiOperation'] = 'PAY';
    $data['sourceOfFunds']['type'] = 'CARD';
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace(' ', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['sourceOfFunds']['provided']['card']['number'] = str_replace('-', '', $data['sourceOfFunds']['provided']['card']['number']);
    $data['order']['amount'] = $price;
    $data['order']['currency'] = 'AUD';
    $data['order']['reference'] = $refnum;
    $token = JSession::getFormToken();
    unset($data[$token]);
    $request = json_encode($data);
    $return['data'] = $data;

    $payment_url  = MIGS_NEW_PAYMENT_URL;
    $payment_url .= '/version/' . MIGS_NEW_PAYMENT_VER;
    $payment_url .= '/merchant/' . MIGS_NEW_MERCHANT_ID;
    $payment_url .= '/order/' . $order->id;
    $payment_url .= '/transaction/' . $refnum;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Length: ' . strlen($request)));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: Application/json; charset=UTF-8'));
    curl_setopt($ch, CURLOPT_URL, $payment_url);
    curl_setopt($ch, CURLOPT_USERPWD, MIGS_NEW_API_USERNAME . ':' . MIGS_NEW_API_PASSWORD);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    if (MIGS_NEW_CURL_DEBUG) {
      curl_setopt($ch, CURLOPT_HEADER, TRUE);
      curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
    }

    $return['response'] = curl_exec($ch);
    if (curl_error($ch)) {
      $return['error'] = 'CURL(' . curl_errno($ch) . ') - ' . curl_error($ch);
    }
    if (MIGS_NEW_CURL_DEBUG) {
      $info = curl_getinfo($ch);
      if (array_key_exists('request_header', $info)) {
        $return['header'] = $info['request_header'];
      }
    }
    curl_close($ch);

    if (!empty($return['error'])) {
      return $return;
    }

    $response = json_decode($return['response'], true);
    if (empty($response)) {
      $return['error'] = 'Failure when decoding payment response.';
      return $return;
    }

    $return['response'] = $response;
    if (array_key_exists('result', $response)) {
      $return['status'] = $response['result'];
    }

    return $return;
  }

  public static function getPromoByCode($promoCode) {
    $return = array();
    if (!ctype_alnum($promoCode)) {
      return $return;
    }
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('`promo_code`, `promo_discount`, `promo_parameters`')->from('#__ibroker_discount');
    $query->where('`promo_code` = '.$db->quote($promoCode).' AND `state` = 1');
    $db->setQuery($query);
    $results = $db->loadObjectList();
    if (!empty($results)) {
      foreach ($results as $result) {
        $return['code'] = $result->promo_code;
        if (preg_match("/[0-9]+%/", $result->promo_discount, $matches)) {
          $return['value'] = floatval($matches[0]);
          $return['type'] = 'percentage';
        } else {
          $return['value'] = floatval($result->promo_discount);
          $return['type'] = 'fixed';
        }
        $return['params'] = $result->promo_parameters;
      }
    }
    return $return;
  }
}

IO::checkAndStoreReferrer();
function io_set_referrer_code($referrer) {
  $session = JFactory::getSession();
  $session->set('ibroker_referrer', $referrer);
}
