<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

class PriceleafsViewAssociate extends JViewLegacy
{
  function display($tpl = null)
  {
    // check if user is associate
    if (!($referral_code = IO::isUserAssociate())) {
      $app = JFactory::getApplication();
      $message = 'Restricted access to associate members.';
      $app->redirect(JUri::base(), $message, 'error');
      die();
    }

    // load quote form module
    $document = JFactory::getDocument();
    $renderer = $document->loadRenderer('modules');
    $quote_form = $renderer->render(IBROKER_QUOTE_FORM_MODULE_POSITION, array('style' => 'xhtml'), null);
    if ($quote_form) {
      $quote_form = str_replace(
        'type="hidden" name="view" value="priceleafs"',
        'type="hidden" name="view" value="associate"',
        $quote_form);
      $this->assignRef('quote_form', $quote_form);
    }

    // when form is submitted
    $postcode = JRequest::getVar('p', '');
    $device = JRequest::getVar('d', '');
    $make = JRequest::getVar('m', '');
    $insured = JRequest::getVar('i', 0);
    $onsite = JRequest::getVar('o', 0);
    $promo = JRequest::getVar('c', '');

    if (!empty($postcode) && !empty($device) && !empty($insured)) {
      $rows = IO::getQuote($device, array('postcode' => $postcode, 'sum_insured' => $insured, 'make' => $make, 'onsite' => $onsite, 'promo' => $promo));

      $device = IO::getDevice($device);
      $this->assignRef('device_type', $device->device);

      if (!empty($rows['quote'])) {

        $quote_content = '<p>&nbsp;</p><div class="table-responsive-associate"><table class="table table-striped table-bordered">';
        $quote_content .= '<thead><tr>';
        $quote_content .= '<th class="rightb0 text-center">Excess</th>';
        $quote_content .= '<th class="rightb0 text-center">Premium Type</th>';
        if (!empty($rows['parameter']['period'])) {
          foreach ($rows['parameter']['period'] as $period) {
            $quote_content .= '<th class="rightb0 text-center">'.$period.' Year</th>';
          }
        }
        $quote_content .= '</tr></thead>';

        if (!empty($rows['quote'])) {
          $quote_content .= '<tbody>';
          foreach ($rows['quote'] as $excess => $periods) {
            if (!empty($excess)) {
              $quote_content .= '<tr><td class="erightb0 fblue text-center" rowspan="3">$'.number_format($excess, 2).'</td>';
            } else {
              $quote_content .= '<tr><td class="erightb0 fblue text-center" rowspan="3">$'.number_format(IBROKER_DEFAULT_EXCESS, 2).'</td>';
            }
            $first_row = true;
            foreach (array('sell_price' => 'Sell Price', 'buy_price' => 'Buy Price', 'associate_commission' => 'You Earn') as $which_price => $which_price_label) {
              if (!$first_row) {
                $quote_content .= '<tr>';
              }
              $which_gst_label = '(inc. GST)';
              if ($which_price == 'buy_price' || $which_price == 'associate_commission') {
                $which_gst_label = '(ex. GST)';
              }
              $quote_content .= '<td class="erightb0 fblue text-center '.$which_price.'">'.$which_price_label.'<br /><span style="font-size: smaller">'.$which_gst_label.'</span></td>';
              foreach ($periods as $period => $data) {
                $quote_content .= '<td class="erightb0 fblue text-center '.$which_price.'">$'.number_format($data[$which_price], 2).'</td>';
              }
              $quote_content .= '</tr>';
              $first_row = false;
            }
          }
          $quote_content .= '</tbody>';
        }
        $quote_content .= '</table></div>';
        $this->assignRef('quote_content', $quote_content);

      }
    }

    parent::display($tpl);
  }
}
