<?php
defined('_JEXEC') or die;

class PriceleafsModelQuote extends JModelLegacy
{

	protected $_context = 'com_priceleafs.quote';
	
	
	function __construct()
	{
		parent::__construct();
	}	
	
  function saveprequote($data){
    $device = $data['device'];
    $insured = floatval($data['insured']);
    $state = $data['state'];

    $referrer = IO::isUserAssociate();
    if (empty($referrer)) {
      $session = JFactory::getSession();
      $referrer = $session->get('ibroker_referrer');
    }

    $associate = false;
    $overrides = array();
    if (!empty($referrer)) {
      $db = JFactory::getDbo();

      // associate flag
      $query = $db->getQuery(true);
      $query->select('*')->from($db->quoteName('#__ibroker_referralcode'));
      $query->where($db->quoteName('referral_code').' = '.$db->quote($referrer).' AND '.$db->quoteName('domain_field_name').' = '."'associateFlag'");
      $db->setQuery($query);
      $results = $db->loadObjectList();
      foreach ($results as $vresult) {
        if (!empty($vresult->domain_field_value)) {
          $associate = true;
          break;
        }
      }
    }

    $fields = array(
      'associate' => (int) $associate,
      'referrer' => !empty($associate) ? $referrer : '',
      'create_date' => date('Y-m-d'),
      'deviceType' => $device,
      'sum_insured' => $insured,
      'state' => $state,
    );

    IO::sqlInsert('#__priceleaf_quotes', $fields);
  }
	
  function savequote($data){
    $type_id = $data['deviceType'];
    $period = intval($data['numyear']);
    $excess = floatval($data['excess']);
    $sum_insured = floatval($data['sum_insured']);
    $state = $data['quote_state'];

    if (empty($data['email']) && !empty($data['email3'])) {
      $data['email'] = $data['email3'];
    }

    $rows = IO::getQuote($type_id, array('state' => $state, 'sum_insured' => $sum_insured));
    $refnumber = $data['deviceType'].uniqid();

    $db = JFactory::getDBO();
    $query = "SELECT content FROM #__priceleaf_mailtemp WHERE id = 1";
    $db->setQuery($query);
    $mailcontent = $db->loadResult();

    if (!empty($rows['quote'][$excess][$period])) {
      $quote = $rows['quote'][$excess][$period];

      $fields = array(
        'associate' => (int) $associate,
        'referrer' => $quote['referrer'],
        'create_date' => date('Y-m-d'),
        'institution' => $data['institution'],
        'name' => $data['txtName'],
        'email' => $data['email'],
        'deviceType' => $type_id,
        'sum_insured' => $sum_insured,
        'promo_code' => $data['promo_code'],
        'excess' => $excess,
        'numyear' => $period,
        'premium' => $quote['base_premium'],
        'FSL' => $quote['fire_services_levy'],
        'stampDuty' => $quote['stamp_duty'],
        'UWLevy' => $quote['underwriter_levy'],
        'UWLevyGST' => $quote['underwriter_levy_gst'],
        'brokerFee' => $quote['broker_fee'],
        'brokerFeeGST' => $quote['broker_fee_gst'],
        'IC' => $quote['ibroker_commission'],
        'ICGST' => $quote['ibroker_commission_gst'],
        'AC' => $quote['associate_commission'],
        'GST' => $quote['total_gst'],
        'total' => $quote['premium_payable'],
        'state' => $state,
        'RefNumber' => $refnumber,
      );

      $total = $fields['total'];

      IO::sqlInsert('#__priceleaf_quotes', $fields);

      $mbody = '<table cellpadding="2" border="1" style="padding-top:10px; padding-bottom:5px; color:#3A2060;">';
      $mbody .= '<tr>';
      $mbody .= '<td>Period</td>';
      if ($period > 1){
        $mbody .= '<td>'.$data['numyear'].' Years</td>';
      }else{
        $mbody .= '<td>'.$data['numyear'].' Year</td>';
      }
      $mbody .= '</tr>';
      if($excess > 0){
        $mbody .= '<tr>';
        $mbody .= '<td>Excess</td>';
        $mbody .= '<td>'.$data['excess'].'</td>';
        $mbody .= '</tr>';
      }
      $mbody .= '<tr>';
      $mbody .= '<td>Total</td>';
      $mbody .= '<td><a href="'.JURI::base().'index.php?option=com_priceleafs&view=policy&refnum='.$refnumber.'">'.$total.'</a></td>';
      $mbody .= '</tr>';
      $mbody .= '</table>';
    } else {
      $fields = array(
        'create_date' => date('Y-m-d'),
        'institution' => $data['institution'],
        'name' => $data['txtName'],
        'email' => $data['email'],
        'deviceType' => $type_id,
        'sum_insured' => $sum_insured,
        'promo_code' => $data['promo_code'],
        'excess' => $excess,
        'numyear' => $period,
        'state' => $state,
        'RefNumber' => $refnumber,
      );

      IO::sqlInsert('#__priceleaf_quotes', $fields);

      $mbody = '<div class="table-responsive"><table cellpadding="2" border="1" style="padding-top:10px; padding-bottom:5px; color:#3A2060;">';
      $mbody .= '<thead><tr>';

      if (!empty($rows['parameter']['excess'])) {
        $mbody .= '<th class="rightb0 text-center">Excess</th>';
      }

      if (!empty($rows['parameter']['period'])) {
        foreach ($rows['parameter']['period'] as $period) {
          $mbody .= '<th class="rightb0 text-center">'.$period.' Year</th>';
        }
      }

      $mbody .= '</tr></thead>';

      if (!empty($rows['quote'])) {
        $mbody .= '<tbody>';
        foreach ($rows['quote'] as $excess => $periods) {
          if (!empty($excess)) {
            $mbody .= '<tr><td class="erightb0 fblue text-center">$'.number_format($excess, 2).'</td>';
          }
          foreach ($periods as $period => $pdata) {
            $mbody .= '<td class="erightb0 fblue text-center">$'.number_format($pdata['premium_payable'], 2).'</td>';
          }
          $mbody .= '</tr>';
        }
        $mbody .= '</tbody>';
      }

      $mbody .= '</table></div>';
    }

    $mbody .= '<p>Please refer to the Documents menu option of our web site at <a href="http://www.ltis.com.au">www.ltis.com.au</a> to review our:';
    $mbody .= '<ol>';
    $mbody .= '<li>Policy Wording / PDS</li>';
    $mbody .= '<li>Financial Services Guide</li>';
    $mbody .= '<li>General Advice Wording</li>';
    $mbody .= '<li>Wholesale Broking Agreement</li>';
    $mbody .= '<li>Dispute Resolution Guide</li>';
    if ($type_id == 1 || $type_id == 3) {
      $mbody .= '<li>Countries excluded from World Wide cover</li>';
    }
    $mbody .= '</ol>';
    $mbody .= '</p>';

    $mailbody = str_replace("{table_content}", $mbody, $mailcontent);

    $query = "SELECT device FROM #__ibroker_formula WHERE id = ".intval($type_id);
	  $db->setQuery($query);
	  $item_type = $db->loadResult();

    $geographic_area = 'Worldwide for the entire period of insurance (excludes some countries)';
    if (strtolower($item_type) == 'netbook') {
      $geographic_area = 'Australia Wide';
    }

    $sum_insured_txt = "$ ".$sum_insured.' '; 
    switch (strtolower($item_type)) {
      case 'laptop':
        if ($sum_insured <= 1500) {
          $sum_insured_txt = 'All Laptops valued up to $1,500.00 (ex-GST) per Laptop (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the laptop and accessories)';
        } else {
          $sum_insured_txt .= '(ex-GST) per Laptop (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the laptop and accessories)';
        }
        break;
      case 'tablet':
        if ($sum_insured <= 1250) {
          $sum_insured_txt = 'All Tablets valued up to $1,250.00 (ex-GST) per Tablet (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the tablet and accessories)';
        } else {
          $sum_insured_txt .= '(ex-GST) per Tablet (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the tablet and accessories)';
        }
        break;
      case 'netbook':
        if ($sum_insured <= 650) {
          $sum_insured_txt = 'All Netbooks valued up to $650.00 (ex-GST) per Netbook (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the netbook and accessories)';
        } else {
          $sum_insured_txt = 'All Netbooks valued between $650.00 and $900.00 (ex-GST) per Netbook (The Sum Insured you elect should represent the Ex-GST Recommended Retail Price of the netbook and accessories)';
        }
        break;
    }
      
    $mailbody = str_replace("{item_type}", $item_type, $mailbody);
    $mailbody = str_replace("{ref_number}", $refnumber, $mailbody);
    $mailbody = str_replace("{sum_insured}", $sum_insured_txt, $mailbody);
    $mailbody = str_replace("{geographic_area}", $geographic_area, $mailbody);
    
    $email_subject = JText::_( 'COM_PRICELEAF_QUOTE_MAIL_SUBJECT' );
    $mailer = JFactory::getMailer();
    $config = JFactory::getConfig();
    $sender = array($config->get('config.mailfrom'),  $config->get('config.fromname'));
    $recipient = $data['email'];
    $mailer->addRecipient($data['email']);
    //$mailer->addCC('info@ibroker.net.au');
    $mailer->setSubject($email_subject);
    $mailer->isHTML(true);

    $mailer->setBody($mailbody);

    $send = $mailer->Send();
      
    return $refnumber;
  }	
	
  
  function showQuoteCalculation($type_id, $sumi, $state = null){
	  $db = JFactory::getDBO();
	  $query = "SELECT * FROM #__priceleaf_cat WHERE type_id=".$type_id." AND min_amount<=".$db->quote($sumi)." AND max_amount>=".$db->quote($sumi)." AND state=".$db->quote($state)." ORDER BY excess,numyear ASC";
	  $db->setQuery($query);
	  $rprice = $db->loadObjectList();

    return $rprice;	
  }
	
  function getGST($type_id){
    return IBROKER_GST;
  }
}
?>
