<?php
defined('_JEXEC') or die;

class PriceleafsModelPolicy extends JModelLegacy
{

  protected $_context = 'com_priceleafs.policy';

  function getPriceleaf(){
    $db = JFactory::getDBO();

    $query = 'SELECT * FROM #__ibroker_formula ORDER BY ordering';
    $db->setQuery($query);
    $rows = $db->loadObjectlist();

    foreach ($rows as &$row) {
      $row->name = $row->device;
    }

    return $rows;
  }

  function getExcess(){
    $db = JFactory::getDBO();
    $query = 'SELECT DISTINCT(excess) AS excess, type_id FROM #__priceleaf_cat ORDER BY type_id,excess';
    $db->setQuery($query);
    $rex = $db->loadObjectList();

    return $rex;
  }

  function getRefNumExp($RefNumber){
    $db = JFactory::getDBO();

    $query = "SELECT COUNT(*) FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($RefNumber)." AND DATE_ADD(create_date,INTERVAL 1 MONTH) > CURDATE()";
    $db->setQuery($query);
    $row = $db->loadResult();
    if($row<1){
      return false;
    }else{
      return true;
    }
  }

  function getRefNum($RefNumber){
    $db = JFactory::getDBO();
    $query = "SELECT * FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($RefNumber)." AND DATE_ADD(create_date,INTERVAL 1 MONTH) > CURDATE() LIMIT 1";
    $db->setQuery($query);
    $rex = $db->loadObject();

    return $rex;
  }

  function thequote($RefNumber){
    $db = JFactory::getDBO();
    $query = "SELECT q.*,c.device, 'p' AS flag FROM #__priceleaf_quotes AS q LEFT JOIN #__ibroker_formula AS c ON q.deviceType=c.id WHERE RefNumber=".$db->quote($RefNumber)." LIMIT 1";
    $db->setQuery($query);
    $rex = $db->loadObject();

    return $rex;
  }

  function completeQuote($RefNumber){
    $db = JFactory::getDBO();
    $query = "SELECT sum_insured,deviceType,numyear,excess,state,promo_code FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($RefNumber)." LIMIT 1";
    $db->setQuery($query);
    $rex = $db->loadObject();
    return $rex;
  }

  function getPolicy($RefNumber){
    $db = JFactory::getDBO();
    $query = "SELECT COUNT(*) FROM #__priceleaf_policy WHERE refNumber=".$db->quote($RefNumber);
    $db->setQuery($query);
    $cou = $db->loadResult();
    if($cou>0){
      return false;
    }else{
      return true;
    }
  }

  function getPayType($total,$RefNumber){
    $matches = array ();
    $overrides = array ();
    $btnimg = '';
    $mode = '';
    $additionalFormHtml = null;
    $paypal_email = 'info@earthlinkdesign.com.au';
    $cancel_return = JURI::base().'index.php?option=com_priceleafs&view=policy';
    $notify_url = JURI::base().'index.php?option=com_priceleafs&task=policy.notify&refnum='.$RefNumber;
    $return = JURI::base().'index.php?option=com_priceleafs&view=policy&layout=thanks';

    $article_text = "{instantpaypal}{/instantpaypal}";

    preg_match_all ( '/{instantpaypal}(.*?){\/instantpaypal}/', $article_text, $matches, PREG_PATTERN_ORDER );
    if (count ( $matches [0] )) {
      for($i = 0; $i < count ( $matches [0] ); $i ++) {
        // Reset resources
        $additionalFormHtml = null;
        $mode = null;
        // Init overrides element analysis
        $overridesArray = array();
        $overrides = strlen(trim($matches [1] [$i]) )? explode ( ",", trim($matches [1] [$i] )) : array();
        if(count($overrides)) {
          foreach ($overrides as $overrideParam) {
            $temp = explode ( "=", $overrideParam );
            $overridesArray[$temp[0]] = $temp[1];
          }
        }

        // Init overrides variables with default param fallback
        $action = 'pay';
        $price = $total;
        $productName = 'Policy (Reference Number:'.$RefNumber.')';

        // TYPE DONATE
        if (strtolower ( $action ) == "donate") {
          $action = '_donations';
          $btnimg = 'https://www.paypal.com/en_US/i/btn/btn_donate_SM.gif';
        } else if (preg_match('/cart/i', $action)) { // TYPE CART
          // Setting dell'add mode to cart
          $mode = '<input type="hidden" name="add" value="1" />';

          if (strtolower ( $action ) == "fullcart") {
            $btnimg = 'https://www.paypal.com/en_US/i/btn/btn_cart_SM.gif';
            $btnimgview = 'https://www.paypal.com/en_US/i/btn/btn_viewcart_SM.gif';
          } else if (strtolower ( $action ) == "addtocart") {
            $btnimg = 'https://www.paypal.com/en_US/i/btn/btn_cart_SM.gif';
            $btnimgview = '';
          } else if (strtolower ( $action ) == "showcart") {
            $btnimgview = 'https://www.paypal.com/en_US/i/btn/btn_viewcart_SM.gif';
            $btnimg = '';
          }

          if (strtolower ( $action ) == "fullcart" || strtolower ( $action ) == "showcart") {
            // view button
            $additionalFormHtml = 	'<form style="margin-top: 10px" class="subform " name="instantpaypal" action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
            <input type="hidden" name="business" value="' . $paypal_email . '" />
            <input type="hidden" name="cmd" value="_cart" />
            <input type="hidden" name="display" value="1" />
            <input type="hidden" name="lc" value="AU" />
            <input type="hidden" name="charset" value="utf-8" />
            <input type="image" name="submit" style="border: 0;" src="' . $btnimgview . '" alt="PayPal - The safer, easier way to pay online" />
            </form>';
          }
          // Override cmd paypal
          $action = '_cart';
        } else if (strtolower ( $action ) == "pay") { // TYPE PAY
          $action = '_xclick';
          $btnimg = 'https://www.paypal.com/en_US/i/btn/btn_paynow_SM.gif';
        } else { // DEFAULT TYPE XCLICK
          $action = '_xclick';
          $btnimg = 'https://www.paypal.com/en_US/i/btn/btn_buynow_SM.gif';
        }

        $formHtml = '<form class="" name="instantpaypal" action="https://www.sandbox.paypal.com/cgi-bin/webscr" method="post" target="_self">
        <input type="hidden" name="business" value="' . $paypal_email . '" />
        <input type="hidden" name="cmd" value="' . $action . '" />
        <input type="hidden" name="amount" value="' . $price . '" />
        <input type="hidden" name="item_name" value="' . $productName . '" />' .
        $mode .
        '<input type="hidden" name="currency_code" value="AUD" />
        <input type="hidden" name="notify_url" value="'.$notify_url.'">
        <input type="hidden" name="return" value="'.$return.'">
        <input type="hidden" name="rm" value="2">
        <input type="hidden" name="cancel_return" value="'.$cancel_return.'">
        <input type="hidden" name="lc" value="AU" />
        <input type="hidden" name="charset" value="utf-8" />';


        $formHtml .= '<input type="image" name="submit" style="border: 0;" src="' . $btnimg . '" alt="PayPal - The safer, easier way to pay online" />';

        $formHtml .= '</form>';

        $additionalInfo = null;
        //if($this->params->get('showxtdinfo', 1)) {
        //	$additionalInfo = '<div class=""><span>' . $productName . '</span> | <span>' . $price . ' ' . 'AUD' . '</span></div>';
        //}

        // Final show forms logic
        $finalForms = strtolower ( $originalAction ) != "showcart" ? $formHtml . $additionalInfo . $additionalFormHtml  : $additionalFormHtml;
        // Replace unique per firm instance
        $instance = $matches [1] [$i];
        $article_text = str_replace("{instantpaypal}$instance{/instantpaypal}", $finalForms, $article_text );
      }
    }
    return $article_text;
  }

  function newpolicy($receipt_no, $reference_no = ''){
    $db = JFactory::getDBO();
    
    $temp_policy = IO::sqlSelect('#__priceleaf_policy', array(
        'column' => 'invoice',
        'operator' => '=',
        'value' => $receipt_no,
      ));
    if (!empty($temp_policy->txn_id) && $temp_policy->txn_id == $receipt_no) {
      return true;
    }

    $session = JFactory::getSession();
    $cathrine = $session->get('cathrine');
    if (empty($cathrine) && !empty($reference_no)) {
      $temp_session = IO::sqlSelect('#__priceleaf_session', array(
        'column' => 'refnumber',
        'operator' => '=',
        'value' => $reference_no,
      ));
      if (!empty($temp_session->details)) {
        $cathrine = $temp_session->details;
      }
    }
    if (empty($cathrine)) {
      return false;
    }

    $customs = explode("{{}}",$cathrine);
    if (empty($customs)) {
      return false;
    }

    $infullname   = $customs[0];
    $isurname   = $customs[1];
    $eufullname  = $customs[2];
    $eusurname  = $customs[3];
    $address   = $customs[4];
    $phone   = $customs[5];
    $suburb     = $customs[6];
    $state      = $customs[7];
    $postcode   = $customs[8];
    $make       = $customs[9];
    $txtmodel   = $customs[10];
    $institution  = $customs[11];
    $email        = $customs[12];
    $deviceType   = $customs[13];
    $sum_insured  = floatval($customs[14]);
    $excessyear   = $customs[15];
    $promo_code   = $customs[16];
    $unit         = $customs[17];
    $purchase_date   = $customs[18];
    $serialno     = $customs[19];
    $insured_date     = $customs[20];
    $onsite_cover     = $customs[21];
    if (empty($serialno)) {
      return false;
    }

    $ndate = date("Y-m-d");

    $split_ey = explode(',',$excessyear);
    $excess   = $split_ey[1];
    $numyear  = $split_ey[0];
    $mvalue   = $this->countTotal($excess, $numyear, '', $sum_insured, $deviceType, $postcode, $make, $onsite_cover, $promo_code);

    $referrer     = $mvalue['referrer'];
    $associate    = $mvalue['associate'];
    $premium      = $mvalue['premium'];
    $FSL          = $mvalue['FSL'];
    $SD           = $mvalue['SD'];
    $UL           = $mvalue['UL'];
    $ULGST        = $mvalue['ULGST'];
    $AC           = $mvalue['AC'];
    $ACGST        = $mvalue['ACGST'];
    $ibrokerC     = $mvalue['ibrokerC'];
    $ibrokerCGST  = $mvalue['ibrokerCGST'];
    $RCHC         = $mvalue['RCHC'];
    $RCHCGST      = $mvalue['RCHCGST'];
    $brokerFee    = $mvalue['brokerFee'];
    $brokerFeeGST = $mvalue['brokerFeeGST'];
    $additionalCover    = $mvalue['additionalCover'];
    $additionalCoverGST = $mvalue['additionalCoverGST'];
    $gs           = $mvalue['GST'];
    $total        = $mvalue['total'];
    $discount     = $mvalue['discount'];
    $discount_gst = $mvalue['discount_gst'];
    $refNum       = $deviceType.uniqid();

    IO::sqlInsert('#__priceleaf_quotes', array(
      'associate' => $associate,
      'referrer' => $referrer,
      'create_date' => $ndate,
      'institution' => $institution,
      'name' => $infullname,
      'email' => $email,
      'deviceType' => $deviceType,
      'sum_insured' => $sum_insured,
      'promo_code' => $promo_code,
      'excess' => $excess,
      'numyear' => $numyear,
      'premium' => $premium,
      'FSL' => $FSL,
      'stampDuty' => $SD,
      'UWLevy' => $UL,
      'UWLevyGST' => $ULGST,
      'AC' => $AC,
      'ACGST' => $ACGST,
      'IC' => $ibrokerC,
      'ICGST' => $ibrokerCGST,
      'RCH' => $RCHC,
      'RCHGST' => $RCHCGST,
      'brokerFee' => $brokerFee,
      'brokerFeeGST' => $brokerFeeGST,
      'additionalCover' => $additionalCover,
      'additionalCoverGST' => $additionalCoverGST,
      'GST' => $gs,
      'total' => $total,
      'state' => $state,
      'RefNumber' => $refNum,
      'discountValue' => $discount,
      'discountValueGST' => $discount_gst,
      ));

    $incept = date('Y-m-d');
    $expiry = date('Y-m-d', strtotime('+'.intval($numyear).'year'));
    if (!empty($insured_date)) {
      $incept = $insured_date;
      $instamp = strtotime($incept);
      $expiry = date('Y-m-d', strtotime('+'.intval($numyear).'year', $instamp));
    }
    
    $resul = IO::sqlInsert('#__priceleaf_policy', array(
      'txn_id' => $receipt_no,
      'invoice' => $receipt_no,
      'refNumber' => $refNum,
      'total' => $total,
      'incept_date' => $incept,
      'expiry_date' => $expiry,
      'insured_fullname' => $infullname,
      'insured_surname' => $isurname,
      'enduser_fullname' => $eufullname,
      'enduser_surname' => $eusurname,
      'address' => $address,
      'phone' => $phone,
      'suburb' => $suburb,
      'state' => $state,
      'postcode' => $postcode,
      'make' => $make,
      'model' => $txtmodel,
      'unit' => $unit,
      'purchase_date' => $purchase_date,
      'serialno' => $serialno,
      ));

    $incept = date('Y-m-d').' 00:00:00';
    $expire = date('Y-m-d', strtotime('+'.intval($numyear).'year')).' 00:00:00';
    if (!empty($insured_date)) {
      $incept = $insured_date.' 00:00:00';
      $instamp = strtotime($incept);
      $expiry = date('Y-m-d', strtotime('+'.intval($numyear).'year', $instamp)).' 00:00:00';
    }
    
    IO::sqlInsert('#__inventory', array(
      'inv_incept_date' => $incept,
      'inv_expiry_date' => $expire,
      'inv_make' => $make,
      'inv_model' => $txtmodel,
      'inv_serialno' => $serialno,
      'inv_sum_ins' => $sum_insured,
      'inv_excess' => $excess,
      'inv_user_id' => '',
      'inv_cdate' => date('Y-m-d H:i:s'),
      'inv_mdate' => date('Y-m-d H:i:s'),
      'inv_new_serialno' => '',
      ));

    if($resul){
      //send email to customer
      $query = "SELECT email FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($refNum). " LIMIT 1";
      $db->setQuery($query);
      $recipient = $db->loadResult();

      $mailsubject = JText::_( 'COM_PRICELEAF_POLICYCUSTOMER_MAIL_SUBJECT' );
      $mailbody = JText::_( 'COM_PRICELEAF_POLICYCUSTOMER_MAIL_BODY' );
      //$mailbody = $query;
      $mailer = JFactory::getMailer();
      $config = JFactory::getConfig();
      $sender = array( $config->get( 'config.mailfrom' ), $config->get( 'config.fromname' ) );

      $query  = "SELECT deviceType FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($refNum);
      $db->setQuery($query);
      $dt = $db->loadResult();

      $mailer->setSender($sender);
      $mailer->addRecipient($recipient);
      $mailer->addCC(IBROKER_POLICY_RECIPIENT);
      $mailer->setSubject($mailsubject);

      $mailer->addAttachment(JPATH_BASE.'/images/documents/Policy-Wording.pdf');
      $mailer->addAttachment(JPATH_BASE.'/images/documents/FSG.pdf');
      if($this->createCombinedPDF($refNum,$cathrine)){
        $mailer->addAttachment(JPATH_COMPONENT.'/pdf/Policy_'.strtoupper($refNum).'.pdf');
      }

      $mailer->isHTML(true);
      $mailer->setBody($mailbody);
      $send = $mailer->Send();

      $recipient = IBROKER_POLICY_RECIPIENT;
      $mailsubject = JText::_( 'COM_PRICELEAF_POLICY_MAIL_SUBJECT' );
      $mailbody = JText::_( 'COM_PRICELEAF_POLICY_MAIL_BODY' );
      $mailer->setSender($sender);
      $mailer->ClearAllRecipients();
      $mailer->addRecipient($recipient);
      $mailer->setSubject($mailsubject);
      $mailer->isHTML(true);
      $mailer->setBody($mailbody);
      $send = $mailer->Send();
      return true;
    }else{
      return false;
    }
  }

  function countTotal($excess, $numyear, $RefNumber, $sumi, $deviceType, $postcode, $make, $cover, $promo_code) {
    $db = JFactory::getDBO();
    if($sumi==0){
      $query = "SELECT sum_insured,deviceType FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($RefNumber)." LIMIT 1";
      $db->setQuery($query);
      $rex = $db->loadObject();

      $sumi = $rex->sum_insured;
      $deviceType = $rex->deviceType;
    }

    $rows = IO::getQuote($deviceType, array('postcode' => $postcode, 'sum_insured' => $sumi, 'make' => $make, 'onsite' => $cover, 'promo' => $promo_code));

    $return = array();
    if (!empty($rows['quote'][$excess][$numyear])) {
      $quote = $rows['quote'][$excess][$numyear];
      $return['referrer'] = $quote['referrer'];
      $return['associate'] = $quote['associate'];
      $return['premium'] = $quote['base_premium'];
      $return['FSL'] = $quote['fire_services_levy'];
      $return['SD'] = $quote['stamp_duty'];
      $return['UL'] = $quote['underwriter_levy'];
      $return['ULGST'] = $quote['underwriter_levy_gst'];
      $return['AC'] = $quote['associate_commission'];
      $return['ACGST'] = $quote['associate_commission_gst'];
      $return['ibrokerC'] = $quote['ibroker_commission'];
      $return['ibrokerCGST'] = $quote['ibroker_commission_gst'];
      $return['RCHC'] = $quote['rch_commission'];
      $return['RCHCGST'] = $quote['rch_commission_gst'];
      $return['brokerFee'] = $quote['broker_fee'];
      $return['brokerFeeGST'] = $quote['broker_fee_gst'];
      $return['additionalCover'] = $quote['additional_cover'];
      $return['additionalCoverGST'] = $quote['additional_cover_gst'];
      $return['GST'] = $quote['total_gst'];
      $return['total'] = $quote['premium_payable'];
      $return['discount'] = $quote['discount'];
      $return['discount_gst'] = $quote['discount_gst'];
    }

    return $return;
  }

  function createCombinedPDF($refnum, $customize = ''){
    // = '114123201443125';
    $db = JFactory::getDBO();

    $query = "SELECT * FROM #__priceleaf_quotes WHERE RefNumber=".$db->quote($refnum);
    $db->setQuery($query);
    $qex = $db->loadObject();

    $query = "SELECT * FROM #__priceleaf_policy WHERE refNumber=".$db->quote($refnum);
    $db->setQuery($query);
    $rex = $db->loadObject();

    $sumins = $qex->sum_insured;
    $excess = floatval($qex->excess);
    $excess = !empty($excess) ? $excess : IBROKER_DEFAULT_EXCESS;
    $excess = number_format($excess, 2);
    $numyear = "+". $qex->numyear . " years";
    $realexcess = floatval($excess);
    switch ($qex->deviceType) {
    case 1: //laptop
      $policynum = 'M3 M033119 CAN' ;
      break;
    case 2: //netbook
      $policynum = 'M3 M033119 CAN';
      break;
    case 3: //tablet
      $policynum = 'M3 M033119 CAN';
      $realexcess = 0;
      break;
    }
    //echo date("Y-m-d", strtotime("+6 years"));

    //require_once('./tcpdf/config/lang/eng.php');
    require_once(JPATH_ROOT.'/libraries/tcpdf/tcpdf.php');

    // create new PDF document
    //$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, 'mm', 'A4', true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Laptop & Tablet Insurance Services');
    $pdf->SetTitle('Laptop & Tablet Insurance Services Certificate File');
    $pdf->SetSubject('Reference Number: #'.$refnum);

    // set default header data
    //$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    //set margins
    //$pdf->SetMargins(25, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetTopMargin(5);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0);

    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

    //set some language-dependent strings
    //$pdf->setLanguageArray($l);

    // ---------------------------------------------------------

    // set font
    //$pdf->SetFont('dejavusans', '', 14, '', true);

    // add a page
    $pdf->AddPage();

    // create some HTML content

    //$pdf->writeHTML($htmlcontent, true, 0, true, 0);
    //$pdf->WriteHTML(file_get_contents('test.html'));
    $pagepdf = <<<EOD
<table cellspacing="0" cellpadding="1" border="0">
<tr>
<td width="63%">
<img src="{{logo}}" width="250" height="73" border="0" /><br /><br />
<span>{{todaydate}}</span><br />
</td>
<td width="37%" style="text-align: right;">
<span style="font-size: x-small;">a trading name of <b>I Broker Pty Ltd</b></span><br />
<span style="font-size: xx-small;">ABN 33 115 685 302</span><br />
<span style="font-size: xx-small;">AFSL 299814</span><br />
<span style="font-size: xx-small;">Level 13, 114 William St</span><br />
<span style="font-size: xx-small;">Melbourne Victoria 3000</span><br />
<span style="font-size: xx-small;">Phone: 1300 522 748</span><br />
<span style="font-size: xx-small;">Email: info@ltis.com.au</span><br />
</td>
</tr>
</table>
<br />
<table cellspacing="0" cellpadding="1" border="0">
<tr>
<td width="6%">&nbsp;</td>
<td width="59%">{{infullname}}<br />
{{address}}<br />
{{suburb}} {{state}} {{zip}}
</td>
<td width="35%">&nbsp;</td>
</tr>
</table>
<h2 style="text-align: center;">{{devicetype}} Insurance<br />Tax Invoice / Receipt / Certificate</h2>
<p>This document confirms that insurance has been effected on your behalf, as detailed below, in accordance with your online instructions and premium payment, and the policy details available in the &#96;Documents&#96; menu option of our web site at <a href="http://www.ltis.com.au">www.ltis.com.au</a>.</p>
<table cellspacing="0" cellpadding="1" border="0" style="font-size: small;">
<tr>
<td width="35%">&nbsp;</td>
<td width="65%">&nbsp;</td>
</tr>
<tr><td>Owner / Insured</td><td>: {{infullname}}</td></tr>
<tr><td>End user</td><td>: {{eufullname}}</td></tr>
<tr><td>Insurance Company</td><td>: QBE Insurance (Australia) Limited</td></tr>
<tr><td>Insurance Cover</td><td>: Accidental Loss or Damage including Theft</td></tr>
<tr><td>Geographic Limits to cover</td><td>: {{geoarea}}</td></tr>
<tr><td>Insured Device</td><td>: {{Make}} {{Model}}</td></tr>
<tr><td>Serial Number</td><td>: {{serialnum}}</td></tr>
<tr><td>Sum Insured</td><td>: \${{sumins}} (ex-GST)</td></tr>
<tr><td>Excess</td><td>: \${{excess}} (Applies to each and every claim)</td></tr>
<tr><td>Start Date of Insurance</td><td>: {{date}}</td></tr>
<tr><td>End Date of Insurance</td><td>: {{expdate}} at 4.00 pm</td></tr>
<tr><td>Policy Number</td><td>: {{policynum}}</td></tr>
<tr><td>Invoice / Receipt Number</td><td>: {{invoiceid}}</td></tr>
</table>
<table cellspacing="0" cellpadding="1" border="0" style="font-size: small;">
<tr>
<td width="50%">&nbsp;</td>
<td width="5%">&nbsp;</td>
<td width="45%">&nbsp;</td>
</tr>
<tr>
<td>
<table cellspacing="0" cellpadding="0" border="0">
<tr>
<td width="70%">&nbsp;</td>
<td width="30%">&nbsp;</td>
</tr>
<tr><th>Premium</th><td style="text-align: right;">\${{price_premium}}</td></tr>
<tr><th>Fire Services Levy</th><td style="text-align: right;">\${{price_firelevy}}</td></tr>
<tr><th>GST</th><td style="text-align: right;">\${{price_gst}}</td></tr>
<tr><th>Stamp Duty</th><td style="text-align: right;">\${{price_stamp}}</td></tr>
<tr><th>Underwriter Levy</th><td style="text-align: right;">\${{price_uwlevy}}</td></tr>
<tr><th>Underwriter Levy GST</th><td style="text-align: right;">\${{price_uwlevy_gst}}</td></tr>
<tr><th>Broker's Fee</th><td style="text-align: right;">\${{price_broker}}</td></tr>
<tr><th>Broker's Fee GST</th><td style="text-align: right;">\${{price_broker_gst}}</td></tr>
{{unisys_onsite_repair}}
{{promo_code_discount}}
<tr><th style="border-top: 2px solid black;"><b>Total Premium Paid</b></th><td style="border-top: 2px solid black; text-align: right;"><b>\${{price_total}}</b></td></tr>
</table>
</td>
<td>&nbsp;</td>
<td style="font-size: xx-small;">Please refer to the &#96;Documents&#96; menu option of our web site at <a href="http://www.ltis.com.au">www.ltis.com.au</a> to review our:
<ol>
<li>Policy Wording / PDS</li>
<li>Financial Services Guide (FSG)</li>
<li>General Advice Disclosure</li>
<li>Wholesale Broking Agreement</li>
<li>Dispute Resolution  Guide</li>
{{countriesexcluded}}
</ol>
</td>
</tr>
</table>
<p style="font-size: x-small;">In the event of an incident that may give rise to a claim under this insurance, please visit the &#96;Claims&#96; menu option of our web site at <a href="http://www.ltis.com.au">www.ltis.com.au</a>, or contact LTIS on 1300 522 748.</p>
EOD;

    $logo = JURI::root().'/components/com_priceleafs/assets/logo.png';
    $autograph = JURI::root().'/components/com_priceleafs/assets/autograph.gif';
    $pagepdf = str_replace('{{logo}}',$logo,$pagepdf);
    $pagepdf = str_replace('{{autograph}}',$autograph,$pagepdf);

    $deviceid   = $qex->deviceType;
    //$geographic_area = 'Worldwide for the entire period of insurance<br>(excluding some countries as listed on our web site)';
    $geographic_area = 'Worldwide (excluding some countries)';
    $countries_excluded = '<li>Countries excluded from World Wide cover</li>';
    switch ($deviceid) {
      case 1: $devicetype = 'Laptop'; break;
      case 2: $devicetype = 'Netbook'; $geographic_area = 'Australia Wide'; $countries_excluded = ''; break;
      case 3: $devicetype = 'Tablet'; break;
    }
    $invoiceid  = $rex->invoice;
    $infullname   = $rex->insured_fullname;
    $isurname   = '';
    $eufullname  = $rex->enduser_fullname;
    $eusurname  = '';
    $address   = $rex->address;
    $phone   = $rex->phone;
    $suburb     = $rex->suburb;
    $state      = $rex->state;
    $postcode   = $rex->postcode;
    $make       = $rex->make;
    $txtmodel   = $rex->model;
    $serialno   = $rex->serialno;

    $todaydate = date("d/m/Y");
    $today = date("d/m/Y", strtotime($rex->incept_date));
    $expdate = date("d/m/Y", strtotime($rex->expiry_date));

    $pagepdf = str_replace('{{todaydate}}',$todaydate,$pagepdf);
    $pagepdf = str_replace('{{devicetype}}',$devicetype,$pagepdf);
    $pagepdf = str_replace('{{geoarea}}',$geographic_area,$pagepdf);
    $pagepdf = str_replace('{{countriesexcluded}}',$countries_excluded,$pagepdf);
    $pagepdf = str_replace('{{invoiceid}}',$invoiceid,$pagepdf);
    $pagepdf = str_replace('{{infullname}}',$infullname,$pagepdf);
    $pagepdf = str_replace('{{ilastname}}',$isurname,$pagepdf);
    $pagepdf = str_replace('{{address}}',$address,$pagepdf);
    $pagepdf = str_replace('{{phone}}',$phone,$pagepdf);
    $pagepdf = str_replace('{{suburb}}',$suburb,$pagepdf);
    $pagepdf = str_replace('{{state}}',$state,$pagepdf);
    $pagepdf = str_replace('{{zip}}',$postcode,$pagepdf);
    $pagepdf = str_replace('{{eufullname}}',$eufullname,$pagepdf);
    $pagepdf = str_replace('{{eulastname}}',$eusurname,$pagepdf);
    $pagepdf = str_replace('{{Make}}',$make,$pagepdf);
    $pagepdf = str_replace('{{Model}}',$txtmodel,$pagepdf);
    $pagepdf = str_replace('{{sumins}}',$sumins,$pagepdf);
    $pagepdf = str_replace('{{serialnum}}',$serialno,$pagepdf);
    $pagepdf = str_replace('{{incdate}}',$today,$pagepdf);
    $pagepdf = str_replace('{{date}}',$today,$pagepdf);
    $pagepdf = str_replace('{{expdate}}',$expdate,$pagepdf);
    $pagepdf = str_replace('{{policynum}}',$policynum,$pagepdf);
    $pagepdf = str_replace('{{excess}}',$excess,$pagepdf);
    $pagepdf = str_replace('{{refnumber}}',$refnum,$pagepdf);

    $price_premium = $qex->premium;
    $price_uwlevy = $qex->UWLevy;
    $price_uwlevy_gst = $qex->UWLevyGST;
    $price_firelevy = $qex->FSL;
    $price_gst = $qex->GST;
    $price_stamp = $qex->stampDuty;
    $price_broker = $qex->brokerFee;
    $price_broker_gst = $qex->brokerFeeGST;
    $price_cover = $qex->additionalCover;
    $price_cover_gst = $qex->additionalCoverGST;
    $price_discount = $qex->discountValue;
    $price_discount_gst = $qex->discountValueGST;
    $price_total = $qex->total;

    $pagepdf = str_replace('{{price_premium}}',$price_premium,$pagepdf);
    $pagepdf = str_replace('{{price_uwlevy}}',$price_uwlevy,$pagepdf);
    $pagepdf = str_replace('{{price_uwlevy_gst}}',$price_uwlevy_gst,$pagepdf);
    $pagepdf = str_replace('{{price_firelevy}}',$price_firelevy,$pagepdf);
    $pagepdf = str_replace('{{price_gst}}',$price_gst,$pagepdf);
    $pagepdf = str_replace('{{price_stamp}}',$price_stamp,$pagepdf);
    $pagepdf = str_replace('{{price_broker}}',$price_broker,$pagepdf);
    $pagepdf = str_replace('{{price_broker_gst}}',$price_broker_gst,$pagepdf);
    $pagepdf = str_replace('{{price_cover}}',$price_cover,$pagepdf);
    $pagepdf = str_replace('{{price_cover_gst}}',$price_cover_gst,$pagepdf);
    $pagepdf = str_replace('{{price_total}}',$price_total,$pagepdf);

    if ($price_cover > 0) {
      $onsite_repair = '<tr><th>Unisys Onsite Repair</th><td style="text-align: right;">$'.$price_cover.'</td></tr>
<tr><th>Unisys Onsite Repair GST</th><td style="text-align: right;">$'.$price_cover_gst.'</td></tr>';
      $pagepdf = str_replace('{{unisys_onsite_repair}}',$onsite_repair,$pagepdf);
    } else {
      $pagepdf = str_replace('{{unisys_onsite_repair}}','',$pagepdf);
    }

    if ($price_discount > 0) {
      $price_discount_text = '<tr><th>Promo Code Discount</th><td style="text-align: right;">- $'.$price_discount.'</td></tr>
<tr><th>Promo Code Discount GST</th><td style="text-align: right;">- $'.$price_discount_gst.'</td></tr>';
      $pagepdf = str_replace('{{promo_code_discount}}',$price_discount_text,$pagepdf);
    } else {
      $pagepdf = str_replace('{{promo_code_discount}}','',$pagepdf);
    }

    $pdf->WriteHTML($pagepdf);
    $pdf->lastPage();
    $pdf->Output(JPATH_ROOT.'/components/com_priceleafs/pdf/Policy_'.strtoupper($refnum).'.pdf', 'F'); //Should use variable to make file name
    return true;
  }
}
