<?php
defined('_JEXEC') or die;

class PriceleafsModelZakazs extends JModelList
{
  public function Policy($startdate,$enddate,$limit,$limitstart){
    $db = JFactory::getDBO();
    if($startdate==''){
      $startdate = date("Y-m-d");
    }else{
      $ndate = explode('-', $startdate);
      $startdate = $ndate[2].'-'.$ndate[1].'-'.$ndate[0];
    }
        
    if($enddate==''){
      $enddate = date("Y-m-d");
    }else{
      $mdate = explode('-', $enddate);
      $enddate = $mdate[2].'-'.$mdate[1].'-'.$mdate[0];
    }
	  $sql = "SELECT * FROM #__priceleaf_policy AS p LEFT JOIN #__priceleaf_quotes AS q ON p.refNumber=q.RefNumber WHERE q.create_date BETWEEN ".$db->quote($startdate)." AND ".$db->quote($enddate)." ORDER BY q.create_date DESC,insured_fullname ASC LIMIT ".$limitstart.",".$limit;
	  $db->setQuery($sql);
	  $row = $db->loadObjectList();
	  return $row;
	}
		
  public function PTotal($startdate,$enddate){
    $db = JFactory::getDBO();
    if($startdate==''){
      $startdate = date("Y-m-d");
    }else{
      $ndate = explode('-', $startdate);
      $startdate = $ndate[2].'-'.$ndate[1].'-'.$ndate[0];
    }
        
    if($enddate==''){
      $enddate = date("Y-m-d");
    }else{
      $mdate = explode('-', $enddate);
      $enddate = $mdate[2].'-'.$mdate[1].'-'.$mdate[0];
    }
	$sql = "SELECT COUNT(*) FROM #__priceleaf_policy AS p LEFT JOIN #__priceleaf_quotes AS q ON p.refNumber=q.RefNumber WHERE q.create_date BETWEEN ".$db->quote($startdate)." AND ".$db->quote($enddate);
	$db->setQuery($sql);
	$row = $db->loadResult();
	return $row;
  }	
		
  public function AllPolicy($limit,$limitstart){
    $db = JFactory::getDBO();
    $sql = "SELECT * FROM #__priceleaf_policy AS p LEFT JOIN #__priceleaf_quotes AS q ON p.refNumber=q.RefNumber LIMIT ".$limitstart.",".$limit;
	  $db->setQuery($sql);
	  $row = $db->loadObjectList();
	  return $row;
	}
  
  public function AllTotal(){
    $db = JFactory::getDBO();
    $sql = "SELECT COUNT(*) FROM #__priceleaf_policy AS p LEFT JOIN #__priceleaf_quotes AS q ON p.refNumber=q.RefNumber";
	$db->setQuery($sql);
	$row = $db->loadResult();
	return $row;
  }
  
  public function export($startdate,$enddate){
    $db = JFactory::getDBO();
    if($startdate==''){
      $startdate = date("Y-m-d");
    }else{
      $ndate = explode('-', $startdate);
      $startdate = $ndate[2].'-'.$ndate[1].'-'.$ndate[0];
    }
        
    if($enddate==''){
      $enddate = date("Y-m-d");
    }else{
      $mdate = explode('-', $enddate);
      $enddate = $mdate[2].'-'.$mdate[1].'-'.$mdate[0];
    }
    $output = '"no data"';
    $sql = "SELECT * FROM #__priceleaf_policy AS p LEFT JOIN #__priceleaf_quotes AS q ON p.refNumber=q.RefNumber WHERE p.exported=0 AND (q.create_date BETWEEN ".$db->quote($startdate)." AND ".$db->quote($enddate).") ORDER BY q.create_date DESC,insured_fullname ASC";
    $db->setQuery($sql);
    $rows = $db->loadObjectList();
    $headers = array(
      'Purchase Date',
      'Inception Date',
      'Expiry Date',
      'Reference Number',
      'Insured',
      'Phone',
      'Email',
      'Address',
      'Suburb',
      'State',
      'Postcode',
      'School',
      'End User',
      'Device',
      'Make',
      'Model',
      'Serial #',
      'Promo Code',
      'Sum Insured',
      'Excess',
      'Year',
      'Premium',
      'FSL',
      'Stamp Duty',
      'GST',
      'U/W Levy',
      'U/W Levy GST',
      'Total Premium',
      'Associate Commission',
      'Associate Commission GST',
      'iBroker Commission',
      'iBroker Commission GST',
      'Additional Cover',
      'Additional Cover GST',
      'Broker Fee',
      'Broker Fee GST',
      'Promo Discount',
      'Promo Discount GST',
    );
    $output = '';
    if($rows){
      $csv = fopen('php://temp/maxmemory:'. (5*1024*1024), 'r+');
      fputcsv($csv, $headers);
      foreach ($rows as $row) {
        $deviceType = '';
        switch ($row->deviceType) {
        case 1: $deviceType = 'Laptop'; break;
        case 2: $deviceType = 'Netbook'; break;
        case 3: $deviceType = 'Tablet'; break;
        }
        $realexcess = floatval($row->excess);
        $excess = floatval($row->excess);
        $excess = !empty($excess) ? $excess : IBROKER_DEFAULT_EXCESS;
        $excess = number_format($excess, 2);
        fputcsv($csv, array(
          $row->create_date,
          $row->incept_date,
          $row->expiry_date,
          $row->RefNumber,
          $row->insured_fullname,
          $row->phone,
          $row->email,
          $row->address,
          $row->suburb,
          $row->state,
          $row->postcode,
          $row->institution,
          $row->enduser_fullname,
          $deviceType,
          $row->make,
          $row->model,
          $row->serialno,
          $row->promo_code,
          $row->sum_insured,
          $excess,
          $row->numyear,
          $row->premium,
          $row->FSL,
          $row->stampDuty,
          $row->GST,
          $row->UWLevy,
          $row->UWLevyGST,
          $row->total,
          $row->AC,
          $row->ACGST,
          $row->IC,
          $row->ICGST,
          $row->additionalCover,
          $row->additionalCoverGST,
          $row->brokerFee,
          $row->brokerFeeGST,
          '-'.$row->discountValue,
          '-'.$row->discountValueGST,
          ));
      }
      rewind($csv);
      $output = stream_get_contents($csv);
    }
    return $output;
  }

  public function markComplete($id){
    $db = JFactory::getDBO();
    $sql = "UPDATE #__priceleaf_policy SET exported=1 WHERE refNumber=".$db->quote($id);
	$db->setQuery($sql);
	$result = $db->query();
	return $result;
  }
  
  
  public function markUncomplete($id){
    $db = JFactory::getDBO();
    $sql = "UPDATE #__priceleaf_policy SET exported=0 WHERE refNumber=".$db->quote($id);
	$db->setQuery($sql);
	$result = $db->query();
	return $result;
  }
    
}
