<?php
defined('_JEXEC') or die;
class PriceleafsModelMenus extends JModelList
{
  protected function getListQuery()
	{
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);
		$user	= JFactory::getUser();

		$query->select($this->getState('list.select','a.*,r.name AS device'));
		$query->from($db->quoteName('#__priceleaf_quotes').' AS a');
    $query->join('LEFT', '#__priceleaf_razdel AS r ON a.deviceType = r.id');
    $search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$query->where('(a.name LIKE '.$search.')');
			}
		}						
				
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		if ($orderCol == '' || $orderCol == 'category_title') {
			$orderCol = 'a.id '.$orderDirn.', a.create_date, a.RefNumber';
		}
    $orderCol .= ', a.create_date, a.RefNumber';
		$query->order($db->escape($orderCol.' '.$orderDirn));

		return $query;
	}
	
  public function getQuotes($startdate,$enddate,&$referrers = array()){
	    $db = JFactory::getDBO();
        if($startdate==''){
            $startdate = date("Y-m-d");
        }else{
            $ndate = explode('-', $startdate);
            $startdate = $ndate[2].'-'.$ndate[1].'-'.$ndate[0];
        }
        
        if($enddate==''){
            $enddate = date("Y-m-d");
        }else{
            $mdate = explode('-', $enddate);
            $enddate = $mdate[2].'-'.$mdate[1].'-'.$mdate[0];
        }
	    $sql = "SELECT
        w.create_date,
        COUNT(IF(w.email = '', 1, null) AND IF(w.associate = 0, 1, null)) AS total_prequote,
        COUNT(IF(w.email != '', 1, null) AND IF(w.associate = 0, 1, null)) AS total_quote,
        COUNT(IF(w.RefNumber IN (SELECT refNumber from #__priceleaf_policy), 1, null)) AS total_policy,
        COUNT(IF(w.email = '', 1, null) AND IF(w.associate = 1, 1, null)) AS total_associate,
        COUNT(IF(w.promo_code != '', 1, null) AND IF(w.discountValue > 0, 1, null)) AS total_promo
        FROM #__priceleaf_quotes AS w WHERE w.create_date BETWEEN ".$db->quote($startdate)." AND ".$db->quote($enddate)." GROUP BY w.create_date";
	    $db->setQuery($sql);
	    $rows = $db->loadObjectList();

      $referrers = array();
      foreach ($rows as $row) {
        if ($row->total_associate > 0) {
          $create_date = $row->create_date;
          $sql = "SELECT
            w.referrer,
            COUNT(w.referrer) AS total_referrer
            FROM #__priceleaf_quotes AS w
            WHERE w.create_date = ".$db->quote($create_date)."
            AND w.email = ''
            AND w.associate = 1
            AND w.referrer != ''
            GROUP BY w.referrer";
	        $db->setQuery($sql);
	        $refcounts = $db->loadObjectList();
          if (!empty($refcounts)) {
            foreach ($refcounts as $refcount) {
              $referrers[$create_date][$refcount->referrer] = $refcount->total_referrer;
            }
          }
        }
      }

	    return $rows;
	}
	
}
