<?php

/**
 * @version    CVS: 1.formulaoverride
 * @package    Com_Ibroker_formulaoverride
 * @author     Ario Jatmiko <rarioj@gmail.com>
 * @copyright  2017 Ario Jatmiko
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Ibroker_formulaoverride records.
 *
 * @since  1.6
 */
class Ibroker_formulaoverrideModelFormulaoverrides extends JModelList
{
/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.`id`',
				'ordering', 'a.`ordering`',
				'state', 'a.`state`',
				'created_by', 'a.`created_by`',
				'modified_by', 'a.`modified_by`',
				'domain_rule_name', 'a.`domain_rule_name`',
				'referral_url', 'a.`referral_url`',
				'referral_code', 'a.`referral_code`',
				'domain_value_device', 'a.`domain_value_device`',
				'domain_value_key', 'a.`domain_value_key`',
				'domain_value_formula', 'a.`domain_value_formula`',
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
		$this->setState('filter.state', $published);
		// Filtering domain_value_key
		$this->setState('filter.domain_value_key', $app->getUserStateFromRequest($this->context.'.filter.domain_value_key', 'filter_domain_value_key', '', 'string'));


		// Load the parameters.
		$params = JComponentHelper::getParams('com_ibroker_formulaoverride');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.domain_rule_name', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return   string A store id.
	 *
	 * @since    1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.state');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select', 'DISTINCT a.*'
			)
		);
		$query->from('`#__ibroker_formulaoverride` AS a');

		// Join over the users for the checked out user
		$query->select("uc.name AS uEditor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");

		// Join over the user field 'created_by'
		$query->select('`created_by`.name AS `created_by`');
		$query->join('LEFT', '#__users AS `created_by` ON `created_by`.id = a.`created_by`');

		// Join over the user field 'modified_by'
		$query->select('`modified_by`.name AS `modified_by`');
		$query->join('LEFT', '#__users AS `modified_by` ON `modified_by`.id = a.`modified_by`');

		// Filter by published state
		$published = $this->getState('filter.state');

		if (is_numeric($published))
		{
			$query->where('a.state = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.state IN (0, 1))');
		}

		// Filter by search in title
		$search = $this->getState('filter.search');

		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->Quote('%' . $db->escape($search, true) . '%');
				$query->where('( a.domain_rule_name LIKE ' . $search . '  OR  a.referral_code LIKE ' . $search . '  OR  a.domain_value_device LIKE ' . $search . '  OR  a.domain_value_key LIKE ' . $search . ' )');
			}
		}


		//Filtering domain_value_key
		$filter_domain_value_key = $this->state->get("filter.domain_value_key");
		if ($filter_domain_value_key !== null && !empty($filter_domain_value_key))
		{
			$query->where("a.`domain_value_key` = '".$db->escape($filter_domain_value_key)."'");
		}
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering');
		$orderDirn = $this->state->get('list.direction');

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}

	/**
	 * Get an array of data items
	 *
	 * @return mixed Array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();

		foreach ($items as $oneItem)
		{

			if (isset($oneItem->domain_value_device)) {
				$values = explode(',', $oneItem->domain_value_device);

				$textValue = array();
				foreach ($values as $value)
				{
					if (!empty($value))
					{
						$db = JFactory::getDbo();
						$query = "SELECT `id`, `device` FROM #__ibroker_formula HAVING `id` LIKE  '" . $value  . "' ";
						$db->setQuery($query);
						$results = $db->loadObject();
						if ($results) {
							$textValue[] = $results->device;
						}
					}
				}

			$oneItem->domain_value_device = !empty($textValue) ? implode(', ', $textValue) : $oneItem->domain_value_device;

			}
					$oneItem->domain_value_key = JText::_('COM_IBROKER_FORMULAOVERRIDE_FORMULAOVERRIDES_DOMAIN_VALUE_KEY_OPTION_' . strtoupper($oneItem->domain_value_key));
		}

		return $items;
	}
}
