<?php

/**
 * @version     1.1.0
 * @package     com_ibroker_formula
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ario Jatmiko <ario@dedicated-it.com> - http://earthlinkdesign.com.au
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Ibroker_formula.
 */
class Ibroker_formulaViewFormulas extends JViewLegacy {

    protected $items;
    protected $pagination;
    protected $state;

    /**
     * Display the view
     */
    public function display($tpl = null) {
        $this->state = $this->get('State');
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }

        JHtmlSidebar::addEntry( 'Formulas', 'index.php?option=com_ibroker_formula&view=formulas', true );
        JHtmlSidebar::addEntry( 'Formula Overrides', 'index.php?option=com_ibroker_formulaoverride&view=formulaoverrides', false );
        JHtmlSidebar::addEntry( 'Map User Codes', 'index.php?option=com_ibroker_mapusercode&view=mapusercodes', false );
        JHtmlSidebar::addEntry( 'Postcodes', 'index.php?option=com_ibroker_postcode&view=postcodes', false );
        JHtmlSidebar::addEntry( 'Referral Codes', 'index.php?option=com_ibroker_referralcode&view=referralcodes', false );
        JHtmlSidebar::addEntry( 'Promo Discount', 'index.php?option=com_ibroker_discount&view=discounts', false );
        JHtmlSidebar::addEntry( '<hr />', '', false );
        JHtmlSidebar::addEntry( 'Quote Report', 'index.php?option=com_priceleafs&view=menus', false );
        JHtmlSidebar::addEntry( 'Policies', 'index.php?option=com_priceleafs&view=zakazs', false );
        JHtmlSidebar::addEntry( 'All Policies', 'index.php?option=com_priceleafs&view=csvs', false );
        JHtmlSidebar::addEntry( '<hr />', '', false );
        JHtmlSidebar::addEntry( 'Inventories', 'index.php?option=com_helloworld', false );

        $this->addToolbar();

        $this->sidebar = JHtmlSidebar::render();
        parent::display($tpl);
    }

    /**
     * Add the page title and toolbar.
     *
     * @since	1.6
     */
    protected function addToolbar() {
        require_once JPATH_COMPONENT . '/helpers/ibroker_formula.php';

        $state = $this->get('State');
        $canDo = Ibroker_formulaHelper::getActions($state->get('filter.category_id'));

        JToolBarHelper::title(JText::_('COM_IBROKER_FORMULA_TITLE_FORMULAS'), 'formulas.png');

        //Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR . '/views/formula';
        if (file_exists($formPath)) {

            if ($canDo->get('core.create')) {
                JToolBarHelper::addNew('formula.add', 'JTOOLBAR_NEW');
            }

            if ($canDo->get('core.edit') && isset($this->items[0])) {
                JToolBarHelper::editList('formula.edit', 'JTOOLBAR_EDIT');
            }
        }

        if ($canDo->get('core.edit.state')) {

            if (isset($this->items[0]->state)) {
                JToolBarHelper::divider();
                JToolBarHelper::custom('formulas.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
                JToolBarHelper::custom('formulas.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
            } else if (isset($this->items[0])) {
                //If this component does not use state then show a direct delete button as we can not trash
                JToolBarHelper::deleteList('', 'formulas.delete', 'JTOOLBAR_DELETE');
            }

            if (isset($this->items[0]->state)) {
                JToolBarHelper::divider();
                JToolBarHelper::archiveList('formulas.archive', 'JTOOLBAR_ARCHIVE');
            }
            if (isset($this->items[0]->checked_out)) {
                JToolBarHelper::custom('formulas.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
            }
        }

        //Show trash and delete for components that uses the state field
        if (isset($this->items[0]->state)) {
            if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
                JToolBarHelper::deleteList('', 'formulas.delete', 'JTOOLBAR_EMPTY_TRASH');
                JToolBarHelper::divider();
            } else if ($canDo->get('core.edit.state')) {
                JToolBarHelper::trash('formulas.trash', 'JTOOLBAR_TRASH');
                JToolBarHelper::divider();
            }
        }

        if ($canDo->get('core.admin')) {
            JToolBarHelper::preferences('com_ibroker_formula');
        }

        //Set sidebar action - New in 3.0
        JHtmlSidebar::setAction('index.php?option=com_ibroker_formula&view=formulas');

        $this->extra_sidebar = '';
        
		JHtmlSidebar::addFilter(

			JText::_('JOPTION_SELECT_PUBLISHED'),

			'filter_published',

			JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), "value", "text", $this->state->get('filter.state'), true)

		);

    }

	protected function getSortFields()
	{
		return array(
		'a.`id`' => JText::_('JGRID_HEADING_ID'),
		'a.`ordering`' => JText::_('JGRID_HEADING_ORDERING'),
		'a.`state`' => JText::_('JSTATUS'),
		'a.`device`' => JText::_('COM_IBROKER_FORMULA_FORMULAS_DEVICE'),
		'a.`parameter`' => JText::_('COM_IBROKER_FORMULA_FORMULAS_PARAMETER'),
		);
	}

}
