<?php

/**
 * @version     1.1.0
 * @package     com_ibroker_formula
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ario Jatmiko <ario@dedicated-it.com> - http://earthlinkdesign.com.au
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Ibroker_formula records.
 */
class Ibroker_formulaModelFormulas extends JModelList {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                                'id', 'a.`id`',
                'ordering', 'a.`ordering`',
                'state', 'a.`state`',
                'created_by', 'a.`created_by`',
                'device', 'a.`device`',
                'parameter', 'a.`parameter`',
                'fml_base_premium', 'a.`fml_base_premium`',
                'fml_fire_services_levy', 'a.`fml_fire_services_levy`',
                'fml_marine_gst', 'a.`fml_marine_gst`',
                'fml_static_gst', 'a.`fml_static_gst`',
                'fml_total_gst', 'a.`fml_total_gst`',
                'fml_stamp_duty', 'a.`fml_stamp_duty`',
                'fml_underwriter_levy', 'a.`fml_underwriter_levy`',
                'fml_underwriter_levy_gst', 'a.`fml_underwriter_levy_gst`',
                'fml_broker_fee', 'a.`fml_broker_fee`',
                'fml_broker_fee_gst', 'a.`fml_broker_fee_gst`',
                'fml_additional_cover', 'a.`fml_additional_cover`',
                'fml_additional_cover_gst', 'a.`fml_additional_cover_gst`',
                'fml_premium_payable', 'a.`fml_premium_payable`',
                'fml_associate_commission', 'a.`fml_associate_commission`',
                'fml_associate_commission_gst', 'a.`fml_associate_commission_gst`',
                'fml_ibroker_commission', 'a.`fml_ibroker_commission`',
                'fml_ibroker_commission_gst', 'a.`fml_ibroker_commission_gst`',
                'fml_rch_commission', 'a.`fml_rch_commission`',
                'fml_rch_commission_gst', 'a.`fml_rch_commission_gst`',

            );
        }

        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     */
    protected function populateState($ordering = null, $direction = null) {
        // Initialise variables.
        $app = JFactory::getApplication('administrator');

        // Load the filter state.
        $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
        $this->setState('filter.state', $published);

        

        // Load the parameters.
        $params = JComponentHelper::getParams('com_ibroker_formula');
        $this->setState('params', $params);

        // List state information.
        parent::populateState('a.device', 'asc');
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param	string		$id	A prefix for the store id.
     * @return	string		A store id.
     * @since	1.6
     */
    protected function getStoreId($id = '') {
        // Compile the store id.
        $id.= ':' . $this->getState('filter.search');
        $id.= ':' . $this->getState('filter.state');

        return parent::getStoreId($id);
    }

    /**
     * Build an SQL query to load the list data.
     *
     * @return	JDatabaseQuery
     * @since	1.6
     */
    protected function getListQuery() {
        // Create a new query object.
        $db = $this->getDbo();
        $query = $db->getQuery(true);

        // Select the required fields from the table.
        $query->select(
                $this->getState(
                        'list.select', 'DISTINCT a.*'
                )
        );
        $query->from('`#__ibroker_formula` AS a');

        
		// Join over the users for the checked out user
		$query->select("uc.name AS editor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");
		// Join over the user field 'created_by'
		$query->select('`created_by`.name AS `created_by`');
		$query->join('LEFT', '#__users AS `created_by` ON `created_by`.id = a.`created_by`');

        

		// Filter by published state
		$published = $this->getState('filter.state');
		if (is_numeric($published)) {
			$query->where('a.state = ' . (int) $published);
		} else if ($published === '') {
			$query->where('(a.state IN (0, 1))');
		}

        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('a.id = ' . (int) substr($search, 3));
            } else {
                $search = $db->Quote('%' . $db->escape($search, true) . '%');
                $query->where('( a.`device` LIKE '.$search.' )');
            }
        }

        


        // Add the list ordering clause.
        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');
        if ($orderCol && $orderDirn) {
            $query->order($db->escape($orderCol . ' ' . $orderDirn));
        }

        return $query;
    }

    public function getItems() {
        $items = parent::getItems();
        
        return $items;
    }

}
