<?php

/**
 * @version		$Id: view.html.php 51 2010-11-22 01:33:21Z chdemko $
 * @package		Joomla16.Tutorials
 * @subpackage	Components
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @author		Christophe Demko
 * @link		http://joomlacode.org/gf/project/helloworld_1_6/
 * @license		License GNU General Public License version 2 or later
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla view library
jimport('joomla.application.component.view');

/**
 * HelloWorlds View
 */
class HelloWorldViewSerial extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Serial view display method
	 * @return void
	 */
	function display($tpl = null) 
	{
		$layoutName = JRequest :: getVar('layout', '');
        if($layoutName=='edit'){
            $id = JRequest :: getVar('id', '');
            $model = $this->getModel();
            $item = $model->getSerialnum($id);
            
            // Check for errors.
	        if (count($errors = $this->get('Errors'))) {
		        JError::raiseError(500, implode('<br />', $errors));
		        return false;
	        }
	        
	        // Assign data to the view
	        $this->item = $item;
	        $lay = "Edit";
	    }else{
	        $lay = "Add";
	    }
	    
		$this->addToolbar($lay);
		// Display the template
		parent::display($tpl);
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar($lay) 
	{
		JToolBarHelper::title($lay . ' Serial Number', 'helloworld');
		//JToolbarHelper::save('serial.save');
		//JToolbarHelper::cancel('serial.cancel');
	}
	/**
	 * Method to set up the document properties
	 *
	 * @return void
	 */
	protected function setDocument() 
	{
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_HELLOWORLD_ADMINISTRATION'));
	}
}
