<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.view');

class HelloWorldViewChange extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  function display($tpl = null)
  {
    $this->addToolbar();
    $model = $this->getModel();
    $this->displayForm = 'step1';

    $old_serial = JRequest::getVar('old_serial', '');
    $old_serial = trim($old_serial);
    $new_serial = JRequest::getVar('new_serial', '');
    $new_serial = trim($new_serial);
    $effective_date = JRequest::getVar('effective_date', '');
    $effective_date = trim($effective_date);
    if (!empty($old_serial) && !empty($new_serial) && !empty($effective_date)) {
      $error = $model->changeValidate();
      if ($error !== true) {
        die($error);
      }

      list($date, $month, $year) = explode('-', $effective_date);
      $effective_time = strtotime($year.'-'.$month.'-'.$date.' 00:00:00');
      $inventory = $model->getInventory($old_serial);
      $inception_time = strtotime($inventory->inv_incept_date);
      $expiration_time = strtotime($inventory->inv_expiry_date);
      $inception_input = date('d-m-Y', $inception_time);
      $expiration_input = date('d-m-Y', $expiration_time);
      $effective_input = date('d-m-Y', $effective_time);

      $this->input = (object) array(
        'old_inception_date' => $inception_input,
        'new_inception_date' => $effective_input,
        'old_expiration_date' => $effective_input,
        'new_expiration_date' => $expiration_input,
        'old_make' => $inventory->inv_make,
        'new_make' => $inventory->inv_make,
        'old_model' => 'Replaced by '.$new_serial,
        'new_model' => 'Replaces '.$old_serial,
        'old_serial' => $old_serial,
        'new_serial' => $new_serial,
        'old_sum_insured' => $inventory->inv_sum_ins,
        'new_sum_insured' => $inventory->inv_sum_ins,
        'old_excess' => $inventory->inv_excess,
        'new_excess' => $inventory->inv_excess,
        );

      $this->displayForm = 'step2';
    }

    parent::display($tpl);
  }
  protected function addToolBar()
  {
    JToolBarHelper::title('Change Serial Number', 'helloworld');
  }
  protected function setDocument()
  {
    $document = JFactory::getDocument();
    $document->setTitle(JText::_('COM_HELLOWORLD_ADMINISTRATION'));
  }
}
