﻿<?php

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controlleradmin');

class HelloWorldControllerSerials extends JControllerAdmin
{
  protected $text_prefix = 'COM_HELLOWORLD_SERIALS';
  public function getModel($name = 'Serials', $prefix = 'HelloWorldModel')
  {
    $model = parent::getModel($name, $prefix, array('ignore_request' => true));
    return $model;
  }
  public function save(){
    $jobid =  JRequest::getVar('bd');
    $model =  parent::getModel('HelloWorlds','HelloWorldModel');
    $msg = $model->setUpdate($jobid);
    $link = 'index.php?option=com_helloworld&view=helloworlds';
    $this->setRedirect($link, $msg);
  }
  public function add(){
    $link = 'index.php?option=com_helloworld&view=serial';
    $this->setRedirect($link);
  }
  public function insertData(array $fields) {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $columns = $values = array();
    foreach ($fields as $column => $value) {
      if ($column == 'inv_incept_date' || $column == 'inv_expiry_date') {
        list($date, $month, $year) = explode('/', $value);
        $value = $year.'/'.$month.'/'.$date.' 00:00:00';
      }
      $columns[] = $column;
      $values[] = $db->quote($value);
    }
    $query->insert($db->quoteName('#__inventory'))
    ->columns($db->quoteName($columns))
    ->values(implode(',', $values));
    $db->setQuery($query);
    $db->query();
    return $db->insertid();
  }
  public function import(){
    $file = JRequest::getVar( 'fimport', '', 'files', 'array' );
    jimport('joomla.filesystem.file');
    $file['name'] = JFile::makeSafe($file['name']);
    $msg = 'Fail importing file!';
    if (isset( $file['name'] )) {
      if ($file['type'] == 'application/vnd.ms-excel' || strpos($file['name'], 'csv') === false) {
        $msg = 'File extension not supported !';
      } else {
        $file_import = JPath::clean( JPATH_BASE.'/tmp/'.strtolower( $file['name'] ) );
        JFile::upload( $file['tmp_name'], $file_import );
        if (file_exists($file_import)) {
          $row = 1;
          $handle = fopen($file_import, "r");
          $db = JFactory::getDBO();
          $headers = $imported = array();
          while (($data = fgetcsv($handle, 100000, ",")) !== FALSE) {
            if (empty($headers)) {
              $headers = $data;
              continue;
            }
            $import =& $imported[];
            foreach ($data as $data_num => $data_value) {
              $import[ $headers[$data_num] ] = $data_value;
            }
            $this->insertData($import);
            //$db->setQuery($q);
            //$db->query();
          }
          fclose($handle);
          $msg = 'File import success !';
        }
      }
    }
    $link = 'index.php?option=com_helloworld';
    $this->setRedirect($link, $msg);
  }
}
