﻿<?php

/**
 * @version		$Id: serial.php 46 2014-07-08 17:27:33Z ht $
 * @package		Joomla16.Tutorials
 * @subpackage	Components
 * @copyright	Copyright (C) 2014 Earthlink Design, Inc. All rights reserved.
 * @author		Hasim Tan
 * @link		http://www.earthlinkdesign.com.au/
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import Joomla controlleradmin library
jimport('joomla.application.component.controlleradmin');

/**
 * HelloWorlds Controller
 */
class HelloWorldControllerSerial extends JControllerLegacy
{
	
	protected $text_prefix = 'COM_HELLOWORLD_SERIAL';
	/**
	 * Proxy for getModel.
	 * @since	1.6
	 */
	 
	public function getModel($name = 'Serial', $prefix = 'HelloWorldModel') 
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
	
	public function update(){
	    $model =  parent::getModel('Serial','HelloWorldModel');
		$msg = $model->setUpdate();
		$link = 'index.php?option=com_helloworld&view=serials';
		$this->setRedirect($link, $msg);
	}
	
	public function savenew(){
	    $model =  parent::getModel('Serial','HelloWorldModel');
		$msg = $model->setNew();
		$link = 'index.php?option=com_helloworld&view=serials';
		$this->setRedirect($link, $msg);
	}
	
	public function delete(){
	    $model =  parent::getModel('Serial','HelloWorldModel');
		$msg = $model->setDelete();
		$link = 'index.php?option=com_helloworld&view=serials';
		$this->setRedirect($link, $msg);
	}
	
	public function cancel() {
        $link = 'index.php?option=com_helloworld&view=serials';
		$this->setRedirect($link);
    }
}
