<?php
/**
* @package Admin-Menu-Manager (com_adminmenumanager)
* @version 2.3.0
* @copyright Copyright (C) 2012 - 2018 Carsten Engel. All rights reserved.
* @license GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html 
* @author http://www.pages-and-items.com
*/


// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class adminmenumanagerController extends JControllerLegacy{

	public $version = '2.3.0';
	public $amm_config;		
	private $amm_demo_seconds_left;	
	private $amm_version_type = 'pro';	//free trial or pro	
	private $helper;
	private $menu_items;
	private $menu_level = 0;	
	private $menu_ordertotal = 0;	

	function display($cachable = false, $urlparams = false){		
		
		$app = JFactory::getApplication();	
		
		//display css
		//not via addDocument else the icon is set to 14 px
		if(JRequest::getVar('layout', '')!='csv'){
			echo '<link rel="stylesheet" href="components/com_adminmenumanager/css/adminmenumanager9.css" type="text/css" />';
			echo '<div class="amm';
			$version = new JVersion;
			if($version->RELEASE >= '3.0'){
				echo ' joomla3';
			}
			echo '">';	
		}			
				
		// Set a default view if none exists			
		if(!JRequest::getVar('view')){						
			JRequest::setVar('view', 'menuitems');								
		}		
		
		//set toolbar
		JToolBarHelper::title('Admin Menu Manager', 'amm_icon');			
		
		if(JRequest::getVar('layout', '')!='csv'){
			$version = new JVersion;
			if($version->RELEASE >= '3.0'){
				//bootstrap selects
				JHtml::_('bootstrap.tooltip');
				JHtml::_('behavior.multiselect');
				JHtml::_('formbehavior.chosen', 'select');
			}else{	
				//make sure mootools is loaded					
				JHTML::_('behavior.mootools');
				
				//load the submenu
				$this->addSubmenu(JRequest::getWord('view', 'adminmenumanager'));
			}
			
			//display messages
			$this->display_header();
		}
		
		parent::display();
		
		if(JRequest::getVar('layout', '')!='csv'){
			echo '</div>';	
		}
		
		//display footer
		if(JRequest::getVar('layout', '')!='csv'){
			$this->display_footer();
		}
				
	}	
	
	function __construct(){	
		
		$this->helper = $this->get_helper();		
		$this->amm_config = $this->helper->get_config();
		
		if($this->amm_version_type=='trial'){	
			$this->amm_check_trial_version();	
		}	
		
		parent::__construct();		
	}	
	
	function addSubmenu($vName = 'adminmenumanager'){	
		JSubMenuHelper::addEntry(
			JText::_('COM_ADMINMENUMANAGER_CONFIG'),
			'index.php?option=com_adminmenumanager&view=configuration',
			$vName == 'configuration'
		);
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);
		$lang->load('com_users', JPATH_ADMINISTRATOR, null, false);
		JSubMenuHelper::addEntry(
			JText::_('JOPTION_MENUS'),
			'index.php?option=com_adminmenumanager&view=menus',
			$vName == 'menus' || $vName == 'menu'
		);		
		JSubMenuHelper::addEntry(
			JText::_('COM_MENUS_SUBMENU_ITEMS'),
			'index.php?option=com_adminmenumanager&view=menuitems',
			$vName == 'menuitems' || $vName == 'menuitem' || $vName == 'menuitemsimport' || $vName == 'menuitemsexport'
		);	
		JSubMenuHelper::addEntry(
			JText::_('COM_MENUS_SUBMENU_ITEMS').' '.JText::_('COM_ADMINMENUMANAGER_IMPORT'),
			'index.php?option=com_adminmenumanager&view=menuitemsimport',
			$vName == 'menuitemsimport'
		);		
		JSubMenuHelper::addEntry(
			JText::_('COM_USERS_SUBMENU_USERS'),
			'index.php?option=com_adminmenumanager&view=users',
			$vName == 'users'
		);		
		JSubMenuHelper::addEntry(
			JText::_('COM_ADMINMENUMANAGER_INFO'),
			'index.php?option=com_adminmenumanager&view=info',
			$vName == 'info'
		);		
	}	
	
	function add_submenu($vName = 'adminmenumanager'){	
	
		$vName = JFactory::getApplication()->input->get('view');
		JHtmlSidebar::addEntry(
			JText::_('COM_ADMINMENUMANAGER_CONFIG'),
			'index.php?option=com_adminmenumanager&view=configuration',
			$vName == 'configuration'
		);
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);
		$lang->load('com_users', JPATH_ADMINISTRATOR, null, false);
		JHtmlSidebar::addEntry(
			JText::_('JOPTION_MENUS'),
			'index.php?option=com_adminmenumanager&view=menus',
			$vName == 'menus' || $vName == 'menu'
		);		
		JHtmlSidebar::addEntry(
			JText::_('COM_MENUS_SUBMENU_ITEMS'),
			'index.php?option=com_adminmenumanager&view=menuitems',
			$vName == 'menuitems' || $vName == 'menuitem' || $vName == 'menuitemsimport' || $vName == 'menuitemsexport'
		);	
		JHtmlSidebar::addEntry(
			JText::_('COM_MENUS_SUBMENU_ITEMS').' '.JText::_('COM_ADMINMENUMANAGER_IMPORT'),
			'index.php?option=com_adminmenumanager&view=menuitemsimport',
			$vName == 'menuitemsimport'
		);			
		JHtmlSidebar::addEntry(
			JText::_('COM_USERS_SUBMENU_USERS'),
			'index.php?option=com_adminmenumanager&view=users',
			$vName == 'users'
		);		
		JHtmlSidebar::addEntry(
			JText::_('COM_ADMINMENUMANAGER_INFO'),
			'index.php?option=com_adminmenumanager&view=info',
			$vName == 'info'
		);		
	}			
	
	function display_header(){					
		
		if(JRequest::getVar('layout')!='csv'){		
			$this->check_demo_time_left();				
		}		
	}					
		
	function config_save(){	
	
		$db = JFactory::getDBO();	
		
		JRequest::checkToken() or jexit('Invalid Token');	
					
		$default_access_type = 'default_access_'.$this->amm_config['based_on'];	
		$this->amm_config['access_enabled'] = JRequest::getVar('access_enabled', '1', 'post');
		$this->amm_config['based_on'] = JRequest::getVar('based_on', '', 'post');
		$this->amm_config['group_inheritance'] = JRequest::getVar('group_inheritance', '', 'post');
		$this->amm_config['super_user_sees_all'] = JRequest::getVar('super_user_sees_all', '', 'post');
		$this->amm_config['level_sort'] = JRequest::getVar('level_sort', '', 'post');		
		$this->amm_config[$default_access_type] = JRequest::getVar('default_access', '', 'post');	
		$this->amm_config['multilanguage'] = JRequest::getVar('multilanguage', '', 'post');	
		$this->amm_config['version_checker'] = JRequest::getVar('version_checker', '', 'post');
		
		$registry = new JRegistry;
		$registry->loadArray($this->amm_config);
		$config = $registry->toString();		
		
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_config');
		$query->set('config='.$db->q($config));
		$query->where('id='.$db->q('amm'));		
		$db->setQuery($query);
		$db->query();

		
		//redirect	
		$url = 'index.php?option=com_adminmenumanager&view=configuration';					
		$this->setRedirect($url, JText::_('COM_ADMINMENUMANAGER_CONFIG').' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));
	}			

	function display_footer(){	
	
		$helper = $this->get_helper();
		
		echo '<div class="amm_clearboth"> </div>';
		echo '<div class="smallgrey" id="amm_footer">';
		echo '<table>';
		echo '<tr>';
		echo '<td class="text_right">';
		echo '<a href="http://www.pages-and-items.com" target="_blank">Admin-Menu-Manager</a>';
		echo '</td>';
		echo '<td class="five_pix">';
		echo '&copy;';
		echo '</td>';
		echo '<td>';
		echo '2012 - 2014 Carsten Engel';		
		echo '</td>';
		echo '</tr>';
		echo '<tr>';
		echo '<td class="text_right">';
		echo $this->amm_strtolower(JText::_('JVERSION'));
		echo '</td>';
		echo '<td class="five_pix">';
		echo '=';
		echo '</td>';
		echo '<td>';
		echo $this->version.' ('.$this->amm_version_type.' '.$this->amm_strtolower(JText::_('JVERSION')).')';
		if($this->amm_version_type!='trial'){
			echo ' <a href="http://www.gnu.org/licenses/gpl-2.0.html" target="blank">GNU/GPL License</a>';
		}
		echo '</td>';
		echo '</tr>';
		//version checker
		if($this->amm_config['version_checker']){
			echo '<tr>';
			echo '<td class="text_right">';
			echo $this->amm_strtolower(JText::_('COM_ADMINMENUMANAGER_LATEST_VERSION'));
			echo '</td>';
			echo '<td class="five_pix">';
			echo '=';
			echo '</td>';
			echo '<td>';
			$app = JFactory::getApplication();
			$latest_version_message = $app->getUserState( "com_adminmenumanager.latest_version_message", '');
			if($latest_version_message==''){
				$latest_version_message = JText::_('COM_ADMINMENUMANAGER_VERSION_CHECKER_NOT_AVAILABLE');
				$url = 'http://www.pages-and-items.com/latest_version.php?extension=adminmenumanager';		
				$file_object = @fopen($url, "r");		
				if($file_object == TRUE){
					$version = fread($file_object, 1000);
					$latest_version_message = $version;
					if($this->version!=$version){
						$latest_version_message .= ' <span class="amm_red">'.JText::_('COM_ADMINMENUMANAGER_NEWER_VERSION').'</span>';
						if($this->amm_version_type=='pro'){
							$download_url = 'http://www.pages-and-items.com/my-extensions';
						}elseif($this->amm_version_type=='trial'){
							$download_url = 'http://engelweb.nl/trialversions/';
						}else{
							$download_url = 'http://www.pages-and-items.com/extensions/admin-menu-manager';
						}
						$latest_version_message .= ' <a href="'.$download_url.'" target="_blank">'.JText::_('COM_ADMINMENUMANAGER_DOWNLOAD').'</a>';						
						if($this->amm_version_type!='pro'){
							$latest_version_message .= ' <a href="index.php?option=com_installer&view=update">'.$this->amm_strtolower(JText::_('JLIB_INSTALLER_UPDATE')).'</a>';
						}
					}else{
						$latest_version_message .= ' <span class="pi_green">'.JText::_('COM_ADMINMENUMANAGER_IS_LATEST_VERSION').'</span>';
					}
					fclose($file_object);
				}				
				$app->setUserState( "com_adminmenumanager.latest_version_message", $latest_version_message );
			}
			echo $latest_version_message;
			echo '</td>';
			echo '</tr>';
		}	
		echo '<tr>';
		echo '<td class="text_right" colspan="2">';
		echo $this->amm_strtolower(JText::_('COM_ADMINMENUMANAGER_REVIEW_B')); 
		echo '</td>';
		echo '<td>';
		if($this->amm_version_type=='pro'){
			$url_jed = '22805';
		}else{
			$url_jed = '21305';
		}		
		echo '<a href="http://extensions.joomla.org/extensions/administration/admin-navigation/'.$url_jed.'" target="_blank">';
		echo 'Joomla! Extensions Directory</a>';
		echo '</td>';
		echo '</tr>';		
		echo '</table>';		
		echo '</div>';			
	}
	
	function ajax_version_checker(){
		$message = JText::_('COM_ADMINMENUMANAGER_VERSION_CHECKER_NOT_AVAILABLE');	
		$url = 'http://www.pages-and-items.com/latest_version.php?extension=adminmenumanager';		
		$file_object = @fopen($url, "r");		
		if($file_object == TRUE){
			$version = fread($file_object, 1000);
			$message = JText::_('COM_ADMINMENUMANAGER_LATEST_VERSION').' = '.$version;
			if($this->version!=$version){
				$message .= '<div><span class="amm_red">'.JText::_('COM_ADMINMENUMANAGER_NEWER_VERSION').'</span>.</div>';
				if($this->amm_version_type=='pro'){
					$download_url = 'http://www.pages-and-items.com/my-extensions';
				}elseif($this->amm_version_type=='trial'){
					$download_url = 'http://engelweb.nl/trialversions/';
				}else{
					$download_url = 'http://www.pages-and-items.com/extensions/admin-menu-manager';
				}
				$message .= '<div><a href="'.$download_url.'" target="_blank">'.JText::_('COM_ADMINMENUMANAGER_DOWNLOAD').'</a></div>';
			}else{
				$message .= '<div><span class="pi_green">'.JText::_('COM_ADMINMENUMANAGER_IS_LATEST_VERSION').'</span>.</div>';
			}
			fclose($file_object);
		}
		
		//reset version checker session
		$app = JFactory::getApplication();
		$app->setUserState( "com_adminmenumanager.latest_version_message", '' );
		
		echo $message;
		exit;
	}
	
	function get_helper(){
		$ds = DIRECTORY_SEPARATOR;
		require_once(JPATH_ROOT.$ds.'administrator'.$ds.'components'.$ds.'com_adminmenumanager'.$ds.'helpers'.$ds.'adminmenumanager.php');
		$helper = new adminmenumanagerHelper();
		return $helper;
	}
	
	function amm_strtolower($string){
		if(function_exists('mb_strtolower')){			
			$string = mb_strtolower($string, 'UTF-8');
		}
		return $string;
	}
	
	function get_version_type(){
		//so that private var is available for templates
		return $this->amm_version_type;
	}
	
	function menu_save(){
	
		$db = JFactory::getDBO();
			
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');
		
		//get vars
		$id = intval(JRequest::getVar('menu_id', 0, 'post'));
		$name = strip_tags(JRequest::getVar('name', '', 'post'));
		$description = strip_tags(JRequest::getVar('description', '', 'post'));		
		
		if($id==0){
			//new 					
			$query = $db->getQuery(true);
			$query->insert('#__adminmenumanager_menus');
			$query->set('name='.$db->q($name));
			$query->set('description='.$db->q($description));
			$query->set('ordering='.$db->q('9999999'));		
			$db->setQuery((string)$query);
			$db->query();
			
			$id = $db->insertid(); 
			
			//rebuild menu ordering
			$this->rebuild_reordering(0, 'adminmenumanager_menus', 'ordering', 'id');
			
		}else{
			//edit	
			$query = $db->getQuery(true);		
			$query->update('#__adminmenumanager_menus');
			$query->set('name='.$db->q($name));
			$query->set('description='.$db->q($description));			
			$query->where('id='.(int)$id);
			$db->setQuery((string)$query);
			$db->query();
		}	
		
		//redirect			
		if(JRequest::getVar('apply', '')){
			$url = 'index.php?option=com_adminmenumanager&view=menu&id='.$id;
		}else{
			$url = 'index.php?option=com_adminmenumanager&view=menus';
		}	
		$this->setRedirect($url, JText::_('COM_ADMINMENUMANAGER_MENU').' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));
	}
	
	function menu_delete(){
		
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');		
		
		if (!is_array($cid) || count($cid) < 1) {
			$lang = JFactory::getLanguage();
			$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);
			echo JText::_('COM_MENUS_NO_MENUS_SELECTED');
			exit();
		}
		
		if (count($cid)){			
			
			//delete menu(s)			
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__adminmenumanager_menus');
			$query->where('id IN (' . implode(',', $cid) . ')');
			$db->setQuery((string)$query);
			$db->query();
			
			//delete menuitems of those deleted menus
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__adminmenumanager_menuitems');
			$query->where('menu IN (' . implode(',', $cid) . ')');
			$db->setQuery((string)$query);
			$db->query();			
			
		}
		
		//rebuild menu ordering
		$this->rebuild_reordering(0, 'adminmenumanager_menus', 'ordering', 'id');
		
		//reset session filter_menu
		$app->setUserState( "com_adminmenumanager.menuitems.filter.menu", '' );
		
		$this->setRedirect("index.php?option=com_adminmenumanager&view=menus", JText::_('COM_ADMINMENUMANAGER_MENU').' '.JText::_('COM_ADMINMENUMANAGER_DELETED'));
	}
	
	function menuitem_unpublish(){
	
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');	
		
		$id = intval(JRequest::getVar('menuitem_id', 0, 'post'));
		
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_menuitems');
		$query->set('published=0');				
		$query->where('id='.(int)$id);
		$db->setQuery((string)$query);
		$db->query();
		
		//redirect
		$url = 'index.php?option=com_adminmenumanager&view=menuitems';	
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);		
		$this->setRedirect($url, $this->amm_strtolower(JText::_('COM_MENUS_ITEM_FIELD_ALIAS_MENU_LABEL')).' '.$this->amm_strtolower(JText::_('JUNPUBLISHED')));

	}
	
	function menuitem_publish(){
	
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');	
		
		$id = intval(JRequest::getVar('menuitem_id', 0, 'post'));
		
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_menuitems');
		$query->set('published=1');				
		$query->where('id='.(int)$id);
		$db->setQuery((string)$query);
		$db->query();
		
		//redirect
		$url = 'index.php?option=com_adminmenumanager&view=menuitems';
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);				
		$this->setRedirect($url, $this->amm_strtolower(JText::_('COM_MENUS_ITEM_FIELD_ALIAS_MENU_LABEL')).' '.$this->amm_strtolower(JText::_('JPUBLISHED')));

	}
	
	function menuitem_save(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
			
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');
		
		//get vars
		$id = intval(JRequest::getVar('menuitem_id', 0, 'post'));
		$title = strip_tags(JRequest::getVar('title', '', 'post'));		
		$menu = intval(JRequest::getVar('menu', '', 'post'));	
		$menu_ori = intval(JRequest::getVar('menu_ori', '', 'post'));	
		$url = strip_tags(JRequest::getVar('url', '', 'post'));
		$icon = strip_tags(JRequest::getVar('icon', '', 'post'));	
		$published = intval(JRequest::getVar('published', '', 'post'));			
		$access = intval(JRequest::getVar('access', '', 'post'));	
		$parentid = intval(JRequest::getVar('parentid', '', 'post'));
		$temp = $this->get_nested($title, 0, $parentid, $id);
		$type = intval(JRequest::getVar('type', 0, 'post'));
		$target = intval(JRequest::getVar('target', 0, 'post'));	
		$width = intval(JRequest::getVar('width', '800', 'post'));
		$height = intval(JRequest::getVar('height', '600', 'post'));
		if($this->amm_version_type=='free'){
			$use_constant = 0;
		}else{
			$use_constant = intval(JRequest::getVar('use_constant', 0, 'post'));
		}
		$constant = strip_tags(JRequest::getVar('constant', '', 'post'));
		
		if($this->amm_config['based_on']=='group'){
			$access_column = 'accessgroup';
		}else{
			$access_column = 'accesslevel';
		}				
		if($id==0){
			//new 					
			$query = $db->getQuery(true);
			$query->insert('#__adminmenumanager_menuitems');
			$query->set('title='.$db->q($title));
			$query->set('use_constant='.$db->q($use_constant));
			$query->set('constant='.$db->q($constant));
			$query->set('icon='.$db->q($icon));
			$query->set('menu='.$menu);	
			$query->set('url='.$db->q($url));
			$query->set('published='.$published);				
			$query->set($access_column.'='.$access);
			$query->set('parentid='.$parentid);		
			$query->set('ordering=9999');
			$query->set('type='.$type);		
			$query->set('target='.$target);	
			$query->set('width='.$width);	
			$query->set('height='.$height);					
			$db->setQuery((string)$query);
			$db->query();
			
			$id = $db->insertid(); 
		}else{
			//edit	
			
			if($menu!=$menu_ori){
				//menu item is moved to different menu
				//so reset the parent
				$parentid = 0;
				//and move all its children as well
				$this->move_children_to_other_menu($id, $menu);								
			}
			
			$query = $db->getQuery(true);		
			$query->update('#__adminmenumanager_menuitems');
			$query->set('title='.$db->q($title));
			$query->set('use_constant='.$db->q($use_constant));
			$query->set('constant='.$db->q($constant));
			$query->set('icon='.$db->q($icon));
			$query->set('menu='.$menu);	
			$query->set('url='.$db->q($url));
			$query->set('published='.$published);
			$query->set($access_column.'='.$access);	
			$query->set('parentid='.$parentid);	
			$query->set('type='.$type);		
			$query->set('target='.$target);	
			$query->set('width='.$width);	
			$query->set('height='.$height);			
			$query->where('id='.(int)$id);
			$db->setQuery((string)$query);
			$db->query();
		}
		
		//set session so that the menu-selector is correct
		$app->setUserState('com_adminmenumanager.menuitems.filter.menu', $menu);
				
		$this->rebuild_menus();	
		
		//redirect	
		if(JRequest::getVar('save_and_new', '')){	
			$url = 'index.php?option=com_adminmenumanager&view=menuitem&id=0&menu='.$menu;
		}elseif(JRequest::getVar('apply', '')){
			$url = 'index.php?option=com_adminmenumanager&view=menuitem&id='.$id;
		}else{			
			$url = 'index.php?option=com_adminmenumanager&view=menuitems';
		}
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);			
		$this->setRedirect($url, $this->amm_strtolower(JText::_('COM_MENUS_ITEM_FIELD_ALIAS_MENU_LABEL')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));
	}
	
	function move_children_to_other_menu($menuitem_id, $menu){
		
		$db = JFactory::getDBO();
		
		//select all children of this parent
		$query = $db->getQuery(true);
		$query->select('id, parentid');
		$query->from('#__adminmenumanager_menuitems');
		$query->where('parentid='.$menuitem_id);		
		$menuitems = $db->setQuery((string)$query);				
		$menuitems = $db->loadObjectList();
			
		foreach($menuitems as $menuitem){
			//update each child
			$query = $db->getQuery(true);		
			$query->update('#__adminmenumanager_menuitems');			
			$query->set('menu='.$menu);			
			$query->where('id='.(int)$menuitem->id);
			$db->setQuery((string)$query);
			$db->query();
		
			//check their children
			$this->move_children_to_other_menu($menuitem->id, $menu);
		}	
	}
	
	function rebuild_menus(){
	
		$db = JFactory::getDBO();		
		
		$query = $db->getQuery(true);
		$query->select('id');
		$query->from('#__adminmenumanager_menus');				
		$menus = $db->setQuery((string)$query);				
		$menus = $db->loadObjectList();		
	
		foreach($menus as $menu){				
			$this->rebuild_menu($menu->id);
		}	
	}
	
	function rebuild_menu($menu){
		
		$db = JFactory::getDBO();
		
		//get all menu items of this menu
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__adminmenumanager_menuitems');
		$query->where('menu='.$menu);
		$query->order('ordering');		
		$menuitems = $db->setQuery((string)$query);				
		$menuitems = $db->loadObjectList();
		
		$this->menu_items = $menuitems;
		$this->menu_level = 0;
		$this->menu_ordertotal = 0;
			
		$this->look_for_children(0);	
			
	}
	
	function look_for_children($parent){
		$this->menu_level = $this->menu_level+1;
		$order = 0;		
		foreach($this->menu_items as $menuitem){
			if($menuitem->parentid==$parent){
				$order = $order + 1;
				$this->update_menuitem($menuitem, $order);
			}
		}
		$this->menu_level = $this->menu_level-1;	
	}	
	
	function get_menu_items_access($query, $groups_array){
		if($this->amm_check_trial_version()){
			$user = JFactory::getUser();
			if($this->amm_config['based_on']=='level'){			
				$groups_levels = implode(',', $user->getAuthorisedViewLevels());
				$access_column = 'accesslevel';
			}else{
				jimport('joomla.access.access');			
				$groups_levels = implode(',', $groups_array);	
				$access_column = 'accessgroup';	
			}
			$query->where($access_column.' IN ('.$groups_levels.')');
		}
		return $query;
	}
	
	function update_menuitem($menuitem, $order){
		
		$db = JFactory::getDBO();
		
		$this->menu_ordertotal = $this->menu_ordertotal + 1;
		
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_menuitems');
		$query->set('level='.$this->menu_level);
		$query->set('ordering='.$order);
		$query->set('ordertotal='.$this->menu_ordertotal);			
		$query->where('id='.(int)$menuitem->id);
		$db->setQuery((string)$query);
		$db->query();
		
		$this->look_for_children($menuitem->id);

	}
	
	function menuitems_delete(){
		
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');		
		
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);
		
		if (!is_array($cid) || count($cid) < 1) {
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}
		
		if (count($cid)){			
			//delete menuitem(s)			
			$query = $db->getQuery(true);
			$query->delete();
			$query->from('#__adminmenumanager_menuitems');
			$query->where('id IN (' . implode(',', $cid) . ')');
			$db->setQuery((string)$query);
			$db->query();
		}
		
		$this->rebuild_menus();			
		$this->setRedirect("index.php?option=com_adminmenumanager&view=menuitems", JText::_('COM_MENUS_SUBMENU_ITEMS').' '.JText::_('COM_ADMINMENUMANAGER_DELETED'));
	}
	
	function menuitems_publish(){
		
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');		
		
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);
		
		if (!is_array($cid) || count($cid) < 1) {
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}
		
		if (count($cid)){			
			//publish menuitem(s)			
			$query = $db->getQuery(true);			
			$query->update('#__adminmenumanager_menuitems');
			$query->set('published=1');
			$query->where('id IN (' . implode(',', $cid) . ')');
			$db->setQuery((string)$query);
			$db->query();
		}
		
		$this->setRedirect("index.php?option=com_adminmenumanager&view=menuitems", JText::_('COM_MENUS_SUBMENU_ITEMS').' '.$this->amm_strtolower(JText::_('JPUBLISHED')));
	}
	
	function menuitems_unpublish(){
		
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');
		
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);		
		
		if (!is_array($cid) || count($cid) < 1) {
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}
		
		if (count($cid)){			
			//publish menuitem(s)			
			$query = $db->getQuery(true);			
			$query->update('#__adminmenumanager_menuitems');
			$query->set('published=0');
			$query->where('id IN (' . implode(',', $cid) . ')');
			$db->setQuery((string)$query);
			$db->query();
		}		
		
		$this->setRedirect('index.php?option=com_adminmenumanager&view=menuitems', JText::_('COM_MENUS_SUBMENU_ITEMS').' '.$this->amm_strtolower(JText::_('JUNPUBLISHED')));
	}
	
	function menuitems_order_save(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		$orders = JRequest::getVar('orders', array(), 'post', 'array');		
		$order_ids = JRequest::getVar('order_ids', array(), 'post', 'array');		
				
		for($n = 0; $n < count($order_ids); $n++){		
			$order = $orders[$n];			
			$order_id = $order_ids[$n];					
			
			$query = $db->getQuery(true);		
			$query->update('#__adminmenumanager_menuitems');
			$query->set('ordering='.$db->q($order));				
			$query->where('id='.(int)$order_id);
			$db->setQuery((string)$query);
			$db->query();				
		}	
		
		$this->rebuild_menu(JRequest::getVar('filter_menu', ''));	
		
		$app->redirect('index.php?option=com_adminmenumanager&view=menuitems', JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED'));
	}
	
	function check_demo_time_left(){			
		if($this->amm_version_type=='trial'){	
			JHtml::_('behavior.tooltip');		
			echo '<p style="text-align: center;" class="amm_red';
			if($this->helper->joomla_version >= '3.0'){
				echo ' trialheader_j3';
			}
			echo '">';									
			echo JText::_('COM_ADMINMENUMANAGER_DEMO_DAYS_LEFT');			
			echo ': ';
			if(round((($this->amm_demo_seconds_left/60)/60)/24)<=0){
				echo '0';
			}else{
				echo round((($this->amm_demo_seconds_left/60)/60)/24);
			}
			echo '<br />';
			echo JText::_('COM_ADMINMENUMANAGER_DEMO_DAYS_LEFT_TIP').'. ';				
			echo '</p>';
		}
	}
	
	function amm_check_trial_version(){
		//config		
		$amm_trial_valid_until = 1301412743;				
		$amm_allow_localhost = true;
		//check trial time left		
		$amm_trial_seconds_left = $amm_trial_valid_until-time();
		//let class know demo time left			
		$this->amm_demo_seconds_left = $amm_trial_seconds_left;		
		//check the trialtime
		$amm_trial_still_valid = false;	
		if(
		//check localhost
		($amm_allow_localhost && ($_SERVER['SERVER_NAME']==='localhost' || $_SERVER['SERVER_NAME']==='127.0.0.1')) ||
		//check demo time 
		$amm_trial_seconds_left >= 0 ||
		//not a trial version
		$this->amm_version_type == 'free' || $this->amm_version_type == 'pro'
		){					
			$amm_trial_still_valid = true;								
		}
		return $amm_trial_still_valid;
	}	
	
	function reorder_listitem(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();	
		
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$id = intval(JRequest::getVar('menuitem_id', '', 'post'));
		$direction = JRequest::getVar('direction', '');
		
		//get data of menuitem to move
		$old_order = 0;
		$menu = 0;
		$parentid = '';
		$query = $db->getQuery(true);
		$query->select('ordering, menu, parentid');
		$query->from('#__adminmenumanager_menuitems');		
		$query->where('id='.$id);		
		$menuitems = $db->setQuery($query, 0, 1);				
		$menuitems = $db->loadObjectList();
		foreach($menuitems as $menuitem){		
			$old_order = $menuitem->ordering;	
			$menu = $menuitem->menu;	
			$parentid = $menuitem->parentid;	
		}	
		
		//calculate new order
		if($direction=='up'){
			$new_order = $old_order-1;	
		}else{
			$new_order = $old_order+1;
		}
	
		//get menuitems
		$query = $db->getQuery(true);
		$query->select('id, ordering');
		$query->from('#__adminmenumanager_menuitems');		
		$query->where('menu='.$menu);
		$query->where('parentid='.$parentid);
		$query->order('ordering');
		$menuitems = $db->setQuery($query);				
		$menuitems = $db->loadObjectList();
			
		//check which id has the new order
		$id_of_menuitem_moving = '';
		foreach($menuitems as $menuitem){			
			if($menuitem->ordering==$new_order){
				$id_of_menuitem_moving = $menuitem->id;
				break;
			}
		}
		
		//update the menuitem
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_menuitems');
		$query->set('ordering='.$new_order);				
		$query->where('id='.$id);
		$db->setQuery($query);
		$db->query();

		
		//update the menuitem which has to switch position
		$query = $db->getQuery(true);		
		$query->update('#__adminmenumanager_menuitems');
		$query->set('ordering='.$old_order);				
		$query->where('id='.$id_of_menuitem_moving);
		$db->setQuery($query);
		$db->query();
		
		$this->rebuild_menu($menu);	
		
		$app->redirect('index.php?option=com_adminmenumanager&view=menuitems', JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED'));	
	}
	
	function menuitem_save_as_copy(){
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');
		
		$id = intval(JRequest::getVar('menuitem_id', '', 'post'));
		$menu = intval(JRequest::getVar('menu', '', 'post'));
		
		$this->copy_menuitem($id);
		
		$this->rebuild_menu($menu);	
		
		$url = 'index.php?option=com_adminmenumanager&view=menuitems';
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);			
		$this->setRedirect($url, $this->amm_strtolower(JText::_('JLIB_HTML_BATCH_COPY')).' '.$this->amm_strtolower(JText::_('COM_MENUS_ITEM_FIELD_ALIAS_MENU_LABEL')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));	
	}
	
	function copy_menuitem($id){
	
		$db = JFactory::getDBO();
		
		//get menuitem data
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__adminmenumanager_menuitems');
		$query->where('id='.$db->q($id));		
		$menuitems = $db->setQuery($query);				
		$menuitems = $db->loadObjectList();
			
		foreach($menuitems as $menuitem){
			$new_title = $this->menuitem_unique_title($menuitem->title, $menuitem->menu);	
			$query = $db->getQuery(true);
			$query->insert('#__adminmenumanager_menuitems');
			$query->set('title='.$db->q($new_title));	
			$query->set('icon='.$db->q($menuitem->icon));	
			$query->set('menu='.$db->q($menuitem->menu));	
			$query->set('url='.$db->q($menuitem->url));	
			$query->set('published='.$db->q($menuitem->published));	
			$query->set('parentid='.$db->q($menuitem->parentid));	
			$query->set('level='.$db->q($menuitem->level));	
			$query->set('ordering='.$db->q($menuitem->ordering+0.5));	
			$query->set('ordertotal='.$db->q($menuitem->ordertotal));	
			$query->set('accessgroup='.$db->q($menuitem->accessgroup));	
			$query->set('accesslevel='.$db->q($menuitem->accesslevel));					
			$db->setQuery((string)$query);
			$db->query();
		}		
	}
	
	function menuitem_unique_title($title, $menu){
	
		$db = JFactory::getDBO();
		
		//get menuitems from that menu
		$query = $db->getQuery(true);
		$query->select('title');
		$query->from('#__adminmenumanager_menuitems');
		$query->where('menu='.$db->q($menu));		
		$titles_array = $db->setQuery($query);				
		$titles_array = $db->loadColumn();	
		
		//take ($nr) from original title
		if(strpos($title, '(') && strpos($title, ')')){			
			$start = strpos($title, '(');
			$end = strpos($title, ')');			
			$nr = substr($title, ($start+1), ($end-$start-1));			
			if(is_numeric($nr)){
				$title = str_replace(' ('.$nr.')', '', $title);
			}
		}
		
		//make new title
		for($n = 2; $n < 50; $n++){
			if(!in_array($title.' ('.$n.')', $titles_array)){
				$new_title = $title.' ('.$n.')';
				break;
			}
		}	
		
		return $new_title;		 
	}
	
	function menuitems_copy(){
	
		$db = JFactory::getDBO();
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');
		$menu = intval(JRequest::getVar('filter_menu', '', 'post'));
		
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);	
		
		if (!is_array($cid) || count($cid) < 1) {
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}		
		
		foreach($cid as $id){
			$this->copy_menuitem($id);
		}
			
		$this->rebuild_menu($menu);	
		
		$url = 'index.php?option=com_adminmenumanager&view=menuitems';		
		$this->setRedirect($url, $this->amm_strtolower(JText::_('JLIB_HTML_BATCH_COPY')).' '.$this->amm_strtolower(JText::_('COM_MENUS_SUBMENU_ITEMS')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));
	}
	
	function menu_save_as_copy(){
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');
		
		$id = intval(JRequest::getVar('menu_id', '', 'post'));		
		
		$this->copy_menu($id);		
		
		$url = 'index.php?option=com_adminmenumanager&view=menus';				
		$this->setRedirect($url, $this->amm_strtolower(JText::_('JLIB_HTML_BATCH_COPY')).' '.$this->amm_strtolower(JText::_('COM_ADMINMENUMANAGER_MENU')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));	
	}
	
	function copy_menu($id){
	
		$db = JFactory::getDBO();
		
		//get menuitem data
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__adminmenumanager_menus');
		$query->where('id='.$db->q($id));		
		$menus = $db->setQuery($query);				
		$menus = $db->loadObjectList();		
		
		foreach($menus as $menu){
			$new_title = $this->menu_unique_title($menu->name);		
			$query = $db->getQuery(true);
			$query->insert('#__adminmenumanager_menus');
			$query->set('name='.$db->q($new_title));	
			$query->set('description='.$db->q($menu->description));	
			$query->set('ordering='.$db->q('9999999'));						
			$db->setQuery((string)$query);
			$db->query();			
			
			//get the id of the new menu
			$new_menu_id = $db->insertid();
			
			//rebuild menu ordering
			$this->rebuild_reordering(0, 'adminmenumanager_menus', 'ordering', 'id');
			
			//get all menuitems of old menu			
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from('#__adminmenumanager_menuitems');
			$query->where('menu='.$db->q($id));		
			$menuitems = $db->setQuery($query);				
			$menuitems = $db->loadObjectList();			
			
			//copy all menuitems to new menu	
			foreach($menuitems as $menuitem){				
				$query = $db->getQuery(true);
				$query->insert('#__adminmenumanager_menuitems');
				$query->set('title='.$db->q($menuitem->title));	
				$query->set('icon='.$db->q($menuitem->icon));	
				$query->set('menu='.$db->q($new_menu_id));	
				$query->set('url='.$db->q($menuitem->url));	
				$query->set('published='.$db->q($menuitem->published));	
				$query->set('parentid='.$db->q($menuitem->parentid));	
				$query->set('level='.$db->q($menuitem->level));	
				$query->set('ordering='.$db->q($menuitem->ordering));	
				$query->set('ordertotal='.$db->q($menuitem->ordertotal));	
				$query->set('accessgroup='.$db->q($menuitem->accessgroup));	
				$query->set('accesslevel='.$db->q($menuitem->accesslevel));					
				$db->setQuery((string)$query);
				$db->query();
			}			
		}		
	}
	
	function menu_unique_title($title){
	
		$db = JFactory::getDBO();
		
		//get menu titles
		$query = $db->getQuery(true);
		$query->select('name');
		$query->from('#__adminmenumanager_menus');				
		$titles_array = $db->setQuery($query);				
		$titles_array = $db->loadColumn();		
		
		//take ($nr) from original title
		if(strpos($title, '(') && strpos($title, ')')){			
			$start = strpos($title, '(');
			$end = strpos($title, ')');			
			$nr = substr($title, ($start+1), ($end-$start-1));			
			if(is_numeric($nr)){
				$title = str_replace(' ('.$nr.')', '', $title);
			}
		}
		
		//make new title
		for($n = 2; $n < 50; $n++){
			if(!in_array($title.' ('.$n.')', $titles_array)){
				$new_title = $title.' ('.$n.')';
				break;
			}
		}
			
		return $new_title;	
	}
	
	function menus_copy(){
	
		$db = JFactory::getDBO();	
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');			
		
		if (!is_array($cid) || count($cid) < 1) {	
			$lang = JFactory::getLanguage();
			$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);		
			echo JText::_('COM_MENUS_NO_MENUS_SELECTED');
			exit();
		}		
		
		foreach($cid as $id){
			$this->copy_menu($id);
		}		
		
		$url = 'index.php?option=com_adminmenumanager&view=menus';		
		$this->setRedirect($url, $this->amm_strtolower(JText::_('JLIB_HTML_BATCH_COPY')).' '.$this->amm_strtolower(JText::_('JOPTION_MENUS')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));
	}
	
	function go_to_menuitems(){
	
		$app = JFactory::getApplication();
		
		$menu = JRequest::getVar('go_to_menu', '');
		if($menu){
			//set session so that the menu-selector is correct
			$app->setUserState('com_adminmenumanager.menuitems.filter.menu', $menu);
		}
		$url = 'index.php?option=com_adminmenumanager&view=menuitems';	
		$this->setRedirect($url);
	}
	
	function reorder_items(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();	
		
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$id = intval(JRequest::getVar('reorder_id', '', 'post'));
		$direction = JRequest::getVar('reorder_direction', '');
		$view = JRequest::getVar('reorder_view', '');
		
		$table = 0;
		$rebuild = 0;
		if($view=='menus'){
			$table = 'adminmenumanager_menus';
			$column_ordering = 'ordering';
			$column_id = 'id';
			$rebuild = 1;
		}	
		
		if($table){			
			
			//get items
			$query = $db->getQuery(true);
			$query->select($column_id.','.$column_ordering);
			$query->from('#__'.$table);		
			$query->order($column_ordering);
			$items = $db->setQuery($query);				
			$items = $db->loadObjectList();
			
			//rebuild ordering
			if($rebuild){
				//rebuild before the swap just in case there are 2 items with the same ordering
				$this->rebuild_reordering($items, $table, $column_ordering, $column_id);
			}
			
			//rebuild into multidimensional array
			$items_array = array();
			$i = 0;
			$index_of_moving_item = 0;
			foreach($items as $item){				
				//set different column name here if needed
				$temp_id = $item->id;
				$temp_ordering = $item->ordering;				
				$items_array[] = array($temp_id, $temp_ordering);			
				if($temp_id==$id){
					$index_of_moving_item = $i;
					$old_order = $temp_ordering;
				}
				$i++;
			}			
			
			//get data of the swap item
			if($direction=='up'){
				$index_of_swap_item = $index_of_moving_item-1;			
			}else{
				$index_of_swap_item = $index_of_moving_item+1;	
			}
			if(isset($items_array[$index_of_swap_item])){
				$swap_item_id = $items_array[$index_of_swap_item][0];
				$new_order = $items_array[$index_of_swap_item][1];
			}
			
			//update the item
			$query = $db->getQuery(true);		
			$query->update('#__'.$table);
			$query->set($column_ordering.'='.$new_order);				
			$query->where($column_id.'='.$id);
			$db->setQuery($query);
			$db->query();
			
			//update the swap item
			$query = $db->getQuery(true);		
			$query->update('#__'.$table);
			$query->set($column_ordering.'='.$old_order);				
			$query->where($column_id.'='.$swap_item_id);
			$db->setQuery($query);
			$db->query();	
			
			//rebuild ordering
			if($rebuild){
				//rebuild after the swap just in case the ordering had different numbers, so they nicely match
				$this->rebuild_reordering($items, $table, $column_ordering, $column_id);
			}	
			unset($items);	
			
			$message = JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED');
		}else{
			$message = 'error saving order';
		}		
		
		$app->redirect('index.php?option=com_adminmenumanager&view='.$view, $message);	
	}
	
	function rebuild_reordering($items_object, $table, $column_ordering, $column_id){
		
		$db = JFactory::getDBO();
		
		if($items_object){
			$items = $items_object;
		}else{
			//need to get the items			
			$query = $db->getQuery(true);
			$query->select($column_id.','.$column_ordering);
			$query->from('#__'.$table);		
			$query->order($column_ordering);
			$items = $db->setQuery($query);				
			$items = $db->loadObjectList();
		}
		
		$i = 1;			
		foreach($items as $item){
					
			//set different column name here if needed
			$temp_id = $item->id;
			$temp_ordering = $item->ordering;
						
			if($temp_ordering!=$i){
				//only update if order does not match						
				$query = $db->getQuery(true);		
				$query->update('#__'.$table);
				$query->set($column_ordering.'='.$i);				
				$query->where($column_id.'='.$temp_id);
				$db->setQuery($query);
				$db->query();
			}			
			$i++;
		}		
		unset($items);	
			
		return true;		
	}
	
	function items_order_save(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		$orders = JRequest::getVar('orders', array(), 'post', 'array');		
		$order_ids = JRequest::getVar('order_ids', array(), 'post', 'array');		
		$view = JRequest::getVar('reorder_view', '');
		
		$table = 0;
		if($view=='menus'){
			$table = 'adminmenumanager_menus';
			$column_ordering = 'ordering';
			$column_id = 'id';
			$rebuild = 1;
		}
		
		if($table){
			for($n = 0; $n < count($order_ids); $n++){		
				$order = $orders[$n];			
				$order_id = $order_ids[$n];					
				
				$query = $db->getQuery(true);		
				$query->update('#__'.$table);
				$query->set($column_ordering.'='.$db->q($order));				
				$query->where($column_id.'='.(int)$order_id);
				$db->setQuery((string)$query);
				$db->query();				
			}	
			
			//rebuild ordering
			if($rebuild){
				//rebuild after the swap just in case the ordering had different numbers, so they nicely match
				$this->rebuild_reordering(0, $table, $column_ordering, $column_id);
			}
			
			$message = JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED');		
		}else{
			$message = 'error saving order';
		}		
		
		$app->redirect('index.php?option=com_adminmenumanager&view='.$view, $message);
	}
	
	function get_nested($id, $hierarchy, $parentid=0, $level=0){
		
		$db = JFactory::getDBO();
		
		$nested = 0;	
		if($hierarchy){
			$temp = 'false';
		}	
		if(!$id){
			$query = $db->getQuery(true);		
			$query->select('id');			
			$query->from('#__adminmenumanager_menuitems');	
			$groups = $this->helper->get_users_groups();			
			$access = '(';				
			for($n = 0; $n < count($groups); $n++){
				if($n){
					$access .= ' OR ';
				}				
				$access .= 'access LIKE '.$db->q('%,'.$groups[$n].',%');				
			}
			$access .= ' OR ';
			$access .= 'access=",all,"';
			$access .= ')';			
			$query->where($access);
			$query->order('ordertotal ASC');		
			$rows = $db->setQuery((string)$query);				
			$nested = $db->loadResult();
		}elseif($hierarchy){			
			if(!$this->amm_check_trial_version()){				
				$nested = strlen($temp);
			}
		}else{			
			$query = $db->getQuery(true);
			$query->select('id');
			$query->from('#__adminmenumanager_menuitems');	
			$q = $this->get_nested($query, 1, 0, $level);		
			$rows = $db->setQuery($query);				
			$rows = $db->loadObjectList();
			$nested = $rows;
			if(count($rows)>=$q && $q){
				//error
				exit;
			}
		}
				
		return $nested;
	}
	
	function menuitemsimport_save(){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();	
		
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');
			
		$type = JRequest::getVar('type', '');
		$menu = intval(JRequest::getVar('menu', ''));
		$published = intval(JRequest::getVar('published', '', 'post'));	
		$access = intval(JRequest::getVar('access', '', 'post'));	
		$parentid = intval(JRequest::getVar('parentid', '', 'post'));
		
		if($this->amm_config['based_on']=='group'){
			$access_column = 'accessgroup';
		}else{
			$access_column = 'accesslevel';
		}
		
		//get heighest_id
		$query = $db->getQuery(true);
		$query->select('id');
		$query->from('#__adminmenumanager_menuitems');			
		$query->order('id DESC');
		$rows = $db->setQuery($query, 0, 1);				
		$rows = $db->loadObjectList();
		
		$heighest_id = 0;
		foreach($rows as $row){		
			$heighest_id = $row->id;	
		}
		
		if($menu){
			if($type=='joomla'){
				$selected_items = JRequest::getVar('joomla_menuitems', null, 'post', 'array');	
				
				//get joomla menu items				
				$joomla_menuitems =	$this->helper->get_joomla_menuitems();					
				
				//loop all menuitems
				$order = 99999;
				for($n = 1; $n <= count($joomla_menuitems); $n++){
					//if selected				
					if(in_array($n, $selected_items)){	
										
						//the parent needs to be in the selected menuitems
						if(in_array($joomla_menuitems[$n][3], $selected_items)){
							$temp_parent = $joomla_menuitems[$n][3]+$heighest_id;
						}else{					
							//no parent or level 1
							$temp_parent = $parentid;
						}
						
						$temp_target = 0;
						if(strpos($joomla_menuitems[$n][2], 'ttp://')){
							$temp_target = 1;
						}												
						
						$query = $db->getQuery(true);
						$query->insert('#__adminmenumanager_menuitems');
						$query->set('id='.($heighest_id+$n));
						$query->set('title='.$db->q($joomla_menuitems[$n][0]));
						$query->set('icon='.$db->q($joomla_menuitems[$n][1]));
						$query->set('menu='.$menu);	
						$query->set('url='.$db->q($joomla_menuitems[$n][2]));
						$query->set('published='.$published);				
						$query->set($access_column.'='.$access);
						$query->set('parentid='.$temp_parent);	
						$query->set('level='.$db->q($joomla_menuitems[$n][4]));	
						$query->set('type='.$db->q($joomla_menuitems[$n][5]));
						$query->set('target='.$temp_target);
						$query->set('ordering='.($n+$order));	
						$query->set('constant='.$db->q($joomla_menuitems[$n][6]));	
						$query->set('use_constant='.$db->q($joomla_menuitems[$n][7]));										
						$db->setQuery((string)$query);
						$db->query();
												
					}
				}
			}elseif($type=='textarea'){
				$textarea_csv = JRequest::getVar('textarea_csv', '');				
				$this->save_csv_menuitems($textarea_csv, $heighest_id, $menu);
			}elseif($type=='file'){
				if(!empty($_FILES['file_csv']['tmp_name'])){
					$file_name = $_FILES['file_csv']['name'];	
					//$file = JPATH_ROOT.$ds.'test.csv';	
					$file = $_FILES['file_csv']['tmp_name'];	
					//echo $file;	
					if(strpos(strtolower($file_name),'.csv') || strpos(strtolower($file_name),'.txt')){
						//.csv or .txt							
						if (!$fp = @fopen($file, "r")) {		
							echo 'can not read from file';
							exit;
						}						
						$lines = fread($fp, filesize($file));											
						fclose ($fp);						
						$lines = mb_convert_encoding($lines, 'ASCII', $this->helper->detect_utf_encoding($file));								
						$this->save_csv_menuitems($lines, $heighest_id, $menu);
					}else{
						//not .csv or .txt
						$lang = JFactory::getLanguage();						
						$lang->load('com_media', JPATH_ADMINISTRATOR, null, false);						
						JError::raiseWarning(403, JText::_('COM_MEDIA_ERROR_WARNFILETYPE'));
						$url = 'index.php?option=com_adminmenumanager&view=menuitems&menu='.$menu;
						$this->setRedirect($url, '');
						return true;
					}					
				}else{
					echo 'error uploading file. probably tmp-folder has not correct rights set.';
					exit;
				}
			}							
			$this->rebuild_menu($menu);
		}
		
		//redirect	
		$url = 'index.php?option=com_adminmenumanager&view=menuitems&menu='.$menu;
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);			
		$this->setRedirect($url, $this->amm_strtolower(JText::_('COM_MENUS_SUBMENU_ITEMS')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));		
	}
		
	function save_csv_menuitems($csv, $heighest_id, $menu){
	
		$db = JFactory::getDBO();

		$lines_temp = explode("\n", $csv);		
		
		//loop lines to get the id's
		$ids = array();
		$lines = array();
		
		foreach($lines_temp as $line){
			//not the header						
			$line = str_replace('"','',$line);
			
			$data = explode(",", $line);			
			if(isset($data[4]) && $line!=''){
				if($data[4]!='published'){					
					$ids[] = $data[0];
					$lines[] = $line;
				}
			}		
		}
		
		//loop lines to do the inserts
		$order = 99999;
		foreach($lines as $line){
			//not the header			
			if(!strpos($line, '"published","parentid"') && $line!=''){					
				$line = str_replace('"','',$line);
				$data = explode(",", $line);

									
				if(isset($data[0])){

				
					//"id","title","icon","url","published","parentid","level","ordering","ordertotal","accessgroup","accesslevel","type","target","width","height","constant","use_constant"
					//the parent needs to be in the selected menuitems
					$temp_parent = 0;					
					if(in_array($data[5], $ids)){
						$temp_parent = $data[5]+$heighest_id;
					}

					$title = $this->helper->string_import($data[1]);
					$url = $this->helper->string_import($data[3]);
					
					//do insert				
					$query = $db->getQuery(true);
					$query->insert('#__adminmenumanager_menuitems');
					$query->set('id='.$db->q($heighest_id+$data[0]));
					$query->set('title='.$db->q($title));
					$query->set('icon='.$db->q($data[2]));
					$query->set('url='.$db->q($url));
					$query->set('published='.$db->q($data[4]));	
					$query->set('parentid='.$db->q($temp_parent));	
					$query->set('level='.$db->q($data[6]));	
					$query->set('menu='.$db->q($menu));	
					$query->set('ordering='.$db->q($order));				
					$query->set('accessgroup='.$db->q($data[9]));	
					$query->set('accesslevel='.$db->q($data[10]));			
					$query->set('type='.$db->q($data[11]));
					$query->set('target='.$db->q($data[12]));
					$query->set('width='.$db->q($data[13]));	
					$query->set('height='.$db->q($data[14]));	
					$query->set('constant='.$db->q($data[15]));
					$query->set('use_constant='.$db->q($data[16]));												
					$db->setQuery((string)$query);
					$db->query();
					
					$order++;
				}
			}		
		}		
	}
	
	function menuitems_export(){
		
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
			
		// Check for request forgeries 
		JRequest::checkToken() or jexit('Invalid Token');			
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');						
		
		if (!is_array($cid) || count($cid) < 1) {
			$lang = JFactory::getLanguage();
			$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);	
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}		
		
		if (count($cid)){	
		
			//make array to string
			$cid_string = implode(',', $cid);
			
			//add string to session
			$app->setUserState( "com_adminmenumanager.cid", $cid_string);
			
			//redirect
			$this->setRedirect('index.php?option=com_adminmenumanager&view=menuitemsexport');	
		}			
	}
	
	function download_csv(){	
		
		JRequest::checkToken() or jexit('Invalid Token');				
		$out = JRequest::getVar('textarea_csv', '');		
		$this->download_file($out, 'csv');
		return true;
	}
	
	function download_txt(){
	
		JRequest::checkToken() or jexit('Invalid Token');				
		$out = JRequest::getVar('textarea_csv', '');		
		$this->download_file($out, 'txt');
		return true;
	}
	
	function download_file($out, $type){		
	
		if(($type!='csv' && $type!='txt') || trim($out)==''){
			echo 'nothing to export or wrong filetype';			
		 	exit;
		}
	
		$out = chr(255).chr(254).mb_convert_encoding( $out, 'UTF-16LE', 'UTF-8');
			
		@ob_end_clean();
		$file_name = 'menuitems_export'.date('YmdHis').'.'.$type;
		@ini_set("zlib.output_compression", "Off");
		header("Content-Type: text/comma-separated-values; charset=utf-8");
		header("Content-Disposition: attachment;filename=\"$file_name\"");
		header("Content-Transfer-Encoding: 8bit");
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: private");
		header("Content-Length: ".strlen($out));
		echo $out;
		exit;
	}
	
	function menuitems_batch_access(){
		
		$this->menuitems_batch_process('access');		
	}
	
	function menuitems_batch_parent(){
	
		$this->menuitems_batch_process('parent');
	}
	
	function menuitems_batch_constant(){
	
		$this->menuitems_batch_process('constant');
	}
	
	private function menuitems_batch_process($type){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		
		JRequest::checkToken() or jexit('Invalid Token');
		
		$cid = JRequest::getVar('cid', null, 'post', 'array');	
		$access = intval(JRequest::getVar('access', '', 'post'));	
		$menu = intval(JRequest::getVar('menu', '', 'post'));	
		$parentid = intval(JRequest::getVar('parentid', '', 'post'));	
		$use_constant = intval(JRequest::getVar('use_constant', '', 'post'));	
		
		$lang = JFactory::getLanguage();
		$lang->load('com_menus', JPATH_ADMINISTRATOR, null, false);	
		
		if (!is_array($cid) || count($cid) < 1) {
			echo JText::_('COM_MENUS_NO_ITEM_SELECTED');
			exit();
		}	
		
		if($this->amm_config['based_on']=='group'){
			$access_column = 'accessgroup';
		}else{
			$access_column = 'accesslevel';
		}	
		
		if(count($cid)){
			
			for($n = 0; $n < count($cid); $n++){
				//do update
				$query = $db->getQuery(true);		
				$query->update('#__adminmenumanager_menuitems');
				if($type=='access'){
					$query->set($access_column.'='.$access);
				}elseif($type=='parent'){			
					$query->set('parentid='.$parentid);	
					$query->set('ordering='.(int)($n+99999));				
				}elseif($type=='constant'){
					$query->set('use_constant='.$db->q($use_constant));					
				}	
				$query->where('id='.(int)$cid[$n]);
				$db->setQuery((string)$query);
				$db->query();
			}			
			
			//rebuild menu
			$this->rebuild_menu($menu);			
		}	
		
		//redirect			
		$this->setRedirect('index.php?option=com_adminmenumanager&view=menuitems', $this->amm_strtolower(JText::_('COM_MENUS_SUBMENU_ITEMS')).' '.JText::_('COM_ADMINMENUMANAGER_SAVED'));	
	}
	
	public function get_menu_items($query){
		
		$db = JFactory::getDBO();
		$loop = 'menus';
		$r = strlen($loop);
		if($this->amm_check_trial_version()){				
			$menuitems = $db->setQuery($query);	
		}else{			
			$menuitems = $db->setQuery($query, 0, $r);
		}					
		$menuitems = $db->loadObjectList();		
		return $menuitems;
	}
	
	public function save_order_ajax_menuitems(){
		
		$db = JFactory::getDBO();
		JRequest::checkToken() or jexit('Invalid Token');

		// Get the arrays from the Request
		$cid = $this->input->post->get('cid', null, 'array');
		$orders = $this->input->post->get('order', null, 'array');
					
		for($n = 0; $n < count($cid); $n++){		
			$order = $orders[$n];			
			$order_id = $cid[$n];					
			
			$query = $db->getQuery(true);		
			$query->update('#__adminmenumanager_menuitems');
			$query->set('ordering='.(int)$order);				
			$query->where('id='.(int)$order_id);
			$db->setQuery((string)$query);
			$db->query();				
		}	
		
		$this->rebuild_menu(JRequest::getVar('filter_menu', ''));	
		echo "1";			
		
		// Close the application
		JFactory::getApplication()->close();
	}
	
	public function save_order_ajax_menus(){
	
		$db = JFactory::getDBO();
		
		JRequest::checkToken() or jexit('Invalid Token');
		
		$cid = $this->input->post->get('cid', null, 'array');
		$order = $this->input->post->get('order', null, 'array');
		
		if(count($cid)){			
			for($n = 0; $n < count($cid); $n++){
				//do update
				$query = $db->getQuery(true);		
				$query->update('#__adminmenumanager_menus');				
				$query->set('ordering='.(int)$order[$n]);
				$query->where('id='.(int)$cid[$n]);
				$db->setQuery((string)$query);
				$db->query();
			}			
			echo "1";
		}	
		
		// Close the application
		JFactory::getApplication()->close();
	}
	
	
	
	
	
	
	
	
	
	
}
?>